/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.test;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;
import org.apache.dubbo.remoting.http12.message.MediaType;

public final class UrlEncodeFormEncoder
implements HttpMessageEncoder {
    public static final UrlEncodeFormEncoder INSTANCE = new UrlEncodeFormEncoder();

    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        try {
            if (data instanceof String) {
                os.write(((String)data).getBytes());
                return;
            }
            if (data instanceof Map) {
                StringBuilder sb = new StringBuilder(64);
                for (Map.Entry entry : ((Map)data).entrySet()) {
                    sb.append(UrlEncodeFormEncoder.encode(entry.getKey())).append('=').append(UrlEncodeFormEncoder.encode(entry.getValue())).append('&');
                }
                int len = sb.length();
                if (len > 1) {
                    os.write(sb.substring(0, len - 1).getBytes(charset));
                }
                return;
            }
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncodeException("Error encoding form-urlencoded", t);
        }
        throw new DecodeException("Only supports String or Map as return type.");
    }

    private static String encode(Object value) throws UnsupportedEncodingException {
        return URLEncoder.encode(String.valueOf(value), StandardCharsets.UTF_8.name());
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_FROM_URLENCODED;
    }
}

