/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.JsonCodec;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.rest.RestHttpMessageCodec;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.test.MockH2StreamChannel;
import org.apache.dubbo.rpc.protocol.tri.test.TestRequest;
import org.apache.dubbo.rpc.protocol.tri.test.TestResponse;
import org.apache.dubbo.rpc.protocol.tri.test.TestRunner;
import org.apache.dubbo.rpc.protocol.tri.test.TestRunnerBuilder;
import org.apache.dubbo.rpc.protocol.tri.test.TestServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.test.UrlEncodeFormEncoder;

final class TestRunnerImpl
implements TestRunner {
    static final Http2InputMessage END = new Http2InputMessageFrame((InputStream)new ByteArrayInputStream(new byte[0]), true);
    private final FrameworkModel frameworkModel = FrameworkModel.defaultModel();
    private final ApplicationModel applicationModel = this.frameworkModel.newApplication();

    TestRunnerImpl(List<TestRunnerBuilder.TProvider<?>> providers) {
        Protocol protocol = (Protocol)this.applicationModel.getExtensionLoader(Protocol.class).getExtension("test");
        ProxyFactory proxy = (ProxyFactory)this.applicationModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        for (TestRunnerBuilder.TProvider<?> provider : providers) {
            this.registerProvider(provider, protocol, proxy);
        }
    }

    private <T> void registerProvider(TestRunnerBuilder.TProvider<T> provider, Protocol protocol, ProxyFactory proxy) {
        Class type = provider.type;
        String typeName = type.getName();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(provider.parameters);
        parameters.put("interface", typeName);
        String contextPath = (String)parameters.get("contextpath");
        String path = contextPath == null ? typeName : contextPath + '/' + typeName;
        URL providerUrl = new URL("test", "127.0.0.1", 8081, path, parameters);
        ModuleServiceRepository serviceRepository = this.applicationModel.getDefaultModule().getServiceRepository();
        ServiceDescriptor serviceDescriptor = serviceRepository.registerService(type);
        ProviderModel providerModel = new ProviderModel(providerUrl.getServiceKey(), provider.service, serviceDescriptor, new ServiceMetadata(), ClassUtils.getClassLoader(type));
        serviceRepository.registerProvider(providerModel);
        providerUrl = providerUrl.setServiceModel((ServiceModel)providerModel);
        protocol.export(proxy.getInvoker(provider.service, type, providerUrl));
    }

    @Override
    public TestResponse run(TestRequest request) {
        StringBuilder sb;
        MockH2StreamChannel channel = new MockH2StreamChannel();
        URL url = new URL("test", "127.0.0.1", 8081, request.getProviderParams());
        TestServerTransportListener listener = new TestServerTransportListener(channel, url, this.frameworkModel);
        if (request.getMethod() == null) {
            request.setMethod(HttpMethods.GET.name());
        }
        String path = request.getPath();
        Assert.notNull((Object)path, (String)"path is required");
        if (!request.getParams().isEmpty()) {
            sb = new StringBuilder(path);
            boolean hasQuery = path.indexOf(63) != -1;
            for (Map.Entry<String, Object> entry : request.getParams().entrySet()) {
                String key = RequestUtils.encodeURL((String)entry.getKey());
                Object value = entry.getValue();
                if (value instanceof List) {
                    for (Object obj : (List)value) {
                        if (obj == null) continue;
                        if (hasQuery) {
                            sb.append('&');
                        } else {
                            hasQuery = true;
                            sb.append('?');
                        }
                        sb.append(key).append('=').append(RequestUtils.encodeURL((String)obj.toString()));
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    for (Object obj : (Object[])value) {
                        if (obj == null) continue;
                        if (hasQuery) {
                            sb.append('&');
                        } else {
                            hasQuery = true;
                            sb.append('?');
                        }
                        sb.append(key).append('=').append(RequestUtils.encodeURL((String)obj.toString()));
                    }
                    continue;
                }
                if (hasQuery) {
                    sb.append('&');
                } else {
                    hasQuery = true;
                    sb.append('?');
                }
                sb.append(key);
                if (value == null) continue;
                sb.append('=').append(RequestUtils.encodeURL((String)value.toString()));
            }
            request.setPath(sb.toString());
        }
        if (!request.getCookies().isEmpty()) {
            sb = new StringBuilder();
            for (Map.Entry<String, String> entry : request.getCookies().entrySet()) {
                sb.append(entry.getKey()).append('=').append(RequestUtils.encodeURL((String)entry.getValue())).append(';');
            }
            request.setHeader("cookie", sb.toString());
        }
        listener.onMetadata((RequestMetadata)request.toMetadata());
        RpcInvocationBuildContext context = listener.getContext();
        JsonCodec decoder = JsonCodec.INSTANCE;
        if (context != null) {
            Object coder;
            UrlEncodeFormEncoder encoder;
            boolean isForm;
            String ct = request.getContentType();
            boolean bl = isForm = ct != null && ct.startsWith(MediaType.APPLICATION_FROM_URLENCODED.getName());
            if (isForm) {
                encoder = UrlEncodeFormEncoder.INSTANCE;
                coder = context.getHttpMessageDecoder();
            } else {
                encoder = context.getHttpMessageEncoder();
                coder = encoder;
            }
            if (coder instanceof RestHttpMessageCodec && (coder = ((RestHttpMessageCodec)coder).getMessageEncoder()) instanceof HttpMessageDecoder) {
                decoder = coder;
            }
            HttpRequest hRequest = (HttpRequest)context.getAttributes().get("tri.http.request");
            if (CollectionUtils.isEmpty(request.getBodies())) {
                if (HttpMethods.supportBody((String)hRequest.method())) {
                    listener.onData((HttpInputMessage)END);
                }
            } else {
                for (Object body : request.getBodies()) {
                    byte[] bytes;
                    if (body instanceof String) {
                        bytes = ((String)body).getBytes(StandardCharsets.UTF_8);
                    } else {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
                        encoder.encode(bos, body);
                        bytes = bos.toByteArray();
                    }
                    listener.onData((HttpInputMessage)new Http2InputMessageFrame((InputStream)new ByteArrayInputStream(bytes), false));
                }
                listener.onData((HttpInputMessage)END);
            }
        }
        return new TestResponse(channel.getHttpMetadata().headers(), channel.getBodies(), (HttpMessageDecoder)decoder);
    }

    @Override
    public <T> T run(TestRequest request, Class<T> type) {
        return this.run(request).getBody(type);
    }

    @Override
    public <T> T get(TestRequest request, Class<T> type) {
        return this.run(request.setMethod(HttpMethods.GET.name()), type);
    }

    @Override
    public String get(TestRequest request) {
        return this.get(request, String.class);
    }

    @Override
    public <T> T get(String path, Class<T> type) {
        return this.get(new TestRequest(path), type);
    }

    @Override
    public <T> List<T> gets(String path, Class<T> type) {
        return this.run(new TestRequest(path).setMethod(HttpMethods.GET.name())).getBodies(type);
    }

    @Override
    public String get(String path) {
        return this.get(new TestRequest(path));
    }

    @Override
    public List<String> gets(String path) {
        return this.gets(path, String.class);
    }

    @Override
    public <T> T post(TestRequest request, Class<T> type) {
        return this.run(request.setMethod(HttpMethods.POST.name()), type);
    }

    @Override
    public String post(TestRequest request) {
        return this.post(request, String.class);
    }

    @Override
    public <T> T post(String path, Object body, Class<T> type) {
        return this.post(new TestRequest(path).setBody(body), type);
    }

    @Override
    public <T> List<T> posts(String path, Object body, Class<T> type) {
        return this.run(new TestRequest(path).setMethod(HttpMethods.POST.name()).setBody(body)).getBodies(type);
    }

    @Override
    public String post(String path, Object body) {
        return this.post(new TestRequest(path).setBody(body));
    }

    @Override
    public List<String> posts(String path, Object body) {
        return this.posts(path, body, String.class);
    }

    @Override
    public <T> T put(TestRequest request, Class<T> type) {
        return this.run(request.setMethod(HttpMethods.PUT.name()), type);
    }

    @Override
    public String put(TestRequest request) {
        return this.put(request, String.class);
    }

    @Override
    public <T> T put(String path, Object body, Class<T> type) {
        return this.put(new TestRequest(path).setBody(body), type);
    }

    @Override
    public String put(String path, Object body) {
        return this.post(new TestRequest(path).setBody(body));
    }

    @Override
    public <T> T patch(TestRequest request, Class<T> type) {
        return this.run(request.setMethod(HttpMethods.PATCH.name()), type);
    }

    @Override
    public String patch(TestRequest request) {
        return this.patch(request, String.class);
    }

    @Override
    public <T> T patch(String path, Object body, Class<T> type) {
        return this.patch(new TestRequest(path).setBody(body), type);
    }

    @Override
    public String patch(String path, Object body) {
        return this.patch(new TestRequest(path).setBody(body));
    }

    @Override
    public <T> T delete(TestRequest request, Class<T> type) {
        return this.run(request.setMethod(HttpMethods.DELETE.name()), type);
    }

    @Override
    public String delete(TestRequest request) {
        return this.delete(request, String.class);
    }

    @Override
    public <T> T delete(String path, Class<T> type) {
        return this.patch(new TestRequest(path), type);
    }

    @Override
    public String delete(String path) {
        return this.delete(new TestRequest(path));
    }

    @Override
    public void destroy() {
        this.applicationModel.destroy();
    }
}

