/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.rpc.protocol.tri.test.TestRunner;
import org.apache.dubbo.rpc.protocol.tri.test.TestRunnerImpl;

public final class TestRunnerBuilder {
    private final List<TProvider<?>> providers = new ArrayList();

    public static TestRunnerBuilder builder() {
        return new TestRunnerBuilder();
    }

    public static TestRunnerBuilder of(Object service) {
        return TestRunnerBuilder.builder().provider(service);
    }

    public static <T> TestRunnerBuilder of(Class<T> type, T service) {
        return TestRunnerBuilder.builder().provider(type, service);
    }

    public <T> TestRunnerBuilder provider(Class<T> type, T service, Map<String, String> parameters) {
        this.providers.add(new TProvider<T>(Objects.requireNonNull(type), Objects.requireNonNull(service), parameters));
        return this;
    }

    public <T> TestRunnerBuilder provider(Class<T> type, T service) {
        return this.provider(type, service, Collections.emptyMap());
    }

    public TestRunnerBuilder provider(Object service, Map<String, String> parameters) {
        Objects.requireNonNull(service);
        Class<?>[] interfaces = service.getClass().getInterfaces();
        this.providers.add(new TProvider<Object>(interfaces[0], service, parameters));
        return this;
    }

    public TestRunnerBuilder provider(Object service) {
        return this.provider(service, Collections.emptyMap());
    }

    public TestRunner build() {
        return new TestRunnerImpl(this.providers);
    }

    static final class TProvider<T> {
        final Class<T> type;
        final T service;
        final Map<String, String> parameters;

        TProvider(Class<T> type, T service, Map<String, String> parameters) {
            this.type = type;
            this.service = service;
            this.parameters = parameters;
        }
    }
}

