/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.test;

import io.netty.handler.codec.http2.Http2Headers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.MediaType;

public class TestResponse {
    private final HttpHeaders headers;
    private final List<OutputStream> oss;
    private final HttpMessageDecoder decoder;
    private List<Object> bodies;

    public TestResponse(HttpHeaders headers, List<OutputStream> oss, HttpMessageDecoder decoder) {
        this.headers = headers;
        this.oss = oss;
        this.decoder = decoder;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.getFirst((CharSequence)name);
    }

    public int getStatus() {
        return Integer.parseInt(this.headers.getFirst((CharSequence)Http2Headers.PseudoHeaderName.STATUS.value()));
    }

    public boolean isOk() {
        return this.getStatus() == 200;
    }

    public String getContentType() {
        return this.headers.getFirst(HttpHeaderNames.CONTENT_TYPE.getKey());
    }

    public <T> T getBody(Class<T> type) {
        int status;
        if (type != String.class && (status = this.getStatus()) >= 400) {
            List<String> bodies = this.getBodies(String.class);
            String message = bodies.isEmpty() ? null : bodies.get(0);
            throw new HttpStatusException(status, "body=" + message);
        }
        List<T> bodies = this.getBodies(type);
        return bodies.isEmpty() ? null : (T)bodies.get(0);
    }

    public <T> List<T> getBodies(Class<T> type) {
        List<Object> bodies = this.bodies;
        if (bodies == null) {
            bodies = new ArrayList<Object>(this.oss.size());
            boolean isTextEvent = MediaType.TEXT_EVENT_STREAM.getName().equals(this.getContentType());
            int size = this.oss.size();
            for (int i = 0; i < size; ++i) {
                ByteArrayOutputStream bos = (ByteArrayOutputStream)this.oss.get(i);
                if (isTextEvent) {
                    String data = new String(bos.toByteArray(), StandardCharsets.UTF_8);
                    if (!data.startsWith("data:")) continue;
                    String body = data.substring(5, data.length() - 2);
                    bodies.add(this.decoder.decode((InputStream)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)), type));
                    continue;
                }
                if (bos.size() == 0) {
                    bodies.add(null);
                    continue;
                }
                bodies.add(this.decoder.decode((InputStream)new ByteArrayInputStream(bos.toByteArray()), type));
            }
            this.bodies = bodies;
        }
        return bodies;
    }

    public String getValue() {
        return this.getBody(String.class);
    }

    public List<String> getValues() {
        return this.getBodies(String.class);
    }

    public Integer getIntValue() {
        return this.getBody(Integer.class);
    }

    public List<Integer> getIntValues() {
        return this.getBodies(Integer.class);
    }

    public Long getLongValue() {
        return this.getBody(Long.class);
    }

    public List<Long> getLongValues() {
        return this.getBodies(Long.class);
    }
}

