/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.test;

import io.netty.handler.codec.http2.Http2Headers;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.message.MediaType;

public class TestRequest {
    private final HttpHeaders headers = HttpHeaders.create();
    private final Map<String, String> cookies = new LinkedHashMap<String, String>();
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();
    private final Map<String, String> providerParams = new LinkedHashMap<String, String>();
    private List<Object> bodies;

    public TestRequest(HttpMethods method, String path) {
        this.setMethod(method);
        this.setPath(path);
    }

    public TestRequest(String path) {
        this.setPath(path);
    }

    public TestRequest() {
    }

    public String getPath() {
        return this.headers.getFirst((CharSequence)Http2Headers.PseudoHeaderName.PATH.value());
    }

    public TestRequest setPath(String path) {
        this.headers.set((CharSequence)Http2Headers.PseudoHeaderName.PATH.value(), path);
        return this;
    }

    public String getMethod() {
        return this.headers.getFirst((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value());
    }

    public TestRequest setMethod(String method) {
        this.headers.set((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value(), method);
        return this;
    }

    public TestRequest setMethod(HttpMethods method) {
        return this.setMethod(method.name());
    }

    public String getContentType() {
        return this.headers.getFirst(HttpHeaderNames.CONTENT_TYPE.getKey());
    }

    public TestRequest setContentType(String contentType) {
        if (StringUtils.isNotEmpty((String)contentType)) {
            this.headers.set(HttpHeaderNames.CONTENT_TYPE.getKey(), contentType);
        }
        return this;
    }

    public TestRequest setContentType(MediaType mediaType) {
        return this.setContentType(mediaType.getName());
    }

    public TestRequest setContentType(MediaType mediaType, String charset) {
        return this.setContentType(mediaType.getName() + "; charset=" + charset);
    }

    public TestRequest setContentType(MediaType mediaType, Charset charset) {
        return this.setContentType(mediaType.getName() + "; charset=" + charset.name());
    }

    public TestRequest setAccept(String accept) {
        if (StringUtils.isNotEmpty((String)accept)) {
            this.headers.set(HttpHeaderNames.ACCEPT.getKey(), accept);
        }
        return this;
    }

    public TestRequest setAccept(MediaType mediaType) {
        return this.setAccept(mediaType.getName());
    }

    public TestRequest setHeader(String name, Object value) {
        if (value != null) {
            this.headers.set((CharSequence)name, value.toString());
        }
        return this;
    }

    public TestRequest setHeaders(Map<String, ?> headers) {
        for (Map.Entry<String, ?> entry : headers.entrySet()) {
            ArrayList<String> items;
            Object value = entry.getValue();
            if (value instanceof List) {
                items = new ArrayList<String>();
                for (Object obj : (List)value) {
                    if (obj == null) continue;
                    items.add(obj.toString());
                }
                this.headers.add((CharSequence)entry.getKey(), items);
                continue;
            }
            if (value instanceof Object[]) {
                items = new ArrayList();
                for (Object obj : (Object[])value) {
                    if (obj == null) continue;
                    items.add(obj.toString());
                }
                this.headers.add((CharSequence)entry.getKey(), items);
                continue;
            }
            if (value == null) continue;
            this.headers.set((CharSequence)entry.getKey(), value.toString());
        }
        return this;
    }

    public TestRequest setCookie(String name, String value) {
        this.cookies.put(name, value);
        return this;
    }

    public TestRequest setCookies(Map<String, String> cookies) {
        this.cookies.putAll(cookies);
        return this;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public TestRequest param(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public TestRequest setParams(Map<String, ?> params) {
        this.params.putAll(params);
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public TestRequest setProviderParam(String name, String value) {
        this.providerParams.put(name, value);
        return this;
    }

    public TestRequest setProviderParams(Map<String, String> params) {
        this.providerParams.putAll(params);
        return this;
    }

    public Map<String, String> getProviderParams() {
        return this.providerParams;
    }

    public TestRequest setBody(Object body) {
        List<Object> bodies = this.bodies;
        if (bodies == null) {
            this.bodies = bodies = new ArrayList<Object>();
        }
        bodies.add(body);
        return this;
    }

    public List<Object> getBodies() {
        return this.bodies;
    }

    public TestRequest post(Object body) {
        this.setMethod(HttpMethods.POST);
        this.setBody(body);
        return this;
    }

    public TestRequest post() {
        this.setMethod(HttpMethods.POST);
        return this;
    }

    public Http2Header toMetadata() {
        return new Http2MetadataFrame(this.headers, !HttpMethods.supportBody((String)this.getMethod()));
    }
}

