/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.test;

import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.rpc.protocol.tri.test.MockHttp2OutputMessage;

public class MockH2StreamChannel
implements H2StreamChannel {
    private HttpMetadata httpMetadata;
    private final List<OutputStream> bodies = new ArrayList<OutputStream>();

    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        if (this.httpMetadata == null) {
            this.httpMetadata = httpMetadata;
        } else {
            this.httpMetadata.headers().add(httpMetadata.headers());
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        this.bodies.add(httpOutputMessage.getBody());
        return CompletableFuture.completedFuture(null);
    }

    public SocketAddress remoteAddress() {
        return InetSocketAddress.createUnresolved("127.0.0.1", 8082);
    }

    public SocketAddress localAddress() {
        return InetSocketAddress.createUnresolved("127.0.0.1", 8081);
    }

    public void flush() {
    }

    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        return CompletableFuture.completedFuture(null);
    }

    public Http2OutputMessage newOutputMessage(boolean endStream) {
        return new MockHttp2OutputMessage(endStream);
    }

    public HttpMetadata getHttpMetadata() {
        return this.httpMetadata;
    }

    public List<OutputStream> getBodies() {
        return this.bodies;
    }
}

