/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.redis.jedis;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.redis.RedisClient;
import org.apache.dubbo.remoting.redis.support.AbstractRedisClient;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class ClusterRedisClient
extends AbstractRedisClient
implements RedisClient {
    private static final Logger logger = LoggerFactory.getLogger(ClusterRedisClient.class);
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final int DEFAULT_SO_TIMEOUT = 2000;
    private static final int DEFAULT_MAX_ATTEMPTS = 5;
    private JedisCluster jedisCluster;

    public ClusterRedisClient(URL url) {
        super(url);
        Set<HostAndPort> nodes = this.getNodes(url);
        this.jedisCluster = new JedisCluster(nodes, url.getParameter("connection.timeout", 2000), url.getParameter("so.timeout", 2000), url.getParameter("max.attempts", 5), url.getPassword(), (GenericObjectPoolConfig)this.getConfig());
    }

    @Override
    public Long hset(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value);
    }

    @Override
    public Long publish(String channel, String message) {
        return this.jedisCluster.publish(channel, message);
    }

    @Override
    public boolean isConnected() {
        Map poolMap = this.jedisCluster.getClusterNodes();
        for (JedisPool jedisPool : poolMap.values()) {
            Jedis jedis = jedisPool.getResource();
            if (!jedis.isConnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.jedisCluster.close();
    }

    @Override
    public Long hdel(String key, String ... fields) {
        return this.jedisCluster.hdel(key, fields);
    }

    @Override
    public Set<String> scan(String pattern) {
        Map nodes = this.jedisCluster.getClusterNodes();
        HashSet<String> result = new HashSet<String>();
        for (JedisPool jedisPool : nodes.values()) {
            Jedis jedis = jedisPool.getResource();
            result.addAll(this.scan(jedis, pattern));
            jedis.close();
        }
        return result;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.jedisCluster.hgetAll(key);
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.jedisCluster.psubscribe(jedisPubSub, patterns);
    }

    @Override
    public void disconnect() {
        this.jedisCluster.close();
    }

    @Override
    public void close() {
        this.jedisCluster.close();
    }

    private Set<HostAndPort> getNodes(URL url) {
        String[] nodes;
        HashSet<HostAndPort> hostAndPorts = new HashSet<HostAndPort>();
        hostAndPorts.add(new HostAndPort(url.getHost(), url.getPort()));
        String backupAddresses = url.getBackupAddress(6379);
        String[] stringArray = nodes = StringUtils.isEmpty((String)backupAddresses) ? new String[]{} : CommonConstants.COMMA_SPLIT_PATTERN.split(backupAddresses);
        if (nodes.length > 0) {
            for (String node : nodes) {
                String[] hostAndPort = CommonConstants.COLON_SPLIT_PATTERN.split(node);
                hostAndPorts.add(new HostAndPort(hostAndPort[0], Integer.valueOf(hostAndPort[1]).intValue()));
            }
        }
        return hostAndPorts;
    }
}

