/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.p2p.support;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.Transporters;
import org.apache.dubbo.remoting.p2p.Group;
import org.apache.dubbo.remoting.p2p.Peer;
import org.apache.dubbo.remoting.p2p.support.ServerPeer;
import org.apache.dubbo.remoting.transport.ChannelHandlerDispatcher;

public abstract class AbstractGroup
implements Group {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractGroup.class);
    protected final URL url;
    protected final Map<URL, RemotingServer> servers = new ConcurrentHashMap<URL, RemotingServer>();
    protected final Map<URL, Client> clients = new ConcurrentHashMap<URL, Client>();
    protected final ChannelHandlerDispatcher dispatcher = new ChannelHandlerDispatcher();

    public AbstractGroup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void close() {
        for (URL url : new ArrayList<URL>(this.servers.keySet())) {
            try {
                this.leave(url);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
        for (URL url : new ArrayList<URL>(this.clients.keySet())) {
            try {
                this.disconnect(url);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
    }

    @Override
    public Peer join(URL url, ChannelHandler handler) throws RemotingException {
        RemotingServer server = this.servers.get(url);
        if (server == null) {
            server = Transporters.bind((URL)url, (ChannelHandler[])new ChannelHandler[]{handler});
            this.servers.put(url, server);
            this.dispatcher.addChannelHandler(handler);
        }
        return new ServerPeer(server, this.clients, this);
    }

    @Override
    public void leave(URL url) throws RemotingException {
        RemotingServer server = this.servers.remove(url);
        if (server != null) {
            server.close();
        }
    }

    protected Client connect(URL url) throws RemotingException {
        if (this.servers.containsKey(url)) {
            return null;
        }
        Client client = this.clients.get(url);
        if (client == null) {
            client = Transporters.connect((URL)url, (ChannelHandler[])new ChannelHandler[]{this.dispatcher});
            this.clients.put(url, client);
        }
        return client;
    }

    protected void disconnect(URL url) throws RemotingException {
        Client client = this.clients.remove(url);
        if (client != null) {
            client.close();
        }
    }
}

