/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.p2p.exchange.support;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.p2p.exchange.ExchangePeer;
import org.apache.dubbo.remoting.p2p.exchange.support.AbstractExchangeGroup;

public class FileExchangeGroup
extends AbstractExchangeGroup {
    private final File file;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(3, (ThreadFactory)new NamedThreadFactory("FileGroupModifiedChecker", true));
    private final ScheduledFuture<?> checkModifiedFuture;
    private volatile long last;

    public FileExchangeGroup(URL url) {
        super(url);
        String path = url.getHost() + "/" + url.getPath();
        this.file = new File(path);
        if (!this.file.exists()) {
            throw new IllegalStateException("The group file not exists. file: " + path);
        }
        this.checkModifiedFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    FileExchangeGroup.this.check();
                }
                catch (Throwable t) {
                    AbstractExchangeGroup.logger.error("Unexpected error occur at reconnect, cause: " + t.getMessage(), t);
                }
            }
        }, 2000L, 2000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        super.close();
        try {
            ExecutorUtil.cancelScheduledFuture(this.checkModifiedFuture);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private void check() throws RemotingException {
        long modified = this.file.lastModified();
        if (modified > this.last) {
            this.last = modified;
            this.changed();
        }
    }

    private void changed() throws RemotingException {
        try {
            String[] lines;
            for (String line : lines = IOUtils.readLines((File)this.file)) {
                this.connect(URL.valueOf((String)line));
            }
        }
        catch (IOException e) {
            throw new RemotingException(new InetSocketAddress(NetUtils.getLocalHost(), 0), this.getUrl().toInetSocketAddress(), e.getMessage(), (Throwable)e);
        }
    }

    public ExchangePeer joinExchange(URL url, ExchangeHandler handler) throws RemotingException {
        ExchangePeer peer = super.join(url, handler);
        try {
            String[] lines;
            String full = url.toFullString();
            for (String line : lines = IOUtils.readLines((File)this.file)) {
                if (!full.equals(line)) continue;
                return peer;
            }
            IOUtils.appendLines((File)this.file, (String[])new String[]{full});
        }
        catch (IOException e) {
            throw new RemotingException(new InetSocketAddress(NetUtils.getLocalHost(), 0), this.getUrl().toInetSocketAddress(), e.getMessage(), (Throwable)e);
        }
        return peer;
    }

    @Override
    public void leave(URL url) throws RemotingException {
        super.leave(url);
        try {
            String full = url.toFullString();
            String[] lines = IOUtils.readLines((File)this.file);
            ArrayList<String> saves = new ArrayList<String>();
            for (String line : lines) {
                if (full.equals(line)) {
                    return;
                }
                saves.add(line);
            }
            IOUtils.appendLines((File)this.file, (String[])saves.toArray(new String[0]));
        }
        catch (IOException e) {
            throw new RemotingException(new InetSocketAddress(NetUtils.getLocalHost(), 0), this.getUrl().toInetSocketAddress(), e.getMessage(), (Throwable)e);
        }
    }
}

