/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metrics.observation.DefaultDubboServerObservationConvention;
import org.apache.dubbo.metrics.observation.DubboObservation;
import org.apache.dubbo.metrics.observation.DubboServerContext;
import org.apache.dubbo.metrics.observation.DubboServerObservationConvention;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate(group={"provider"}, order=-1, onClass={"io.micrometer.observation.NoopObservationRegistry"})
public class ObservationReceiverFilter
implements Filter,
BaseFilter.Listener,
ScopeModelAware {
    private final ObservationRegistry observationRegistry;
    private final DubboServerObservationConvention serverObservationConvention;

    public ObservationReceiverFilter(ApplicationModel applicationModel) {
        this.observationRegistry = (ObservationRegistry)applicationModel.getBeanFactory().getBean(ObservationRegistry.class);
        this.serverObservationConvention = (DubboServerObservationConvention)applicationModel.getBeanFactory().getBean(DubboServerObservationConvention.class);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.observationRegistry == null) {
            return invoker.invoke(invocation);
        }
        DubboServerContext receiverContext = new DubboServerContext(invoker, invocation);
        Observation observation = DubboObservation.SERVER.observation((ObservationConvention)this.serverObservationConvention, (ObservationConvention)DefaultDubboServerObservationConvention.INSTANCE, () -> receiverContext, this.observationRegistry);
        invocation.put(Observation.class, (Object)observation.start());
        return (Result)observation.scoped(() -> invoker.invoke(invocation));
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        Observation observation = (Observation)invocation.get(Observation.class);
        if (observation == null) {
            return;
        }
        observation.stop();
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        Observation observation = (Observation)invocation.get(Observation.class);
        if (observation == null) {
            return;
        }
        observation.error(t);
        observation.stop();
    }
}

