/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.consul;

import com.google.common.base.Charsets;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.cache.KVCache;
import com.orbitz.consul.model.kv.Value;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.TreePathDynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class ConsulDynamicConfiguration
extends TreePathDynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ConsulDynamicConfiguration.class);
    private final Consul client;
    private final KeyValueClient kvClient;
    private final int watchTimeout;
    private final ConcurrentMap<String, ConsulListener> watchers = new ConcurrentHashMap<String, ConsulListener>();

    public ConsulDynamicConfiguration(URL url) {
        super(url);
        this.watchTimeout = url.getParameter("consul-watch-timeout", 60000);
        String host = url.getHost();
        int port = 0 != url.getPort() ? url.getPort() : 8500;
        Consul.Builder builder = Consul.builder().withHostAndPort(HostAndPort.fromParts((String)host, (int)port));
        String token = url.getParameter("token", (String)null);
        if (StringUtils.isNotEmpty((String)token)) {
            builder.withAclToken(token);
        }
        this.client = builder.build();
        this.kvClient = this.client.keyValueClient();
    }

    public String getInternalProperty(String key) {
        logger.info("getting config from: " + key);
        return this.kvClient.getValueAsString(key, Charsets.UTF_8).orElse(null);
    }

    protected boolean doPublishConfig(String pathKey, String content) throws Exception {
        return this.kvClient.putValue(pathKey, content);
    }

    protected String doGetConfig(String pathKey) throws Exception {
        return this.getInternalProperty(pathKey);
    }

    protected boolean doRemoveConfig(String pathKey) throws Exception {
        this.kvClient.deleteKey(pathKey);
        return true;
    }

    protected Collection<String> doGetConfigKeys(String groupPath) {
        List keys = this.kvClient.getKeys(groupPath);
        LinkedList<String> configKeys = new LinkedList<String>();
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            keys.stream().filter(k -> !k.equals(groupPath)).map(k -> k.substring(k.lastIndexOf("/") + 1)).forEach(configKeys::add);
        }
        return configKeys;
    }

    protected void doAddListener(String pathKey, ConfigurationListener listener) {
        logger.info("register listener " + listener.getClass() + " for config with key: " + pathKey);
        ConsulListener watcher = this.watchers.computeIfAbsent(pathKey, k -> new ConsulListener(pathKey));
        watcher.addListener(listener);
    }

    protected void doRemoveListener(String pathKey, ConfigurationListener listener) {
        logger.info("unregister listener " + listener.getClass() + " for config with key: " + pathKey);
        ConsulListener watcher = (ConsulListener)this.watchers.get(pathKey);
        if (watcher != null) {
            watcher.removeListener(listener);
        }
    }

    protected void doClose() throws Exception {
        this.client.destroy();
    }

    private class ConsulListener
    implements ConsulCache.Listener<String, Value> {
        private KVCache kvCache;
        private final Set<ConfigurationListener> listeners = new LinkedHashSet<ConfigurationListener>();
        private final String normalizedKey;

        public ConsulListener(String normalizedKey) {
            this.normalizedKey = normalizedKey;
            this.initKVCache();
        }

        private void initKVCache() {
            this.kvCache = KVCache.newCache((KeyValueClient)ConsulDynamicConfiguration.this.kvClient, (String)this.normalizedKey, (int)ConsulDynamicConfiguration.this.watchTimeout);
            this.kvCache.addListener((ConsulCache.Listener)this);
            this.kvCache.start();
        }

        public void notify(Map<String, Value> newValues) {
            Optional<Value> newValue = newValues.values().stream().filter(value -> value.getKey().equals(this.normalizedKey)).findAny();
            newValue.ifPresent(value -> {
                Optional decodedValue = ((Value)newValue.get()).getValueAsString();
                decodedValue.ifPresent(v -> this.listeners.forEach(l -> {
                    ConfigChangedEvent event = new ConfigChangedEvent(this.normalizedKey, ConsulDynamicConfiguration.this.getGroup(), v, ConfigChangeType.MODIFIED);
                    l.process(event);
                }));
            });
        }

        private void addListener(ConfigurationListener listener) {
            this.listeners.add(listener);
        }

        private void removeListener(ConfigurationListener listener) {
            this.listeners.remove(listener);
        }
    }
}

