/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.apidocs.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.apidocs.annotations.RequestParam;
import org.apache.dubbo.apidocs.annotations.ResponseProperty;
import org.apache.dubbo.apidocs.utils.SimpleTypeImpl;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ClassTypeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassTypeUtil.class);
    public static SerializerFeature[] FAST_JSON_FEATURES = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteEnumUsingName};
    private static final int PROCESS_COUNT_MAX = 10;
    private static final String GENERIC_START_SYMBOL = "<";

    public static String calss2Json(Type genericType, Class<?> classType) {
        Object obj = ClassTypeUtil.initClassTypeWithDefaultValue(genericType, classType, 0);
        return JSON.toJSONString((Object)obj, (SerializerFeature[])FAST_JSON_FEATURES);
    }

    public static Object initClassTypeWithDefaultValue(Type genericType, Class<?> classType, int processCount) {
        Object initResult;
        if (processCount >= 10) {
            LOG.warn("The depth of bean has exceeded 10 layers, the deeper layer will be ignored! Please modify the parameter structure or check whether there is circular reference in bean!");
            return null;
        }
        if (null != (initResult = ClassTypeUtil.initClassTypeWithDefaultValueNoProceeField(genericType, classType, ++processCount))) {
            return initResult;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List<Field> allFields = ClassTypeUtil.getAllFields(null, classType);
        for (Field field2 : allFields) {
            if ("serialVersionUID".equals(field2.getName())) continue;
            if (String.class.isAssignableFrom(field2.getType())) {
                if (field2.isAnnotationPresent(RequestParam.class)) {
                    RequestParam requestParam = field2.getAnnotation(RequestParam.class);
                    result.put(field2.getName(), requestParam.value());
                    continue;
                }
                if (field2.isAnnotationPresent(ResponseProperty.class)) {
                    ResponseProperty responseProperty = field2.getAnnotation(ResponseProperty.class);
                    StringBuilder strValue = new StringBuilder(responseProperty.value());
                    if (StringUtils.isNotBlank((CharSequence)responseProperty.example())) {
                        strValue.append("\u3010example: ").append(responseProperty.example()).append("\u3011");
                    }
                    result.put(field2.getName(), strValue.toString());
                    continue;
                }
                result.put(field2.getName(), ClassTypeUtil.initClassTypeWithDefaultValue(field2.getGenericType(), field2.getType(), processCount));
                continue;
            }
            if ("T".equals(field2.getGenericType().getTypeName())) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                if (actualTypeArguments.length > 0) {
                    if (actualTypeArguments.length == 1) {
                        result.put(field2.getName(), ClassTypeUtil.initClassTypeWithDefaultValue(ClassTypeUtil.makeParameterizedType(actualTypeArguments[0].getTypeName()), ClassTypeUtil.makeClass(pt.getActualTypeArguments()[0].getTypeName()), processCount));
                        continue;
                    }
                    LOG.warn(classType.getName() + "#" + field2.getName() + " generics are not supported temporarily. This property will be ignored");
                    continue;
                }
                result.put(field2.getName(), ClassTypeUtil.initClassTypeWithDefaultValue(field2.getGenericType(), field2.getType(), processCount));
                continue;
            }
            result.put(field2.getName(), ClassTypeUtil.initClassTypeWithDefaultValue(field2.getGenericType(), field2.getType(), processCount));
        }
        return result;
    }

    private static Object initClassTypeWithDefaultValueNoProceeField(Type genericType, Class<?> classType, int processCount) {
        if (Integer.class.isAssignableFrom(classType) || Integer.TYPE.isAssignableFrom(classType)) {
            return 0;
        }
        if (Byte.class.isAssignableFrom(classType) || Byte.TYPE.isAssignableFrom(classType)) {
            return (byte)0;
        }
        if (Long.class.isAssignableFrom(classType) || Long.TYPE.isAssignableFrom(classType)) {
            return 0L;
        }
        if (Double.class.isAssignableFrom(classType) || Double.TYPE.isAssignableFrom(classType)) {
            return 0.0;
        }
        if (Float.class.isAssignableFrom(classType) || Float.TYPE.isAssignableFrom(classType)) {
            return Float.valueOf(0.0f);
        }
        if (String.class.isAssignableFrom(classType)) {
            return "";
        }
        if (Character.class.isAssignableFrom(classType) || Character.TYPE.isAssignableFrom(classType)) {
            return Character.valueOf('c');
        }
        if (Short.class.isAssignableFrom(classType) || Short.TYPE.isAssignableFrom(classType)) {
            return (short)0;
        }
        if (Boolean.class.isAssignableFrom(classType) || Boolean.TYPE.isAssignableFrom(classType)) {
            return false;
        }
        if (Date.class.isAssignableFrom(classType)) {
            return "\u3010" + Date.class.getName() + "\u3011yyyy-MM-dd HH:mm:ss";
        }
        if (LocalDate.class.isAssignableFrom(classType)) {
            return "\u3010" + LocalDate.class.getName() + "\u3011yyyy-MM-dd";
        }
        if (LocalDateTime.class.isAssignableFrom(classType)) {
            return "\u3010" + LocalDateTime.class.getName() + "\u3011yyyy-MM-dd HH:mm:ss";
        }
        if (Enum.class.isAssignableFrom(classType)) {
            ?[] enumConstants = classType.getEnumConstants();
            StringBuilder sb = new StringBuilder("|");
            try {
                Method getName = classType.getMethod("name", new Class[0]);
                for (Object obj : enumConstants) {
                    sb.append(getName.invoke(obj, new Object[0])).append("|");
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("", (Throwable)e);
            }
            return sb.toString();
        }
        if (classType.isArray()) {
            Class<?> arrType = classType.getComponentType();
            Object obj = ClassTypeUtil.initClassTypeWithDefaultValue(null, arrType, processCount);
            return new Object[]{obj};
        }
        if (Collection.class.isAssignableFrom(classType)) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (genericType == null) {
                list.add(new Object());
                return list;
            }
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                String subTypeName = pt.getActualTypeArguments()[0].getTypeName();
                Object obj = ClassTypeUtil.initClassTypeWithDefaultValue(ClassTypeUtil.makeParameterizedType(subTypeName), ClassTypeUtil.makeClass(subTypeName), processCount);
                list.add(obj);
            }
            return list;
        }
        if (Map.class.isAssignableFrom(classType)) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            if (genericType == null) {
                map.put("", new Object());
                return map;
            }
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                String subTypeName = pt.getActualTypeArguments()[1].getTypeName();
                Object objValue = ClassTypeUtil.initClassTypeWithDefaultValue(ClassTypeUtil.makeParameterizedType(subTypeName), ClassTypeUtil.makeClass(subTypeName), processCount);
                map.put("", objValue);
            }
            return map;
        }
        if (CompletableFuture.class.isAssignableFrom(classType)) {
            if (genericType == null) {
                return new Object();
            }
            ParameterizedType pt = (ParameterizedType)genericType;
            String typeName = pt.getActualTypeArguments()[0].getTypeName();
            return ClassTypeUtil.initClassTypeWithDefaultValue(ClassTypeUtil.makeParameterizedType(typeName), ClassTypeUtil.makeClass(typeName), processCount);
        }
        return null;
    }

    public static boolean isBaseType(Object o) {
        return o instanceof Integer || o instanceof Byte || o instanceof Long || o instanceof Double || o instanceof Float || o instanceof Character || o instanceof Short || o instanceof Boolean || o instanceof String;
    }

    public static List<Field> getAllFields(List<Field> fieldList, Class<?> classz) {
        if (classz == null) {
            return fieldList;
        }
        if (fieldList == null) {
            fieldList = new ArrayList<Field>(Arrays.asList(classz.getDeclaredFields()));
        } else {
            fieldList.addAll(Arrays.asList(classz.getDeclaredFields()));
        }
        return ClassTypeUtil.getAllFields(fieldList, classz.getSuperclass());
    }

    public static ParameterizedType makeParameterizedType(String typeName) {
        if (typeName.indexOf(GENERIC_START_SYMBOL) == -1) {
            return null;
        }
        try {
            Class<?> typeClass = Class.forName(typeName.substring(0, typeName.indexOf(GENERIC_START_SYMBOL)));
            String subTypeNames = typeName.substring(typeName.indexOf(GENERIC_START_SYMBOL) + 1, typeName.length() - 1);
            String[] subTypeNamesArray = subTypeNames.split(",");
            Type[] subTypes = ClassTypeUtil.makeSubClass(subTypeNamesArray);
            return ParameterizedTypeImpl.make(typeClass, subTypes, null);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Exception getting generics in completabilefuture", (Throwable)e);
            return null;
        }
    }

    public static Class<?> makeClass(String className) {
        className = className.trim();
        try {
            if (className.indexOf(GENERIC_START_SYMBOL) == -1) {
                return Class.forName(className);
            }
            return Class.forName(className.substring(0, className.indexOf(GENERIC_START_SYMBOL)));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Exception getting generics in completabilefuture", (Throwable)e);
            return null;
        }
    }

    private static Type[] makeSubClass(String ... classNames) {
        Type[] types;
        if (classNames != null) {
            types = new Type[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                String className = classNames[i];
                types[i] = new SimpleTypeImpl(className);
            }
        } else {
            types = new Type[]{};
        }
        return types;
    }
}

