/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.apidocs.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.apidocs.core.beans.ApiCacheItem;
import org.apache.dubbo.apidocs.core.beans.ModuleCacheItem;
import org.apache.dubbo.apidocs.utils.ClassTypeUtil;

public class DubboApiDocsCache {
    private static Map<String, ModuleCacheItem> apiModulesCache = new ConcurrentHashMap<String, ModuleCacheItem>(16);
    private static Map<String, String> apiModulesStrCache = new ConcurrentHashMap<String, String>(16);
    private static Map<String, ApiCacheItem> apiParamsAndRespCache = new ConcurrentHashMap<String, ApiCacheItem>(16);
    private static Map<String, String> apiParamsAndRespStrCache = new ConcurrentHashMap<String, String>(16);
    private static List<ModuleCacheItem> allApiModuleInfo = null;
    private static String basicApiModuleInfo = null;

    public static void addApiModule(String key, ModuleCacheItem moduleCacheItem) {
        apiModulesCache.put(key, moduleCacheItem);
    }

    public static void addApiParamsAndResp(String key, ApiCacheItem apiParamsAndResp) {
        apiParamsAndRespCache.put(key, apiParamsAndResp);
    }

    public static ModuleCacheItem getApiModule(String key) {
        return apiModulesCache.get(key);
    }

    public static String getApiModuleStr(String key) {
        ModuleCacheItem temp;
        String result = apiModulesStrCache.get(key);
        if (result == null && (temp = apiModulesCache.get(key)) != null) {
            result = JSON.toJSONString((Object)temp, (SerializerFeature[])ClassTypeUtil.FAST_JSON_FEATURES);
            apiModulesStrCache.put(key, result);
        }
        return result;
    }

    public static ApiCacheItem getApiParamsAndResp(String key) {
        return apiParamsAndRespCache.get(key);
    }

    public static String getApiParamsAndRespStr(String key) {
        ApiCacheItem temp;
        String result = apiParamsAndRespStrCache.get(key);
        if (result == null && (temp = apiParamsAndRespCache.get(key)) != null) {
            result = JSON.toJSONString((Object)temp, (SerializerFeature[])ClassTypeUtil.FAST_JSON_FEATURES);
            apiParamsAndRespStrCache.put(key, result);
        }
        return result;
    }

    public static String getBasicApiModuleInfo() {
        if (basicApiModuleInfo == null) {
            ArrayList tempList = new ArrayList(apiModulesCache.size());
            apiModulesCache.forEach((k, v) -> tempList.add(v));
            basicApiModuleInfo = JSON.toJSONString(tempList, (SerializerFeature[])ClassTypeUtil.FAST_JSON_FEATURES);
        }
        return basicApiModuleInfo;
    }

    public static List<ModuleCacheItem> getAllApiModuleInfo() {
        if (allApiModuleInfo == null) {
            allApiModuleInfo = new ArrayList<ModuleCacheItem>(apiModulesCache.size());
            apiModulesCache.forEach((k, v) -> allApiModuleInfo.add((ModuleCacheItem)v));
        }
        return allApiModuleInfo;
    }
}

