/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.apidocs.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.apidocs.annotations.ApiDoc;
import org.apache.dubbo.apidocs.annotations.ApiModule;
import org.apache.dubbo.apidocs.annotations.RequestParam;
import org.apache.dubbo.apidocs.core.DubboApiDocsCache;
import org.apache.dubbo.apidocs.core.beans.ApiCacheItem;
import org.apache.dubbo.apidocs.core.beans.ApiParamsCacheItem;
import org.apache.dubbo.apidocs.core.beans.HtmlTypeEnum;
import org.apache.dubbo.apidocs.core.beans.ModuleCacheItem;
import org.apache.dubbo.apidocs.core.beans.ParamBean;
import org.apache.dubbo.apidocs.core.providers.DubboDocProviderImpl;
import org.apache.dubbo.apidocs.core.providers.IDubboDocProvider;
import org.apache.dubbo.apidocs.utils.ClassTypeUtil;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Import;

@Import(value={DubboDocProviderImpl.class})
public class DubboApiDocsAnnotationScanner
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(DubboApiDocsAnnotationScanner.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ApplicationConfig application;
    @Autowired
    private RegistryConfig registry;
    @Autowired
    private ProtocolConfig protocol;

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        IDubboDocProvider dubboDocProvider = (IDubboDocProvider)this.applicationContext.getBean(IDubboDocProvider.class);
        this.exportDubboService(IDubboDocProvider.class, dubboDocProvider, false);
        LOG.info("================= Dubbo API Docs--Start scanning and processing doc annotations ================");
        Map apiModules = this.applicationContext.getBeansWithAnnotation(ApiModule.class);
        apiModules.forEach((key, apiModuleTemp) -> {
            boolean async;
            Service dubboService;
            Class<?> apiModuleClass = AopUtils.isAopProxy((Object)apiModuleTemp) ? AopUtils.getTargetClass((Object)apiModuleTemp) : apiModuleTemp.getClass();
            ApiModule moduleAnn = apiModuleClass.getAnnotation(ApiModule.class);
            if (!apiModuleClass.isAnnotationPresent(Service.class) && !apiModuleClass.isAnnotationPresent(DubboService.class)) {
                LOG.warn("\u3010Warning\u3011" + apiModuleClass.getName() + " @ApiModule annotation is used, but it is not a dubbo provider (without " + Service.class.getName() + " or " + DubboService.class.getName() + " annotation)");
                return;
            }
            if (apiModuleClass.isAnnotationPresent(Service.class)) {
                dubboService = apiModuleClass.getAnnotation(Service.class);
                async = dubboService.async();
            } else {
                dubboService = apiModuleClass.getAnnotation(DubboService.class);
                async = dubboService.async();
            }
            ModuleCacheItem moduleCacheItem = new ModuleCacheItem();
            DubboApiDocsCache.addApiModule(moduleAnn.apiInterface().getCanonicalName(), moduleCacheItem);
            moduleCacheItem.setModuleDocName(moduleAnn.value());
            moduleCacheItem.setModuleClassName(moduleAnn.apiInterface().getCanonicalName());
            moduleCacheItem.setModuleVersion(moduleAnn.version());
            Method[] apiModuleMethods = apiModuleClass.getMethods();
            ArrayList<ApiCacheItem> moduleApiList = new ArrayList<ApiCacheItem>(apiModuleMethods.length);
            moduleCacheItem.setModuleApiList(moduleApiList);
            for (Method method : apiModuleMethods) {
                if (!method.isAnnotationPresent(ApiDoc.class)) continue;
                this.processApiDocAnnotation(method, moduleApiList, moduleAnn, async, moduleCacheItem);
            }
        });
        LOG.info("================= Dubbo API Docs-- doc annotations scanning and processing completed ================");
    }

    private void processApiDocAnnotation(Method method, List<ApiCacheItem> moduleApiList, ApiModule moduleAnn, boolean async, ModuleCacheItem moduleCacheItem) {
        ApiDoc dubboApi = method.getAnnotation(ApiDoc.class);
        ApiCacheItem apiListItem = new ApiCacheItem();
        moduleApiList.add(apiListItem);
        apiListItem.setApiName(method.getName());
        apiListItem.setApiDocName(dubboApi.value());
        apiListItem.setDescription(dubboApi.description());
        apiListItem.setApiVersion(dubboApi.version());
        apiListItem.setApiRespDec(dubboApi.responseClassDescription());
        ApiCacheItem apiParamsAndResp = new ApiCacheItem();
        DubboApiDocsCache.addApiParamsAndResp(moduleAnn.apiInterface().getCanonicalName() + "." + method.getName(), apiParamsAndResp);
        Class<?>[] argsClass = method.getParameterTypes();
        Annotation[][] argsAnns = method.getParameterAnnotations();
        Parameter[] parameters = method.getParameters();
        ArrayList<ApiParamsCacheItem> paramList = new ArrayList<ApiParamsCacheItem>(argsClass.length);
        apiParamsAndResp.setAsync(async);
        apiParamsAndResp.setApiName(method.getName());
        apiParamsAndResp.setApiDocName(dubboApi.value());
        apiParamsAndResp.setApiVersion(dubboApi.version());
        apiParamsAndResp.setApiRespDec(dubboApi.responseClassDescription());
        apiParamsAndResp.setDescription(dubboApi.description());
        apiParamsAndResp.setApiModelClass(moduleCacheItem.getModuleClassName());
        apiParamsAndResp.setParams(paramList);
        apiParamsAndResp.setResponse(ClassTypeUtil.calss2Json(method.getGenericReturnType(), method.getReturnType()));
        StringBuilder methodParamInfoSb = new StringBuilder();
        for (int i = 0; i < argsClass.length; ++i) {
            Class<?> argClass = argsClass[i];
            methodParamInfoSb.append("[").append(i).append("]").append(argClass.getCanonicalName());
            if (i + 1 < argsClass.length) {
                methodParamInfoSb.append(" | ");
            }
            Annotation[] argAnns = argsAnns[i];
            ApiParamsCacheItem paramListItem = new ApiParamsCacheItem();
            paramList.add(paramListItem);
            paramListItem.setParamType(argClass.getCanonicalName());
            paramListItem.setParamIndex(i);
            RequestParam requestParam = null;
            for (Annotation ann : argAnns) {
                if (!(ann instanceof RequestParam)) continue;
                requestParam = (RequestParam)ann;
            }
            ParamBean paramBean = this.processHtmlType(argClass, requestParam, null);
            if (paramBean == null) {
                List<ParamBean> apiParamsList = this.processField(argClass);
                if (apiParamsList == null || apiParamsList.isEmpty()) continue;
                paramListItem.setParamInfo(apiParamsList);
                continue;
            }
            Parameter methodParameter = parameters[i];
            paramListItem.setName(methodParameter.getName());
            paramListItem.setHtmlType(paramBean.getHtmlType().name());
            paramListItem.setAllowableValues(paramBean.getAllowableValues());
            if (requestParam != null) {
                paramListItem.setDocName(requestParam.value());
                paramListItem.setDescription(requestParam.description());
                paramListItem.setExample(requestParam.example());
                paramListItem.setDefaultValue(requestParam.defaultValue());
                paramListItem.setRequired(requestParam.required());
                continue;
            }
            paramListItem.setRequired(false);
        }
        apiParamsAndResp.setMethodParamInfo(methodParamInfoSb.toString());
    }

    private List<ParamBean> processField(Class<?> argClass) {
        ArrayList<ParamBean> apiParamsList = new ArrayList<ParamBean>(16);
        List<Field> allFields = ClassTypeUtil.getAllFields(null, argClass);
        for (Field field : allFields) {
            Object objResult;
            ParamBean paramBean = new ParamBean();
            paramBean.setName(field.getName());
            paramBean.setJavaType(field.getType().getCanonicalName());
            RequestParam requestParam = null;
            if (field.isAnnotationPresent(RequestParam.class)) {
                requestParam = field.getAnnotation(RequestParam.class);
                paramBean.setDocName(requestParam.value());
                paramBean.setRequired(requestParam.required());
                paramBean.setDescription(requestParam.description());
                paramBean.setExample(requestParam.example());
                paramBean.setDefaultValue(requestParam.defaultValue());
            } else {
                paramBean.setRequired(false);
            }
            if (this.processHtmlType(field.getType(), requestParam, paramBean) == null && !ClassTypeUtil.isBaseType(objResult = ClassTypeUtil.initClassTypeWithDefaultValue(field.getGenericType(), field.getType(), 0))) {
                paramBean.setHtmlType(HtmlTypeEnum.TEXT_AREA);
                paramBean.setSubParamsJson(JSON.toJSONString((Object)objResult, (SerializerFeature[])ClassTypeUtil.FAST_JSON_FEATURES));
            }
            apiParamsList.add(paramBean);
        }
        return apiParamsList;
    }

    private ParamBean processHtmlType(Class<?> classType, RequestParam annotation, ParamBean param) {
        if (param == null) {
            param = new ParamBean();
        }
        if (annotation != null) {
            param.setAllowableValues(annotation.allowableValues());
        }
        boolean hasAllowableValues = param.getAllowableValues() != null && param.getAllowableValues().length > 0;
        boolean processed = false;
        if (Integer.class.isAssignableFrom(classType) || Integer.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.NUMBER_INTEGER);
            processed = true;
        } else if (Byte.class.isAssignableFrom(classType) || Byte.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.TEXT_BYTE);
            processed = true;
        } else if (Long.class.isAssignableFrom(classType) || Long.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.NUMBER_INTEGER);
            processed = true;
        } else if (Double.class.isAssignableFrom(classType) || Double.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.NUMBER_DECIMAL);
            processed = true;
        } else if (Float.class.isAssignableFrom(classType) || Float.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.NUMBER_DECIMAL);
            processed = true;
        } else if (String.class.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.TEXT);
            processed = true;
        } else if (Character.class.isAssignableFrom(classType) || Character.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.TEXT_CHAR);
            processed = true;
        } else if (Short.class.isAssignableFrom(classType) || Short.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.NUMBER_INTEGER);
            processed = true;
        }
        if (processed) {
            if (hasAllowableValues) {
                param.setHtmlType(HtmlTypeEnum.SELECT);
            }
            return param;
        }
        if (Boolean.class.isAssignableFrom(classType) || Boolean.TYPE.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.SELECT);
            param.setAllowableValues(new String[]{"true", "false"});
            processed = true;
        } else if (Enum.class.isAssignableFrom(classType)) {
            param.setHtmlType(HtmlTypeEnum.SELECT);
            if (!hasAllowableValues) {
                ?[] enumConstants = classType.getEnumConstants();
                String[] enumAllowableValues = new String[enumConstants.length];
                try {
                    Method getNameMethod = classType.getMethod("name", new Class[0]);
                    for (int i = 0; i < enumConstants.length; ++i) {
                        Object obj = enumConstants[i];
                        enumAllowableValues[i] = (String)getNameMethod.invoke(obj, new Object[0]);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error("", (Throwable)e);
                }
                param.setAllowableValues(enumAllowableValues);
            }
            processed = true;
        }
        if (processed) {
            return param;
        }
        return null;
    }

    private <I, T> void exportDubboService(Class<I> serviceClass, T serviceImplInstance, boolean async) {
        ServiceConfig service = new ServiceConfig();
        service.setApplication(this.application);
        service.setRegistry(this.registry);
        service.setProtocol(this.protocol);
        service.setInterface(serviceClass);
        service.setRef(serviceImplInstance);
        service.setAsync(Boolean.valueOf(async));
        service.export();
    }
}

