/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.util.Watch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import okhttp3.Call;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.k8s.discovery.DiscoveryDruidNodeAndResourceVersion;
import org.apache.druid.k8s.discovery.DiscoveryDruidNodeList;
import org.apache.druid.k8s.discovery.K8sApiClient;
import org.apache.druid.k8s.discovery.K8sDruidNodeAnnouncer;
import org.apache.druid.k8s.discovery.WatchResult;

public class DefaultK8sApiClient
implements K8sApiClient {
    private static final Logger LOGGER = new Logger(DefaultK8sApiClient.class);
    private final ApiClient realK8sClient;
    private final CoreV1Api coreV1Api;
    private final ObjectMapper jsonMapper;

    @Inject
    public DefaultK8sApiClient(ApiClient realK8sClient, @Json ObjectMapper jsonMapper) {
        this.realK8sClient = realK8sClient;
        this.coreV1Api = new CoreV1Api(realK8sClient);
        this.jsonMapper = jsonMapper;
    }

    @Override
    public void patchPod(String podName, String podNamespace, String jsonPatchStr) {
        try {
            this.coreV1Api.patchNamespacedPod(podName, podNamespace, new V1Patch(jsonPatchStr), "true", null, null, null);
        }
        catch (ApiException ex) {
            throw new RE((Throwable)ex, "Failed to patch pod[%s/%s], code[%d], error[%s].", new Object[]{podNamespace, podName, ex.getCode(), ex.getResponseBody()});
        }
    }

    @Override
    public DiscoveryDruidNodeList listPods(String podNamespace, String labelSelector, NodeRole nodeRole) {
        try {
            V1PodList podList = this.coreV1Api.listNamespacedPod(podNamespace, null, null, null, null, labelSelector, Integer.valueOf(0), null, null, null, null);
            Preconditions.checkState((podList != null ? 1 : 0) != 0, (Object)"WTH: NULL podList");
            HashMap<String, DiscoveryDruidNode> allNodes = new HashMap<String, DiscoveryDruidNode>();
            for (V1Pod podDef : podList.getItems()) {
                DiscoveryDruidNode node = this.getDiscoveryDruidNodeFromPodDef(nodeRole, podDef);
                allNodes.put(node.getDruidNode().getHostAndPortToUse(), node);
            }
            return new DiscoveryDruidNodeList(podList.getMetadata().getResourceVersion(), allNodes);
        }
        catch (ApiException ex) {
            throw new RE((Throwable)ex, "Expection in listing pods, code[%d] and error[%s].", new Object[]{ex.getCode(), ex.getResponseBody()});
        }
    }

    private DiscoveryDruidNode getDiscoveryDruidNodeFromPodDef(NodeRole nodeRole, V1Pod podDef) {
        String jsonStr = (String)podDef.getMetadata().getAnnotations().get(K8sDruidNodeAnnouncer.getInfoAnnotation(nodeRole));
        try {
            return (DiscoveryDruidNode)this.jsonMapper.readValue(jsonStr, DiscoveryDruidNode.class);
        }
        catch (JsonProcessingException ex) {
            throw new RE((Throwable)ex, "Failed to deserialize DiscoveryDruidNode[%s]", new Object[]{jsonStr});
        }
    }

    @Override
    public WatchResult watchPods(String namespace, String labelSelector, String lastKnownResourceVersion, final NodeRole nodeRole) {
        try {
            final Watch watch = Watch.createWatch((ApiClient)this.realK8sClient, (Call)this.coreV1Api.listNamespacedPodCall(namespace, null, Boolean.valueOf(true), null, null, labelSelector, null, lastKnownResourceVersion, null, Integer.valueOf(0), Boolean.valueOf(true), null), (Type)new TypeReference<Watch.Response<V1Pod>>(){}.getType());
            return new WatchResult(){
                private Watch.Response<DiscoveryDruidNodeAndResourceVersion> obj;

                @Override
                public boolean hasNext() throws SocketTimeoutException {
                    try {
                        while (watch.hasNext()) {
                            Watch.Response item = watch.next();
                            if (item != null && item.type != null) {
                                DiscoveryDruidNodeAndResourceVersion result = null;
                                if (item.object != null) {
                                    result = new DiscoveryDruidNodeAndResourceVersion(((V1Pod)item.object).getMetadata().getResourceVersion(), DefaultK8sApiClient.this.getDiscoveryDruidNodeFromPodDef(nodeRole, (V1Pod)item.object));
                                } else {
                                    LOGGER.debug("item of type " + item.type + " was NULL when watching nodeRole [%s]", new Object[]{nodeRole});
                                }
                                this.obj = new Watch.Response(item.type, (Object)result);
                                return true;
                            }
                            LOGGER.error("WTH! item or item.type is NULL", new Object[0]);
                        }
                    }
                    catch (RuntimeException ex) {
                        if (ex.getCause() instanceof SocketTimeoutException) {
                            throw (SocketTimeoutException)ex.getCause();
                        }
                        throw ex;
                    }
                    return false;
                }

                @Override
                public Watch.Response<DiscoveryDruidNodeAndResourceVersion> next() {
                    return this.obj;
                }

                @Override
                public void close() {
                    try {
                        watch.close();
                    }
                    catch (IOException ex) {
                        throw new RE((Throwable)ex, "Exception while closing watch.", new Object[0]);
                    }
                }
            };
        }
        catch (ApiException ex) {
            if (ex.getCode() == 410) {
                return null;
            }
            throw new RE((Throwable)ex, "Expection in watching pods, code[%d] and error[%s].", new Object[]{ex.getCode(), ex.getResponseBody()});
        }
    }
}

