/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.sql.http.GetQueriesResponse;
import org.apache.druid.sql.http.QueryInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class GetQueriesResponseTest {
    private static ObjectMapper jsonMapper;

    @BeforeAll
    static void setUp() {
        jsonMapper = TestHelper.makeJsonMapper().registerModules(GetQueriesResponseTest.getJacksonModules());
    }

    @Test
    public void test_serde() throws Exception {
        GetQueriesResponse response = new GetQueriesResponse(Collections.singletonList(new TestQueryInfo("query", "xyz", "abc")));
        GetQueriesResponse response2 = (GetQueriesResponse)jsonMapper.readValue(jsonMapper.writeValueAsBytes((Object)response), GetQueriesResponse.class);
        Assertions.assertEquals((Object)response, (Object)response2);
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(GetQueriesResponse.class).usingGetClass().verify();
    }

    private static List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("TestModule").registerSubtypes(new NamedType[]{new NamedType(TestQueryInfo.class, "test")}));
    }

    static class TestQueryInfo
    implements QueryInfo {
        private final String query;
        private final String identity;
        private final String authenticator;

        @JsonCreator
        public TestQueryInfo(@JsonProperty(value="query") String query, @JsonProperty(value="identity") String identity, @JsonProperty(value="authenticator") String authenticator) {
            this.query = query;
            this.identity = identity;
            this.authenticator = authenticator;
        }

        @JsonProperty
        public String getQuery() {
            return this.query;
        }

        @JsonProperty
        public String getIdentity() {
            return this.identity;
        }

        @JsonProperty
        public String getAuthenticator() {
            return this.authenticator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestQueryInfo that = (TestQueryInfo)o;
            return Objects.equals(this.query, that.query) && Objects.equals(this.identity, that.identity) && Objects.equals(this.authenticator, that.authenticator);
        }

        public int hashCode() {
            return Objects.hash(this.query, this.identity, this.authenticator);
        }
    }
}

