/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.calcite.runtime.Hook;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;

public class QueryLogHook {
    private static final Logger log = new Logger(QueryLogHook.class);
    private final ObjectMapper objectMapper;
    private final List<Query<?>> recordedQueries = Lists.newCopyOnWriteArrayList();

    public QueryLogHook(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<Query<?>> getRecordedQueries() {
        return ImmutableList.copyOf(this.recordedQueries);
    }

    protected void accept(Object query) {
        try {
            this.recordedQueries.add((Query)query);
            log.info("Issued query: %s", new Object[]{this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(query)});
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to serialize query: %s", new Object[]{query});
        }
    }

    public void logQueriesFor(Runnable r) {
        try (Hook.Closeable unhook = Hook.QUERY_PLAN.addThread(this::accept);){
            r.run();
        }
    }

    public void logQueriesForGlobal(Runnable r) {
        try (Hook.Closeable unhook = Hook.QUERY_PLAN.add(this::accept);){
            r.run();
        }
    }
}

