/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.initialization.DruidModule;

public class DruidModuleCollection
implements DruidModule {
    private List<Module> subModules;

    public DruidModuleCollection(List<Module> modules) {
        this.subModules = ImmutableList.copyOf(modules);
    }

    @Inject
    public void cascadeInject(Injector injector) {
        for (Module module : this.subModules) {
            injector.injectMembers((Object)module);
        }
    }

    public final List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
        ArrayList ret = new ArrayList();
        for (Module module : this.subModules) {
            if (!(module instanceof DruidModule)) continue;
            DruidModule druidModule = (DruidModule)module;
            ret.addAll(druidModule.getJacksonModules());
        }
        return ret;
    }

    public final void configure(Binder binder) {
        for (Module module : this.subModules) {
            binder.install(module);
        }
    }

    public static DruidModule of(Module ... modules) {
        return DruidModuleCollection.of(Arrays.asList(modules));
    }

    public static DruidModule of(List<? extends Module> modules) {
        return new DruidModuleCollection(DruidModuleCollection.flatten(modules));
    }

    public static List<Module> flatten(Module ... modules) {
        return DruidModuleCollection.flatten(Arrays.asList(modules));
    }

    public static List<Module> flatten(List<? extends Module> modules) {
        ArrayList<Module> flattenedModules = new ArrayList<Module>(modules.size());
        for (Module module : modules) {
            if (module instanceof DruidModuleCollection) {
                DruidModuleCollection moduleCollection = (DruidModuleCollection)module;
                flattenedModules.addAll(moduleCollection.subModules);
                continue;
            }
            flattenedModules.add(module);
        }
        return flattenedModules;
    }
}

