/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.http.SqlParameter;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;

public abstract class CalciteTestBase {
    public static final List<SqlParameter> DEFAULT_PARAMETERS = ImmutableList.of();
    @TempDir
    private static Path rootTempPath;
    private Path casetempPath;

    @BeforeAll
    public static void setupCalciteProperties() {
        ExpressionProcessing.initializeForTests();
    }

    @BeforeEach
    public void setCaseTempDir(TestInfo testInfo) {
        String methodName = ((Method)testInfo.getTestMethod().get()).getName();
        this.casetempPath = FileUtils.createTempDirInLocation((Path)rootTempPath, (String)methodName).toPath();
    }

    public File newTempFolder() {
        return this.newTempFolder(null);
    }

    public File newTempFolder(String prefix) {
        return FileUtils.createTempDirInLocation((Path)this.casetempPath, (String)prefix);
    }

    public File newTempFile(String prefix) {
        try {
            return Files.createTempFile(this.casetempPath, prefix, null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static DruidExpression makeColumnExpression(String column) {
        return DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)column);
    }

    @Deprecated
    public static DruidExpression makeExpression(String staticExpression) {
        return CalciteTestBase.makeExpression(ColumnType.STRING, staticExpression);
    }

    @Deprecated
    public static DruidExpression makeExpression(ColumnType columnType, String staticExpression) {
        return CalciteTestBase.makeExpression(columnType, null, staticExpression);
    }

    @Deprecated
    public static DruidExpression makeExpression(SimpleExtraction simpleExtraction, String staticExpression) {
        return CalciteTestBase.makeExpression(ColumnType.STRING, simpleExtraction, staticExpression);
    }

    @Deprecated
    public static DruidExpression makeExpression(ColumnType columnType, SimpleExtraction simpleExtraction, String staticExpression) {
        return DruidExpression.ofExpression((ColumnType)columnType, (SimpleExtraction)simpleExtraction, args -> staticExpression, Collections.emptyList());
    }

    protected static ResourceAction viewRead(String viewName) {
        return new ResourceAction(new Resource(viewName, "VIEW"), Action.READ);
    }

    protected static ResourceAction dataSourceRead(String dataSource) {
        return new ResourceAction(new Resource(dataSource, "DATASOURCE"), Action.READ);
    }

    protected static ResourceAction dataSourceWrite(String dataSource) {
        return new ResourceAction(new Resource(dataSource, "DATASOURCE"), Action.WRITE);
    }

    protected static ResourceAction externalRead(String inputSourceType) {
        return new ResourceAction(new Resource(inputSourceType, "EXTERNAL"), Action.READ);
    }

    protected static ResourceAction externalWrite(String inputSourceType) {
        return new ResourceAction(new Resource(inputSourceType, "EXTERNAL"), Action.WRITE);
    }
}

