/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.sql.calcite.schema.PhysicalDatasourceMetadataFactory;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PhysicalDataSourceMetadataFactoryTest {
    private Set<String> segmentDataSourceNames;
    private Set<String> joinableDataSourceNames;
    private SegmentManager segmentManager;
    private JoinableFactory globalTableJoinable;
    private PhysicalDatasourceMetadataFactory datasourceMetadataFactory;

    @Before
    public void setUp() {
        this.segmentDataSourceNames = Sets.newConcurrentHashSet();
        this.joinableDataSourceNames = Sets.newConcurrentHashSet();
        this.segmentManager = new SegmentManager((SegmentCacheManager)EasyMock.createMock(SegmentCacheManager.class)){

            public Set<String> getDataSourceNames() {
                return PhysicalDataSourceMetadataFactoryTest.this.segmentDataSourceNames;
            }
        };
        this.globalTableJoinable = new JoinableFactory(){

            public boolean isDirectlyJoinable(DataSource dataSource) {
                return dataSource instanceof GlobalTableDataSource && PhysicalDataSourceMetadataFactoryTest.this.joinableDataSourceNames.contains(((GlobalTableDataSource)dataSource).getName());
            }

            public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
                return Optional.empty();
            }
        };
        this.datasourceMetadataFactory = new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager);
    }

    @Test
    public void testBuild() {
        this.segmentDataSourceNames.add("foo");
        this.joinableDataSourceNames.add("foo");
        RowSignature fooSignature = RowSignature.builder().add("c1", ColumnType.FLOAT).add("c2", ColumnType.DOUBLE).build();
        RowSignature barSignature = RowSignature.builder().add("d1", ColumnType.FLOAT).add("d2", ColumnType.DOUBLE).build();
        DatasourceTable.PhysicalDatasourceMetadata fooDs = this.datasourceMetadataFactory.build("foo", fooSignature);
        Assert.assertTrue((boolean)fooDs.isJoinable());
        Assert.assertTrue((boolean)fooDs.isBroadcast());
        Assert.assertEquals((Object)fooDs.dataSource().getName(), (Object)"foo");
        Assert.assertEquals((Object)fooDs.getRowSignature(), (Object)fooSignature);
        DatasourceTable.PhysicalDatasourceMetadata barDs = this.datasourceMetadataFactory.build("bar", barSignature);
        Assert.assertFalse((boolean)barDs.isJoinable());
        Assert.assertFalse((boolean)barDs.isBroadcast());
        Assert.assertEquals((Object)barDs.dataSource().getName(), (Object)"bar");
        Assert.assertEquals((Object)barDs.getRowSignature(), (Object)barSignature);
    }
}

