/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.NamedSystemSchema;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.easymock.EasyMock;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NamedSystemSchemaTest
extends CalciteTestBase {
    private static final String SCHEMA_NAME = "sys";
    @Mock
    private SystemSchema systemSchema;
    private PlannerConfig plannerConfig;
    private NamedSystemSchema target;

    @BeforeEach
    public void setUp() {
        this.plannerConfig = (PlannerConfig)EasyMock.createMock(PlannerConfig.class);
        this.target = new NamedSystemSchema(this.plannerConfig, this.systemSchema);
    }

    @Test
    public void testGetSchemaNameShouldReturnName() {
        Assert.assertEquals((Object)SCHEMA_NAME, (Object)this.target.getSchemaName());
    }

    @Test
    public void testGetSchemaShouldReturnSchema() {
        Assert.assertEquals((Object)this.systemSchema, (Object)this.target.getSchema());
    }

    @Test
    public void testResourceTypeAuthDisabled() {
        EasyMock.expect((Object)this.plannerConfig.isAuthorizeSystemTablesDirectly()).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{this.plannerConfig});
        Assert.assertNull((Object)this.target.getSchemaResourceType("servers"));
        EasyMock.verify((Object[])new Object[]{this.plannerConfig});
    }

    @Test
    public void testResourceTypeAuthEnabled() {
        EasyMock.expect((Object)this.plannerConfig.isAuthorizeSystemTablesDirectly()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{this.plannerConfig});
        Assert.assertEquals((Object)"SYSTEM_TABLE", (Object)this.target.getSchemaResourceType("servers"));
        EasyMock.verify((Object[])new Object[]{this.plannerConfig});
    }
}

