/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.Properties;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class BrokerSegmentMetadataCacheConfigTest {
    private static final String CONFIG_BASE = "druid.sql.planner";

    @Test
    public void testDefaultConfig() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, BrokerSegmentMetadataCacheConfig.class);
        Properties properties = new Properties();
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        BrokerSegmentMetadataCacheConfig config = (BrokerSegmentMetadataCacheConfig)provider.get();
        Assert.assertTrue((boolean)config.isAwaitInitializationOnStart());
        Assert.assertFalse((boolean)config.isMetadataSegmentCacheEnable());
        Assert.assertEquals((Object)Period.minutes((int)1), (Object)config.getMetadataRefreshPeriod());
        Assert.assertEquals((Object)new AbstractSegmentMetadataCache.LeastRestrictiveTypeMergePolicy(), (Object)config.getMetadataColumnTypeMergePolicy());
    }

    @Test
    public void testCustomizedConfig() {
        Injector injector = this.createInjector();
        JsonConfigProvider provider = JsonConfigProvider.of((String)CONFIG_BASE, BrokerSegmentMetadataCacheConfig.class);
        Properties properties = new Properties();
        properties.setProperty("druid.sql.planner.metadataColumnTypeMergePolicy", "latestInterval");
        properties.setProperty("druid.sql.planner.metadataRefreshPeriod", "PT2M");
        properties.setProperty("druid.sql.planner.awaitInitializationOnStart", "false");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        BrokerSegmentMetadataCacheConfig config = (BrokerSegmentMetadataCacheConfig)provider.get();
        Assert.assertFalse((boolean)config.isAwaitInitializationOnStart());
        Assert.assertFalse((boolean)config.isMetadataSegmentCacheEnable());
        Assert.assertEquals((Object)Period.minutes((int)2), (Object)config.getMetadataRefreshPeriod());
        Assert.assertEquals((Object)new AbstractSegmentMetadataCache.FirstTypeMergePolicy(), (Object)config.getMetadataColumnTypeMergePolicy());
    }

    private Injector createInjector() {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> JsonConfigProvider.bind((Binder)binder, (String)CONFIG_BASE, BrokerSegmentMetadataCacheConfig.class)));
    }
}

