/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.sql.calcite.run.SqlResults;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class SqlResultsTest
extends InitializedNullHandlingTest {
    private static final SqlResults.Context DEFAULT_CONTEXT = new SqlResults.Context(DateTimeZone.UTC, false);
    private ObjectMapper jsonMapper;

    @Before
    public void setUp() {
        this.jsonMapper = TestHelper.JSON_MAPPER;
    }

    @Test
    public void testCoerceStringArrays() {
        List<String> stringList = Arrays.asList("x", "y", "z", null);
        Object[] stringArray = new Object[]{"x", "y", "z", null};
        String[] stringArray2 = new String[]{"x", "y", "z", null};
        this.assertCoerceArrayToList(stringList, stringList);
        this.assertCoerceArrayToList(stringList, stringArray);
        this.assertCoerceArrayToList(stringList, stringArray2);
        this.assertCoerceArrayToList(null, null);
        this.assertCoerceArrayToList(Collections.singletonList("a"), "a");
    }

    @Test
    public void testCoerceLongArrays() {
        List<Long> listWithNull = Arrays.asList(1L, 2L, null, 3L);
        Long[] arrayWithNull = new Long[]{1L, 2L, null, 3L};
        List<Long> list = Arrays.asList(1L, 2L, 3L);
        long[] array = new long[]{1L, 2L, 3L};
        this.assertCoerceArrayToList(listWithNull, listWithNull);
        this.assertCoerceArrayToList(listWithNull, arrayWithNull);
        this.assertCoerceArrayToList(list, list);
        this.assertCoerceArrayToList(list, array);
        this.assertCoerceArrayToList(null, null);
        this.assertCoerceArrayToList(Collections.singletonList(1L), 1L);
    }

    @Test
    public void testCoerceDoubleArrays() {
        List<Double> listWithNull = Arrays.asList(1.1, 2.2, null, 3.3);
        Double[] arrayWithNull = new Double[]{1.1, 2.2, null, 3.3};
        List<Double> list = Arrays.asList(1.1, 2.2, 3.3);
        double[] array = new double[]{1.1, 2.2, 3.3};
        this.assertCoerceArrayToList(listWithNull, listWithNull);
        this.assertCoerceArrayToList(listWithNull, arrayWithNull);
        this.assertCoerceArrayToList(list, list);
        this.assertCoerceArrayToList(list, array);
        this.assertCoerceArrayToList(null, null);
        this.assertCoerceArrayToList(Collections.singletonList(1.1), 1.1);
    }

    @Test
    public void testCoerceFloatArrays() {
        List<Float> listWithNull = Arrays.asList(Float.valueOf(1.1f), Float.valueOf(2.2f), null, Float.valueOf(3.3f));
        Float[] arrayWithNull = new Float[]{Float.valueOf(1.1f), Float.valueOf(2.2f), null, Float.valueOf(3.3f)};
        List<Float> list = Arrays.asList(Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f));
        float[] array = new float[]{1.1f, 2.2f, 3.3f};
        this.assertCoerceArrayToList(listWithNull, listWithNull);
        this.assertCoerceArrayToList(listWithNull, arrayWithNull);
        this.assertCoerceArrayToList(list, list);
        this.assertCoerceArrayToList(list, array);
        this.assertCoerceArrayToList(null, null);
        this.assertCoerceArrayToList(Collections.singletonList(Float.valueOf(1.1f)), Float.valueOf(1.1f));
    }

    @Test
    public void testCoerceNestedArrays() {
        List<List> nestedList = Arrays.asList(Arrays.asList(1L, 2L, 3L), Arrays.asList(4L, 5L, 6L));
        Object[] nestedArray = new Object[]{new Object[]{1L, 2L, 3L}, new Object[]{4L, 5L, 6L}};
        this.assertCoerceArrayToList(nestedList, nestedList);
        this.assertCoerceArrayToList(nestedList, nestedArray);
    }

    @Test
    public void testCoerceBoolean() {
        this.assertCoerce(false, false, SqlTypeName.BOOLEAN);
        this.assertCoerce(false, "xyz", SqlTypeName.BOOLEAN);
        this.assertCoerce(false, 0, SqlTypeName.BOOLEAN);
        this.assertCoerce(false, "false", SqlTypeName.BOOLEAN);
        this.assertCoerce(true, true, SqlTypeName.BOOLEAN);
        this.assertCoerce(true, "true", SqlTypeName.BOOLEAN);
        this.assertCoerce(true, 1, SqlTypeName.BOOLEAN);
        this.assertCoerce(true, 1.0, SqlTypeName.BOOLEAN);
        this.assertCoerce(null, null, SqlTypeName.BOOLEAN);
        this.assertCannotCoerce(Collections.emptyList(), SqlTypeName.BOOLEAN);
    }

    @Test
    public void testCoerceInteger() {
        this.assertCoerce(0, 0, SqlTypeName.INTEGER);
        this.assertCoerce(1, 1L, SqlTypeName.INTEGER);
        this.assertCoerce(1, Float.valueOf(1.0f), SqlTypeName.INTEGER);
        this.assertCoerce(1, "1", SqlTypeName.INTEGER);
        this.assertCoerce(null, "1.1", SqlTypeName.INTEGER);
        this.assertCoerce(null, "xyz", SqlTypeName.INTEGER);
        this.assertCoerce(null, null, SqlTypeName.INTEGER);
        this.assertCannotCoerce(Collections.emptyList(), SqlTypeName.INTEGER);
        this.assertCannotCoerce(false, SqlTypeName.INTEGER);
    }

    @Test
    public void testCoerceBigint() {
        this.assertCoerce(0L, 0, SqlTypeName.BIGINT);
        this.assertCoerce(1L, 1L, SqlTypeName.BIGINT);
        this.assertCoerce(1L, Float.valueOf(1.0f), SqlTypeName.BIGINT);
        this.assertCoerce(null, "1.1", SqlTypeName.BIGINT);
        this.assertCoerce(null, "xyz", SqlTypeName.BIGINT);
        this.assertCoerce(null, null, SqlTypeName.BIGINT);
        this.assertCoerce(0L, false, SqlTypeName.BIGINT);
        this.assertCoerce(1L, true, SqlTypeName.BIGINT);
        this.assertCannotCoerce(Collections.emptyList(), SqlTypeName.BIGINT);
        this.assertCannotCoerce(new byte[]{-32, 79}, SqlTypeName.BIGINT);
    }

    @Test
    public void testCoerceFloat() {
        this.assertCoerce(Float.valueOf(0.0f), 0, SqlTypeName.FLOAT);
        this.assertCoerce(Float.valueOf(1.0f), 1L, SqlTypeName.FLOAT);
        this.assertCoerce(Float.valueOf(1.0f), Float.valueOf(1.0f), SqlTypeName.FLOAT);
        this.assertCoerce(Float.valueOf(1.1f), "1.1", SqlTypeName.FLOAT);
        this.assertCoerce(null, "xyz", SqlTypeName.FLOAT);
        this.assertCoerce(null, null, SqlTypeName.FLOAT);
        this.assertCannotCoerce(Collections.emptyList(), SqlTypeName.FLOAT);
        this.assertCannotCoerce(false, SqlTypeName.FLOAT);
    }

    @Test
    public void testCoerceDouble() {
        this.assertCoerce(0.0, 0, SqlTypeName.DOUBLE);
        this.assertCoerce(1.0, 1L, SqlTypeName.DOUBLE);
        this.assertCoerce(1.0, Float.valueOf(1.0f), SqlTypeName.DOUBLE);
        this.assertCoerce(1.1, "1.1", SqlTypeName.DOUBLE);
        this.assertCoerce(null, "xyz", SqlTypeName.DOUBLE);
        this.assertCoerce(null, null, SqlTypeName.DOUBLE);
        this.assertCannotCoerce(Collections.emptyList(), SqlTypeName.DOUBLE);
        this.assertCannotCoerce(false, SqlTypeName.DOUBLE);
    }

    @Test
    public void testCoerceString() {
        this.assertCoerce(null, null, SqlTypeName.VARCHAR);
        this.assertCoerce("1", 1, SqlTypeName.VARCHAR);
        this.assertCoerce("true", true, SqlTypeName.VARCHAR);
        this.assertCoerce("abc", "abc", SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\",\"def\"]", ImmutableList.of((Object)"abc", (Object)"def"), SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\",\"def\"]", ImmutableSortedSet.of((Comparable)((Object)"abc"), (Comparable)((Object)"def")), SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\",\"def\"]", new String[]{"abc", "def"}, SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\",\"def\"]", new Object[]{"abc", "def"}, SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\"]", ImmutableList.of((Object)"abc"), SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\"]", ImmutableSortedSet.of((Comparable)((Object)"abc")), SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\"]", new String[]{"abc"}, SqlTypeName.VARCHAR);
        this.assertCoerce("[\"abc\"]", new Object[]{"abc"}, SqlTypeName.VARCHAR);
        this.assertCannotCoerce(new Object(), SqlTypeName.VARCHAR);
    }

    @Test
    public void testCoerceOfArrayOfPrimitives() {
        try {
            this.assertCoerce("", new byte[1], SqlTypeName.BIGINT);
            Assert.fail((String)"Should throw an exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot coerce field [fieldName] from type [Byte Array] to type [BIGINT]", (Object)e.getMessage());
        }
    }

    @Test
    public void testCoerceUnsupportedType() {
        this.assertCannotCoerce("xyz", SqlTypeName.VARBINARY);
    }

    @Test
    public void testMayNotCoerceList() {
        Assert.assertEquals((Object)"hello", (Object)SqlResults.coerceArrayToList((Object)"hello", (boolean)false));
    }

    @Test
    public void testContextEqualsAndHashcode() {
        EqualsVerifier.forClass(SqlResults.Context.class).usingGetClass().verify();
    }

    private void assertCoerce(Object expected, Object toCoerce, SqlTypeName typeName) {
        Assert.assertEquals((String)StringUtils.format((String)"Coerce [%s] to [%s]", (Object[])new Object[]{toCoerce, typeName}), (Object)expected, (Object)SqlResults.coerce((ObjectMapper)this.jsonMapper, (SqlResults.Context)DEFAULT_CONTEXT, (Object)toCoerce, (SqlTypeName)typeName, (String)"fieldName"));
    }

    private void assertCannotCoerce(Object toCoerce, SqlTypeName typeName) {
        DruidException e = (DruidException)Assert.assertThrows((String)StringUtils.format((String)"Coerce [%s] to [%s]", (Object[])new Object[]{toCoerce, typeName}), DruidException.class, () -> SqlResults.coerce((ObjectMapper)this.jsonMapper, (SqlResults.Context)DEFAULT_CONTEXT, (Object)toCoerce, (SqlTypeName)typeName, (String)""));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot coerce")));
    }

    private void assertCoerceArrayToList(Object expected, Object toCoerce) {
        Object coerced = SqlResults.coerce((ObjectMapper)this.jsonMapper, (SqlResults.Context)DEFAULT_CONTEXT, (Object)toCoerce, (SqlTypeName)SqlTypeName.ARRAY, (String)"");
        Assert.assertEquals((Object)expected, (Object)coerced);
    }
}

