/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rule.DruidLogicalValuesRule;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DruidLogicalValuesRuleTest {
    private static final PlannerContext DEFAULT_CONTEXT = (PlannerContext)Mockito.mock(PlannerContext.class);

    public static class GetValueFromLiteralOtherTypesTest {
        private static final PlannerContext DEFAULT_CONTEXT = (PlannerContext)Mockito.mock(PlannerContext.class);
        private static final DateTimeZone TIME_ZONE = DateTimes.inferTzFromString((String)"Asia/Seoul");
        private static final RelDataTypeFactory TYPE_FACTORY = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE);
        private static final RexBuilder REX_BUILDER = new RexBuilder(TYPE_FACTORY);
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @BeforeClass
        public static void setup() {
            Mockito.when((Object)DEFAULT_CONTEXT.getTimeZone()).thenReturn((Object)TIME_ZONE);
        }

        @Test
        public void testGetValueFromTrueLiteral() {
            RexLiteral literal = REX_BUILDER.makeLiteral(true);
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)1L, (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromFalseLiteral() {
            RexLiteral literal = REX_BUILDER.makeLiteral(false);
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)0L, (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromNullBooleanLiteral() {
            RexLiteral literal = REX_BUILDER.makeLiteral(null, REX_BUILDER.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN));
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertNull((Object)fromLiteral);
        }

        @Test
        public void testGetValueFromTimestampLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimestampLiteral(new TimestampString("2021-04-01 16:54:31"), 0);
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)new DateTime((Object)"2021-04-01T16:54:31", TIME_ZONE).getMillis(), (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromDateLiteral() {
            RexLiteral literal = REX_BUILDER.makeDateLiteral(new DateString("2021-04-01"));
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)new DateTime((Object)"2021-04-01", TIME_ZONE).getMillis(), (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromTimestampWithLocalTimeZoneLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimestampWithLocalTimeZoneLiteral(new TimestampString("2021-04-01 16:54:31"), 0);
            this.expectedException.expect((Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Cannot handle literal [2021-04-01 16:54:31:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)] of unsupported type [TIMESTAMP_WITH_LOCAL_TIME_ZONE]."));
            DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
        }

        @Test
        public void testGetValueFromTimeLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimeLiteral(new TimeString("16:54:31"), 0);
            this.expectedException.expect((Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Cannot handle literal [16:54:31] of unsupported type [TIME]."));
            DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
        }

        @Test
        public void testGetValueFromTimeWithLocalTimeZoneLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimeWithLocalTimeZoneLiteral(new TimeString("16:54:31"), 0);
            this.expectedException.expect((Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Cannot handle literal [16:54:31:TIME_WITH_LOCAL_TIME_ZONE(0)] of unsupported type [TIME_WITH_LOCAL_TIME_ZONE]."));
            DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
        }

        @Test
        public void testGetCastedValuesFromFloatToNumeric() {
            RexLiteral literal = REX_BUILDER.makeExactLiteral(new BigDecimal("123.0"), TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER));
            Object value = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertEquals((Object)value, (Object)123L);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class GetValueFromLiteralSimpleTypesTest
    extends InitializedNullHandlingTest {
        private final Comparable<?> val;
        private final SqlTypeName sqlTypeName;
        private final Class<?> javaType;

        @Parameterized.Parameters(name="{1}, {2}")
        public static Iterable<Object[]> constructorFeeder() {
            return ImmutableList.of((Object)new Object[]{"test", SqlTypeName.CHAR, String.class}, (Object)new Object[]{"test", SqlTypeName.VARCHAR, String.class}, (Object)new Object[]{0.1, SqlTypeName.DOUBLE, Double.class}, (Object)new Object[]{0.1, SqlTypeName.REAL, Double.class}, (Object)new Object[]{0.1, SqlTypeName.DECIMAL, Double.class}, (Object)new Object[]{1L, SqlTypeName.TINYINT, Long.class}, (Object)new Object[]{1L, SqlTypeName.SMALLINT, Long.class}, (Object)new Object[]{1L, SqlTypeName.INTEGER, Long.class}, (Object)new Object[]{1L, SqlTypeName.BIGINT, Long.class});
        }

        public GetValueFromLiteralSimpleTypesTest(Comparable<?> val, SqlTypeName sqlTypeName, Class<?> javaType) {
            this.val = val;
            this.sqlTypeName = sqlTypeName;
            this.javaType = javaType;
        }

        @Test
        public void testGetValueFromLiteral() {
            RexLiteral literal = (RexLiteral)Mockito.spy((Object)GetValueFromLiteralSimpleTypesTest.makeLiteral(this.val, this.sqlTypeName, this.javaType));
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(this.javaType, fromLiteral.getClass());
            Assert.assertEquals(this.val, (Object)fromLiteral);
            ((RexLiteral)Mockito.verify((Object)literal, (VerificationMode)Mockito.times((int)1))).getType();
        }

        private static RexLiteral makeLiteral(Comparable<?> val, SqlTypeName typeName, Class<?> javaType) {
            return (RexLiteral)new RexBuilder(DruidTypeSystem.TYPE_FACTORY).makeLiteral((Object)(typeName == SqlTypeName.DECIMAL && val != null ? new BigDecimal(String.valueOf(val)) : val), DruidTypeSystem.TYPE_FACTORY.createSqlType(typeName), false);
        }
    }
}

