/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.sql.calcite.planner.ExpressionParser;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerToolbox;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidCorrelateUnnestRel;
import org.apache.druid.sql.calcite.rel.DruidJoinQueryRel;
import org.apache.druid.sql.calcite.rel.DruidOuterQueryRel;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidUnionDataSourceRel;
import org.apache.druid.sql.calcite.rel.DruidUnionRel;
import org.apache.druid.sql.calcite.rel.DruidUnnestRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.logical.DruidUnion;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DruidRelTest {
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("col1", ColumnType.LONG).build();
    private static final RelDataType LONG_TYPE = new BasicSqlType(RelDataTypeSystem.DEFAULT, SqlTypeName.BIGINT);
    private static final RelDataTypeFieldImpl COL1_FIELD = new RelDataTypeFieldImpl("col1", 0, LONG_TYPE);
    private static final RelRecordType REC_TYPE = new RelRecordType(StructKind.NONE, (List)ImmutableList.of((Object)COL1_FIELD), true);
    private static final RelDataTypeFactory DEFAULT_TYPE_FACTORY = new JavaTypeFactoryImpl();
    private static final RexLiteral ALWAYS_TRUE = new RexBuilder(DEFAULT_TYPE_FACTORY).makeLiteral(true);
    private static final Expr EXPR_6L = ExprEval.ofLong((Number)6).toExpr();
    private static final TableDataSource TABLE = TableDataSource.create((String)"restricted_foo");
    private static final RestrictedDataSource RESTRICTED = RestrictedDataSource.create((DataSource)TABLE, (Policy)CalciteTests.POLICY_RESTRICTION);
    private static final DatasourceTable.PhysicalDatasourceMetadata RESTRICTED_METADATA = new DatasourceTable.PhysicalDatasourceMetadata(TABLE, ROW_SIGNATURE, true, false);
    private static final DruidTable DRUID_TABLE = new DatasourceTable(RESTRICTED_METADATA);
    private static final ImmutableMap<String, Optional<Policy>> RESTRICTIONS = ImmutableMap.of((Object)"restricted_foo", Optional.of(CalciteTests.POLICY_RESTRICTION));
    private static final AuthorizationResult AUTHORIZATION_RESULT = AuthorizationResult.allowWithRestriction(RESTRICTIONS);
    @Mock
    private RelOptTable mockRelOptTable;
    @Mock
    private RelOptCluster mockRelOptCluster;
    @Mock
    private RelTraitSet mockRelTraitSet;
    @Mock
    private PlannerContext mockPlannerContext;
    private DruidQueryRel druidQueryRelNode;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.mockRelOptCluster.getTypeFactory()).thenReturn((Object)DEFAULT_TYPE_FACTORY);
        Mockito.when((Object)this.mockRelOptTable.getRowType()).thenReturn((Object)REC_TYPE);
        PlannerToolbox mockPlannerToolbox = (PlannerToolbox)Mockito.mock(PlannerToolbox.class);
        Mockito.when((Object)mockPlannerToolbox.getPolicyEnforcer()).thenReturn((Object)NoopPolicyEnforcer.instance());
        Mockito.when((Object)this.mockPlannerContext.getPlannerToolbox()).thenReturn((Object)mockPlannerToolbox);
        Mockito.when((Object)this.mockPlannerContext.getPlannerConfig()).thenReturn((Object)PlannerConfig.builder().build());
        Mockito.when((Object)this.mockPlannerContext.getJsonMapper()).thenReturn((Object)JsonMapper.builder().build());
        Mockito.when((Object)this.mockPlannerContext.getAuthorizationResult()).thenReturn((Object)AUTHORIZATION_RESULT);
        LogicalTableScan logicalTableScan = new LogicalTableScan(this.mockRelOptCluster, this.mockRelTraitSet, (List)ImmutableList.of(), this.mockRelOptTable);
        this.druidQueryRelNode = DruidQueryRel.scanTable((LogicalTableScan)logicalTableScan, (RelOptTable)this.mockRelOptTable, (DruidTable)DRUID_TABLE, (PlannerContext)this.mockPlannerContext);
    }

    @Test
    public void testDruidQueryRel() {
        DruidQuery queryForExplaining = this.druidQueryRelNode.toDruidQueryForExplaining();
        DruidQuery query = this.druidQueryRelNode.toDruidQuery(true);
        Assert.assertEquals((Object)TABLE, (Object)queryForExplaining.getDataSource());
        Assert.assertEquals((Object)RESTRICTED, (Object)query.getDataSource());
    }

    @Test
    public void testDruidJoinQueryRel() {
        Mockito.when((Object)this.mockPlannerContext.getJoinAlgorithm()).thenReturn((Object)JoinAlgorithm.SORT_MERGE);
        this.mockExpressionParser();
        LogicalJoin logicalJoin = LogicalJoin.create((RelNode)this.druidQueryRelNode, (RelNode)this.druidQueryRelNode, (List)ImmutableList.of(), (RexNode)ALWAYS_TRUE, (Set)ImmutableSet.of(), (JoinRelType)JoinRelType.INNER);
        DruidJoinQueryRel joinRel = DruidJoinQueryRel.create((Join)logicalJoin, null, (PlannerContext)this.mockPlannerContext);
        DruidQuery queryForExplaining = joinRel.toDruidQueryForExplaining();
        DruidQuery query = joinRel.toDruidQuery(false);
        Assert.assertEquals((Object)DruidJoinQueryRel.DUMMY_DATA_SOURCE, (Object)queryForExplaining.getDataSource());
        JoinDataSource dataSource = (JoinDataSource)query.getDataSource();
        Assert.assertEquals((Object)RESTRICTED, (Object)((QueryDataSource)dataSource.getLeft()).getQuery().getDataSource());
        Assert.assertEquals((Object)RESTRICTED, (Object)((QueryDataSource)dataSource.getRight()).getQuery().getDataSource());
    }

    @Test
    public void testDruidUnionQueryRel() {
        DruidUnion union = new DruidUnion(this.mockRelOptCluster, this.mockRelTraitSet, (List)ImmutableList.of(), (List)ImmutableList.of((Object)this.druidQueryRelNode, (Object)this.druidQueryRelNode), true);
        DruidUnionDataSourceRel rel = DruidUnionDataSourceRel.create((Union)union, (List)ImmutableList.of((Object)"col1"), (PlannerContext)this.mockPlannerContext);
        DruidQuery queryForExplaining = rel.toDruidQueryForExplaining();
        DruidQuery query = rel.toDruidQuery(false);
        Assert.assertEquals((Object)DruidUnionDataSourceRel.DUMMY_DATA_SOURCE, (Object)queryForExplaining.getDataSource());
        Assert.assertEquals((Object)new UnionDataSource((List)ImmutableList.of((Object)RESTRICTED, (Object)RESTRICTED)), (Object)query.getDataSource());
    }

    @Test
    public void testDruidOuterQueryRel() {
        PartialDruidQuery partialDruidQuerySpy = (PartialDruidQuery)Mockito.spy((Object)this.druidQueryRelNode.getPartialDruidQuery());
        Mockito.when((Object)partialDruidQuerySpy.getTraitSet((Convention)ArgumentMatchers.any(), (PlannerContext)ArgumentMatchers.any())).thenReturn((Object)this.mockRelTraitSet);
        Mockito.when((Object)this.mockRelTraitSet.containsIfApplicable((RelTrait)ArgumentMatchers.any())).thenReturn((Object)true);
        PartialDruidQuery inputQuery = PartialDruidQuery.createOuterQuery((PartialDruidQuery)partialDruidQuerySpy, (PlannerContext)this.druidQueryRelNode.getPlannerContext());
        DruidOuterQueryRel rel = DruidOuterQueryRel.create((DruidRel)this.druidQueryRelNode, (PartialDruidQuery)inputQuery);
        DruidQuery queryForExplaining = rel.toDruidQueryForExplaining();
        DruidQuery query = rel.toDruidQuery(false);
        Assert.assertEquals((Object)DruidOuterQueryRel.DUMMY_DATA_SOURCE, (Object)queryForExplaining.getDataSource());
        Assert.assertEquals((Object)RESTRICTED, (Object)((QueryDataSource)query.getDataSource()).getQuery().getDataSource());
    }

    @Test
    public void testDruidCorrelateUnnestRel() {
        this.mockExpressionParser();
        DruidUnnestRel right = (DruidUnnestRel)Mockito.mock(DruidUnnestRel.class);
        Mockito.when((Object)right.getRowType()).thenReturn((Object)REC_TYPE);
        Mockito.when((Object)right.getInputRexNode()).thenReturn((Object)ALWAYS_TRUE);
        LogicalCorrelate correlateRel = LogicalCorrelate.create((RelNode)this.druidQueryRelNode, (RelNode)right, (List)ImmutableList.of(), (CorrelationId)((CorrelationId)Mockito.mock(CorrelationId.class)), (ImmutableBitSet)ImmutableBitSet.of((int)0), (JoinRelType)JoinRelType.LEFT);
        DruidCorrelateUnnestRel rel = DruidCorrelateUnnestRel.create((Correlate)correlateRel, (PlannerContext)this.mockPlannerContext);
        DruidQuery queryForExplaining = rel.toDruidQueryForExplaining();
        DruidQuery query = rel.toDruidQuery(false);
        Assert.assertEquals((Object)DruidCorrelateUnnestRel.DUMMY_DATA_SOURCE, (Object)queryForExplaining.getDataSource());
        Assert.assertEquals((Object)RESTRICTED, (Object)((UnnestDataSource)query.getDataSource()).getBase());
    }

    @Test
    public void testDruidUnnestRel() {
        DruidUnnestRel rel = DruidUnnestRel.create((RelOptCluster)this.mockRelOptCluster, (RelTraitSet)this.mockRelTraitSet, (RexNode)ALWAYS_TRUE, (PlannerContext)this.mockPlannerContext);
        CannotBuildQueryException e1 = (CannotBuildQueryException)Assert.assertThrows(CannotBuildQueryException.class, () -> ((DruidUnnestRel)rel).toDruidQueryForExplaining());
        CannotBuildQueryException e2 = (CannotBuildQueryException)Assert.assertThrows(CannotBuildQueryException.class, () -> rel.toDruidQuery(false));
        Assert.assertEquals((Object)"Cannot execute UNNEST directly", (Object)e1.getMessage());
        Assert.assertEquals((Object)"Cannot execute UNNEST directly", (Object)e2.getMessage());
    }

    @Test
    public void testDruidUnionRel() {
        DruidUnionRel rel = DruidUnionRel.create((PlannerContext)this.mockPlannerContext, (RelDataType)REC_TYPE, (List)ImmutableList.of((Object)this.druidQueryRelNode), (int)1000);
        UnsupportedOperationException e1 = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> ((DruidUnionRel)rel).toDruidQueryForExplaining());
        UnsupportedOperationException e2 = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> rel.toDruidQuery(false));
    }

    private void mockExpressionParser() {
        ExpressionParser parser = (ExpressionParser)Mockito.mock(ExpressionParser.class);
        Mockito.when((Object)parser.parse((String)ArgumentMatchers.any())).thenReturn((Object)EXPR_6L);
        Mockito.when((Object)this.mockPlannerContext.getExpressionParser()).thenReturn((Object)parser);
        Mockito.when((Object)this.mockPlannerContext.parseExpression((String)ArgumentMatchers.any())).thenReturn((Object)EXPR_6L);
    }
}

