/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import java.io.Reader;
import java.io.StringReader;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.druid.sql.calcite.parser.DruidSqlInsert;
import org.apache.druid.sql.calcite.parser.DruidSqlParserImpl;
import org.apache.druid.sql.calcite.parser.DruidSqlParserImplFactory;
import org.apache.druid.sql.calcite.parser.DruidSqlReplace;
import org.apache.druid.sql.calcite.parser.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class DruidSqlUnparseTest {
    private final SqlWriter sqlWriter = new SqlPrettyWriter(CalciteSqlDialect.DEFAULT);

    @Test
    public void testUnparseInsert() throws ParseException {
        String sqlQuery = "INSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME";
        String prettySqlQuery = "INSERT INTO \"dst\"\nSELECT *\n    FROM \"foo\"\nPARTITIONED BY ALL TIME";
        DruidSqlParserImpl druidSqlParser = DruidSqlUnparseTest.createTestParser(sqlQuery);
        DruidSqlInsert druidSqlReplace = (DruidSqlInsert)druidSqlParser.DruidSqlInsertEof();
        druidSqlReplace.unparse(this.sqlWriter, 0, 0);
        Assert.assertEquals((Object)prettySqlQuery, (Object)this.sqlWriter.toSqlString().getSql());
    }

    @Test
    public void testUnparseReplaceAll() throws ParseException {
        String sqlQuery = "REPLACE INTO dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME CLUSTERED BY dim1";
        String prettySqlQuery = "REPLACE INTO \"dst\"\nOVERWRITE ALL\nSELECT *\n    FROM \"foo\"\nPARTITIONED BY ALL TIME CLUSTERED BY \"dim1\"";
        DruidSqlParserImpl druidSqlParser = DruidSqlUnparseTest.createTestParser(sqlQuery);
        DruidSqlReplace druidSqlReplace = (DruidSqlReplace)druidSqlParser.DruidSqlReplaceEof();
        druidSqlReplace.unparse(this.sqlWriter, 0, 0);
        Assert.assertEquals((Object)prettySqlQuery, (Object)this.sqlWriter.toSqlString().getSql());
    }

    @Test
    public void testUnparseReplaceWhere() throws ParseException {
        String sqlQuery = "REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00' SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY dim1";
        String prettySqlQuery = "REPLACE INTO \"dst\"\nOVERWRITE \"__time\" >= TIMESTAMP '2000-01-01 00:00:00' AND \"__time\" < TIMESTAMP '2000-01-02 00:00:00'\nSELECT *\n    FROM \"foo\"\nPARTITIONED BY DAY CLUSTERED BY \"dim1\"";
        DruidSqlParserImpl druidSqlParser = DruidSqlUnparseTest.createTestParser(sqlQuery);
        DruidSqlReplace druidSqlReplace = (DruidSqlReplace)druidSqlParser.DruidSqlReplaceEof();
        druidSqlReplace.unparse(this.sqlWriter, 0, 0);
        Assert.assertEquals((Object)prettySqlQuery, (Object)this.sqlWriter.toSqlString().getSql());
    }

    private static DruidSqlParserImpl createTestParser(String parseString) {
        DruidSqlParserImplFactory druidSqlParserImplFactory = new DruidSqlParserImplFactory();
        DruidSqlParserImpl druidSqlParser = (DruidSqlParserImpl)druidSqlParserImplFactory.getParser((Reader)new StringReader(parseString));
        druidSqlParser.setUnquotedCasing(Casing.TO_LOWER);
        druidSqlParser.setQuotedCasing(Casing.TO_LOWER);
        druidSqlParser.setIdentifierMaxLength(20);
        return druidSqlParser;
    }

    @Test
    public void testUnparseExternalSqlIdentifierReplace() throws ParseException {
        String sqlQuery = "REPLACE INTO EXTERN( s3(bucket=>'bucket1',prefix=>'prefix1') ) AS CSV OVERWRITE ALL SELECT dim2 FROM foo";
        String prettySqlQuery = "REPLACE INTO EXTERN(S3(bucket => 'bucket1', prefix => 'prefix1'))\nAS csv\nOVERWRITE ALL\nSELECT \"dim2\"\n    FROM \"foo\"\n";
        DruidSqlParserImpl druidSqlParser = DruidSqlUnparseTest.createTestParser(sqlQuery);
        DruidSqlReplace druidSqlReplace = (DruidSqlReplace)druidSqlParser.DruidSqlReplaceEof();
        druidSqlReplace.unparse(this.sqlWriter, 0, 0);
        Assert.assertEquals((Object)prettySqlQuery, (Object)this.sqlWriter.toSqlString().getSql());
    }

    @Test
    public void testUnparseExternalSqlIdentifierInsert() throws ParseException {
        String sqlQuery = "INSERT INTO EXTERN( s3(bucket=>'bucket1',prefix=>'prefix1') ) AS CSV SELECT dim2 FROM foo";
        String prettySqlQuery = "INSERT INTO EXTERN(S3(bucket => 'bucket1', prefix => 'prefix1'))\nAS csv\nSELECT \"dim2\"\n    FROM \"foo\"\n";
        DruidSqlParserImpl druidSqlParser = DruidSqlUnparseTest.createTestParser(sqlQuery);
        DruidSqlInsert druidSqlInsert = (DruidSqlInsert)druidSqlParser.DruidSqlInsertEof();
        druidSqlInsert.unparse(this.sqlWriter, 0, 0);
        Assert.assertEquals((Object)prettySqlQuery, (Object)this.sqlWriter.toSqlString().getSql());
    }
}

