/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.error.DruidException;
import org.apache.druid.sql.calcite.parser.DruidSqlParser;
import org.junit.Assert;
import org.junit.Test;

public class DruidSqlParserTest {
    @Test
    public void test_sqlLiteralToContextValue_null() {
        SqlLiteral literal = SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
        Assert.assertNull((Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_string() {
        SqlCharStringLiteral literal = SqlLiteral.createCharString((String)"abc", (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)"abc", (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_stringWithSpecialChars() {
        SqlCharStringLiteral literal = SqlLiteral.createCharString((String)"hello\nworld\t\"test\"", (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)"hello\nworld\t\"test\"", (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_integer() {
        SqlNumericLiteral literal = SqlLiteral.createExactNumeric((String)"42", (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)42L, (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_negativeInteger() {
        SqlNumericLiteral literal = SqlLiteral.createExactNumeric((String)"-123", (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)-123L, (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_decimal() {
        SqlNumericLiteral literal = SqlLiteral.createExactNumeric((String)"3.14159", (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)3.14159, (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_largeNumber() {
        SqlNumericLiteral literal = SqlLiteral.createExactNumeric((String)"123456789012345678901234567890", (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)"123456789012345678901234567890", (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_approximateNumeric() {
        SqlNumericLiteral literal = SqlLiteral.createApproxNumeric((String)"1.23E10", (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)1.23E10, (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_booleanTrue() {
        SqlLiteral literal = SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)true, (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_booleanFalse() {
        SqlLiteral literal = SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)false, (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_timestamp() {
        TimestampString timestampString = new TimestampString("2023-01-15 14:30:00");
        SqlTimestampLiteral literal = SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP, (TimestampString)timestampString, (int)0, (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)"2023-01-15T14:30:00.000Z", (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_timestampWithFractionalSeconds() {
        TimestampString timestampString = new TimestampString("2023-01-15 14:30:00.123");
        SqlTimestampLiteral literal = SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP, (TimestampString)timestampString, (int)3, (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)"2023-01-15T14:30:00.123Z", (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_date() {
        DateString dateString = new DateString("2023-01-15");
        SqlDateLiteral literal = SqlLiteral.createDate((DateString)dateString, (SqlParserPos)SqlParserPos.ZERO);
        Assert.assertEquals((Object)"2023-01-15T00:00:00.000Z", (Object)DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
    }

    @Test
    public void test_sqlLiteralToContextValue_unsupportedType() {
        SqlLiteral literal = SqlLiteral.createSymbol((Enum)SqlTypeName.BINARY, (SqlParserPos)SqlParserPos.ZERO);
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)literal));
        Assert.assertTrue((boolean)exception.getMessage().contains("Unsupported type for SET"));
    }
}

