/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.sql.calcite.external.ExternalTableScanRule;
import org.apache.druid.sql.calcite.parser.DruidSqlParser;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerToolbox;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.ViewSchema;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ExternalTableScanRuleTest {
    @Test
    public void testMatchesWhenExternalScanUnsupported() {
        NativeSqlEngine engine = CalciteTests.createMockSqlEngine((QuerySegmentWalker)EasyMock.createMock(QuerySegmentWalker.class), (QueryRunnerFactoryConglomerate)EasyMock.createMock(QueryRunnerFactoryConglomerate.class));
        PlannerToolbox toolbox = new PlannerToolbox(CalciteTests.createOperatorTable(), CalciteTests.createExprMacroTable(), CalciteTests.getJsonMapper(), new PlannerConfig(), new DruidSchemaCatalog((SchemaPlus)EasyMock.createMock(SchemaPlus.class), (Map)ImmutableMap.of((Object)"druid", (Object)new NamedDruidSchema((DruidSchema)EasyMock.createMock(DruidSchema.class), "druid"), (Object)"view", (Object)new NamedViewSchema((ViewSchema)EasyMock.createMock(ViewSchema.class)))), CalciteTests.createJoinableFactoryWrapper(), CatalogResolver.NULL_RESOLVER, "druid", new CalciteRulesManager((Set)ImmutableSet.of()), CalciteTests.TEST_AUTHORIZER_MAPPER, AuthConfig.newBuilder().build(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), new DruidHookDispatcher());
        PlannerContext plannerContext = PlannerContext.create((PlannerToolbox)toolbox, (String)"SELECT 1", (SqlNode)DruidSqlParser.parse((String)"SELECT 1", (boolean)false).getMainStatement(), (SqlEngine)engine, Collections.emptyMap(), null);
        plannerContext.setQueryMaker(engine.buildQueryMakerForSelect((RelRoot)EasyMock.createMock(RelRoot.class), plannerContext));
        ExternalTableScanRule rule = new ExternalTableScanRule(plannerContext);
        rule.matches((RelOptRuleCall)EasyMock.createMock(RelOptRuleCall.class));
        Assert.assertEquals((Object)"Cannot use [EXTERN] with SQL engine [native].", (Object)plannerContext.getPlanningError());
    }
}

