/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.math.expr.ExpressionValidationException;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.ExpressionTestHelper;
import org.apache.druid.sql.calcite.expression.builtin.IPv4AddressParseOperatorConversion;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IPv4AddressParseExpressionTest
extends CalciteTestBase {
    private static final String VALID = "192.168.0.1";
    private static final long EXPECTED = 3232235521L;
    private static final Object IGNORE_EXPECTED_RESULT = null;
    private static final String VAR = "f";
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("f", ColumnType.FLOAT).build();
    private static final Map<String, Object> BINDINGS = ImmutableMap.of((Object)"f", (Object)3.14);
    private IPv4AddressParseOperatorConversion target;
    private ExpressionTestHelper testHelper;

    @BeforeEach
    public void setUp() {
        this.target = new IPv4AddressParseOperatorConversion();
        this.testHelper = new ExpressionTestHelper(ROW_SIGNATURE, BINDINGS);
    }

    @Test
    public void testTooFewArgs() {
        Throwable t = Assert.assertThrows(ExpressionValidationException.class, () -> this.testExpression(Collections.emptyList(), this.buildExpectedExpression(new Object[0]), IGNORE_EXPECTED_RESULT));
        Assert.assertEquals((Object)"Function[ipv4_parse] requires 1 argument", (Object)t.getMessage());
    }

    @Test
    public void testTooManyArgs() {
        Throwable t = Assert.assertThrows(ExpressionValidationException.class, () -> this.testExpression(Arrays.asList(this.testHelper.getConstantNull(), this.testHelper.getConstantNull()), this.buildExpectedExpression(null, null), IGNORE_EXPECTED_RESULT));
        Assert.assertEquals((Object)"Function[ipv4_parse] requires 1 argument", (Object)t.getMessage());
    }

    @Test
    public void testNullArg() {
        this.testExpression(this.testHelper.getConstantNull(), this.buildExpectedExpression(new Object[]{null}), null);
    }

    @Test
    public void testInvalidArgType() {
        String variableNameWithInvalidType = VAR;
        this.testExpression(this.testHelper.makeInputRef(variableNameWithInvalidType), this.buildExpectedExpression(this.testHelper.makeVariable(variableNameWithInvalidType)), null);
    }

    @Test
    public void testInvalidStringArgNotIPAddress() {
        String notIpAddress = "druid.apache.org";
        this.testExpression((RexNode)this.testHelper.makeLiteral(notIpAddress), this.buildExpectedExpression(notIpAddress), null);
    }

    @Test
    public void testInvalidStringArgIPv6Compatible() {
        String ipv6Compatible = "::192.168.0.1";
        this.testExpression((RexNode)this.testHelper.makeLiteral(ipv6Compatible), this.buildExpectedExpression(ipv6Compatible), null);
    }

    @Test
    public void testValidStringArgIPv6Mapped() {
        String ipv6Mapped = "::ffff:192.168.0.1";
        this.testExpression((RexNode)this.testHelper.makeLiteral(ipv6Mapped), this.buildExpectedExpression(ipv6Mapped), null);
    }

    @Test
    public void testValidStringArgIPv4() {
        this.testExpression((RexNode)this.testHelper.makeLiteral(VALID), this.buildExpectedExpression(VALID), (Object)3232235521L);
    }

    @Test
    public void testValidStringArgUnsignedInt() {
        String unsignedInt = "3232235521";
        this.testExpression((RexNode)this.testHelper.makeLiteral(unsignedInt), this.buildExpectedExpression(unsignedInt), null);
    }

    @Test
    public void testInvalidIntegerArgTooLow() {
        long tooLow = -1L;
        this.testExpression(this.testHelper.makeLiteral(tooLow), this.buildExpectedExpression(tooLow), null);
    }

    @Test
    public void testValidIntegerArgLowest() {
        long lowest = 0L;
        this.testExpression(this.testHelper.makeLiteral(lowest), this.buildExpectedExpression(lowest), (Object)lowest);
    }

    @Test
    public void testValidIntegerArg() {
        this.testExpression(this.testHelper.makeLiteral(3232235521L), this.buildExpectedExpression(3232235521L), (Object)3232235521L);
    }

    @Test
    public void testValidIntegerArgHighest() {
        long highest = 0xFFFFFFFFL;
        this.testExpression(this.testHelper.makeLiteral(highest), this.buildExpectedExpression(highest), (Object)highest);
    }

    @Test
    public void testInvalidIntegerArgTooHigh() {
        long tooHigh = 0x100000000L;
        this.testExpression(this.testHelper.makeLiteral(tooHigh), this.buildExpectedExpression(tooHigh), null);
    }

    private void testExpression(RexNode expr, DruidExpression expectedExpression, Object expectedResult) {
        this.testExpression(Collections.singletonList(expr), expectedExpression, expectedResult);
    }

    private void testExpression(List<? extends RexNode> exprs, DruidExpression expectedExpression, Object expectedResult) {
        this.testHelper.testExpressionString(this.target.calciteOperator(), exprs, expectedExpression, expectedResult);
    }

    private DruidExpression buildExpectedExpression(Object ... args) {
        return this.testHelper.buildExpectedExpression(this.target.getDruidFunctionName(), args);
    }
}

