/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.math.expr.ExpressionValidationException;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.ExpressionTestHelper;
import org.apache.druid.sql.calcite.expression.builtin.IPv4AddressMatchOperatorConversion;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IPv4AddressMatchExpressionTest
extends CalciteTestBase {
    private static final String IPV4 = "192.168.0.1";
    private static final long IPV4_LONG = 3232235521L;
    private static final String IPV4_UINT = "3232235521";
    private static final String IPV4_NETWORK = "192.168.0.0";
    private static final String IPV4_BROADCAST = "192.168.255.255";
    private static final String IPV6_COMPATIBLE = "::192.168.0.1";
    private static final String IPV6_MAPPED = "::ffff:192.168.0.1";
    private static final String SUBNET_192_168 = "192.168.0.0/16";
    private static final String SUBNET_10 = "10.0.0.0/8";
    private static final Object IGNORE_EXPECTED_RESULT = null;
    private static final long MATCH = 1L;
    private static final long NO_MATCH = 0L;
    private static final String VAR = "s";
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("s", ColumnType.STRING).build();
    private static final Map<String, Object> BINDINGS = ImmutableMap.of((Object)"s", (Object)"foo");
    private IPv4AddressMatchOperatorConversion target;
    private ExpressionTestHelper testHelper;

    @BeforeEach
    public void setUp() {
        this.target = new IPv4AddressMatchOperatorConversion();
        this.testHelper = new ExpressionTestHelper(ROW_SIGNATURE, BINDINGS);
    }

    @Test
    public void testTooFewArgs() {
        Throwable t = Assert.assertThrows(ExpressionValidationException.class, () -> this.testExpression(Collections.emptyList(), this.buildExpectedExpression(new Object[0]), IGNORE_EXPECTED_RESULT));
        Assert.assertEquals((Object)"Function[ipv4_match] requires 2 arguments", (Object)t.getMessage());
    }

    @Test
    public void testTooManyArgs() {
        String address = IPV4;
        String subnet = SUBNET_192_168;
        Throwable t = Assert.assertThrows(ExpressionValidationException.class, () -> this.testExpression(Arrays.asList(this.testHelper.makeLiteral(address), this.testHelper.makeLiteral(subnet), this.testHelper.makeLiteral(address)), this.buildExpectedExpression(address, subnet, address), IGNORE_EXPECTED_RESULT));
        Assert.assertEquals((Object)"Function[ipv4_match] requires 2 arguments", (Object)t.getMessage());
    }

    @Test
    public void testSubnetArgNotLiteral() {
        String address = IPV4;
        String variableName = VAR;
        Throwable t = Assert.assertThrows(ExpressionValidationException.class, () -> this.testExpression(Arrays.asList(this.testHelper.makeLiteral(address), this.testHelper.makeInputRef(variableName)), this.buildExpectedExpression(address, this.testHelper.makeVariable(variableName)), IGNORE_EXPECTED_RESULT));
        Assert.assertEquals((Object)"Function[ipv4_match] subnet argument must be a literal", (Object)t.getMessage());
    }

    @Test
    public void testSubnetArgInvalid() {
        String address = IPV4;
        String invalidSubnet = "192.168.0.1/invalid";
        Throwable t = Assert.assertThrows(ExpressionValidationException.class, () -> this.testExpression(Arrays.asList(this.testHelper.makeLiteral(address), this.testHelper.makeLiteral(invalidSubnet)), this.buildExpectedExpression(address, invalidSubnet), IGNORE_EXPECTED_RESULT));
        Assert.assertEquals((Object)"Function[ipv4_match] subnet arg has an invalid format: 192.168.0.1/invalid", (Object)t.getMessage());
    }

    @Test
    public void testNullArg() {
        String subnet = SUBNET_192_168;
        this.testExpression(Arrays.asList(this.testHelper.getConstantNull(), this.testHelper.makeLiteral(subnet)), this.buildExpectedExpression(null, subnet), (Object)0L);
    }

    @Test
    public void testInvalidArgType() {
        String variableNameWithInvalidType = VAR;
        String subnet = SUBNET_192_168;
        this.testExpression(Arrays.asList(this.testHelper.makeInputRef(variableNameWithInvalidType), this.testHelper.makeLiteral(subnet)), this.buildExpectedExpression(this.testHelper.makeVariable(variableNameWithInvalidType), subnet), (Object)0L);
    }

    @Test
    public void testMatchingStringArgIPv4() {
        this.testExpression(IPV4, SUBNET_192_168, 1L);
    }

    @Test
    public void testNotMatchingStringArgIPv4() {
        this.testExpression(IPV4, SUBNET_10, 0L);
    }

    @Test
    public void testMatchingStringArgIPv6Mapped() {
        this.testExpression(IPV6_MAPPED, SUBNET_192_168, 0L);
    }

    @Test
    public void testNotMatchingStringArgIPv6Mapped() {
        this.testExpression(IPV6_MAPPED, SUBNET_10, 0L);
    }

    @Test
    public void testMatchingStringArgIPv6Compatible() {
        this.testExpression(IPV6_COMPATIBLE, SUBNET_192_168, 0L);
    }

    @Test
    public void testNotMatchingStringArgIPv6Compatible() {
        this.testExpression(IPV6_COMPATIBLE, SUBNET_10, 0L);
    }

    @Test
    public void testNotIpAddress() {
        this.testExpression("druid.apache.org", SUBNET_192_168, 0L);
    }

    @Test
    public void testMatchingLongArg() {
        this.testExpression(3232235521L, SUBNET_192_168, 1L);
    }

    @Test
    public void testNotMatchingLongArg() {
        this.testExpression(3232235521L, SUBNET_10, 0L);
    }

    @Test
    public void testMatchingStringArgUnsignedInt() {
        this.testExpression(IPV4_UINT, SUBNET_192_168, 0L);
    }

    @Test
    public void testNotMatchingStringArgUnsignedInt() {
        this.testExpression(IPV4_UINT, SUBNET_10, 0L);
    }

    @Test
    public void testInclusive() {
        String subnet = SUBNET_192_168;
        this.testExpression(IPV4_NETWORK, subnet, 1L);
        this.testExpression(IPV4, subnet, 1L);
        this.testExpression(IPV4_BROADCAST, subnet, 1L);
    }

    private void testExpression(String address, String subnet, long match) {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(address), this.testHelper.makeLiteral(subnet)), this.buildExpectedExpression(address, subnet), (Object)match);
    }

    private void testExpression(long address, String subnet, long match) {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(address), this.testHelper.makeLiteral(subnet)), this.buildExpectedExpression(address, subnet), (Object)match);
    }

    private void testExpression(List<? extends RexNode> exprs, DruidExpression expectedExpression, Object expectedResult) {
        this.testHelper.testExpressionString(this.target.calciteOperator(), exprs, expectedExpression, expectedResult);
    }

    private DruidExpression buildExpectedExpression(Object ... args) {
        return this.testHelper.buildExpectedExpression(this.target.getDruidFunctionName(), args);
    }
}

