/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.DruidLiteral;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DruidExpressionTest
extends InitializedNullHandlingTest {
    @Test
    public void test_doubleLiteral_asString() {
        Assert.assertEquals((Object)"0.0", (Object)DruidExpression.doubleLiteral((double)0.0));
        Assert.assertEquals((Object)"-2.0", (Object)DruidExpression.doubleLiteral((double)-2.0));
        Assert.assertEquals((Object)"2.0", (Object)DruidExpression.doubleLiteral((double)2.0));
        Assert.assertEquals((Object)"2.1", (Object)DruidExpression.doubleLiteral((double)2.1));
        Assert.assertEquals((Object)"2.12345678", (Object)DruidExpression.doubleLiteral((double)2.12345678));
        Assert.assertEquals((Object)"2.2E122", (Object)DruidExpression.doubleLiteral((double)2.2E122));
        Assert.assertEquals((Object)"NaN", (Object)DruidExpression.doubleLiteral((double)Double.NaN));
        Assert.assertEquals((Object)"Infinity", (Object)DruidExpression.doubleLiteral((double)Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"-Infinity", (Object)DruidExpression.doubleLiteral((double)Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)"4.9E-324", (Object)DruidExpression.doubleLiteral((double)Double.MIN_VALUE));
        Assert.assertEquals((Object)"1.7976931348623157E308", (Object)DruidExpression.doubleLiteral((double)Double.MAX_VALUE));
        Assert.assertEquals((Object)"2.2250738585072014E-308", (Object)DruidExpression.doubleLiteral((double)Double.MIN_NORMAL));
    }

    @Test
    public void test_doubleLiteral_roundTrip() {
        double[] doubles;
        for (double n : doubles = new double[]{0.0, -2.0, 2.0, 2.1, 2.12345678, 2.2E122, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.MIN_VALUE, Double.MAX_VALUE, Double.MIN_NORMAL}) {
            Expr expr = Parser.parse((String)DruidExpression.doubleLiteral((double)n), (ExprMacroTable)ExprMacroTable.nil());
            Assert.assertTrue((boolean)expr.isLiteral());
            MatcherAssert.assertThat((Object)expr.getLiteralValue(), (Matcher)CoreMatchers.instanceOf(Double.class));
            Assert.assertEquals((double)n, (double)((Double)expr.getLiteralValue()), (double)0.0);
        }
    }

    @Test
    public void test_longLiteral_asString() {
        Assert.assertEquals((Object)"0", (Object)DruidExpression.longLiteral((long)0L));
        Assert.assertEquals((Object)"-2", (Object)DruidExpression.longLiteral((long)-2L));
        Assert.assertEquals((Object)"2", (Object)DruidExpression.longLiteral((long)2L));
        Assert.assertEquals((Object)"9223372036854775807", (Object)DruidExpression.longLiteral((long)Long.MAX_VALUE));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)DruidExpression.longLiteral((long)Long.MIN_VALUE));
    }

    @Test
    public void test_longLiteral_roundTrip() {
        long[] longs;
        for (long n : longs = new long[]{0L, -2L, 2L, Long.MAX_VALUE, Long.MIN_VALUE}) {
            Expr expr = Parser.parse((String)DruidExpression.longLiteral((long)n), (ExprMacroTable)ExprMacroTable.nil());
            Assert.assertTrue((boolean)expr.isLiteral());
            MatcherAssert.assertThat((Object)expr.getLiteralValue(), (Matcher)CoreMatchers.instanceOf(Number.class));
            Assert.assertEquals((long)n, (long)((Number)expr.getLiteralValue()).longValue());
        }
    }

    @Test
    public void test_ofLiteral_nullString() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.STRING, null));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"null", (Object)expression.getExpression());
    }

    @Test
    public void test_ofLiteral_nullLong() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.LONG, null));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"null", (Object)expression.getExpression());
    }

    @Test
    public void test_ofLiteral_nullDouble() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.DOUBLE, null));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"null", (Object)expression.getExpression());
    }

    @Test
    public void test_ofLiteral_nullArray() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.STRING_ARRAY, null));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"null", (Object)expression.getExpression());
    }

    @Test
    public void test_ofLiteral_string() {
        String s = "abcd\u00e9\n \\\" ' \ud83e\udd20 \txyz";
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.STRING, (Object)"abcd\u00e9\n \\\" ' \ud83e\udd20 \txyz"));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"'abcd\u00e9\\u000A \\u005C\\u0022 \\u0027 \\uD83E\\uDD20 \\u0009xyz'", (Object)expression.getExpression());
        Assert.assertEquals((Object)"abcd\u00e9\n \\\" ' \ud83e\udd20 \txyz", (Object)Parser.parse((String)expression.getExpression(), (ExprMacroTable)ExprMacroTable.nil()).getLiteralValue());
    }

    @Test
    public void test_ofLiteral_emptyString() {
        String s = "";
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.STRING, (Object)""));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"''", (Object)expression.getExpression());
        Assert.assertEquals((Object)"", (Object)Parser.parse((String)expression.getExpression(), (ExprMacroTable)ExprMacroTable.nil()).getLiteralValue());
    }

    @Test
    public void test_ofLiteral_long() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.LONG, (Object)-123));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"-123", (Object)expression.getExpression());
        Assert.assertEquals((Object)-123L, (Object)Parser.parse((String)expression.getExpression(), (ExprMacroTable)ExprMacroTable.nil()).getLiteralValue());
    }

    @Test
    public void test_ofLiteral_double() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.DOUBLE, (Object)-123.4));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"-123.4", (Object)expression.getExpression());
        Assert.assertEquals((Object)-123.4, (Object)Parser.parse((String)expression.getExpression(), (ExprMacroTable)ExprMacroTable.nil()).getLiteralValue());
    }

    @Test
    public void test_ofLiteral_doubleNan() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.DOUBLE, (Object)Double.NaN));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"NaN", (Object)expression.getExpression());
        Assert.assertEquals((Object)Double.NaN, (Object)Parser.parse((String)expression.getExpression(), (ExprMacroTable)ExprMacroTable.nil()).getLiteralValue());
    }

    @Test
    public void test_ofLiteral_doubleNegativeInfinity() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.DOUBLE, (Object)Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"-Infinity", (Object)expression.getExpression());
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)Parser.parse((String)expression.getExpression(), (ExprMacroTable)ExprMacroTable.nil()).getLiteralValue());
    }

    @Test
    public void test_ofLiteral_doublePositiveInfinity() {
        DruidExpression expression = DruidExpression.ofLiteral((DruidLiteral)new DruidLiteral(ExpressionType.DOUBLE, (Object)Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)expression.getDruidType());
        Assert.assertEquals((Object)"Infinity", (Object)expression.getExpression());
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)Parser.parse((String)expression.getExpression(), (ExprMacroTable)ExprMacroTable.nil()).getLiteralValue());
    }
}

