/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.sql.calcite.aggregation.ApproxCountDistinctSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.SqlAggregationModule;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.CountSqlAggregator;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SqlAggregationModuleTest
extends CalciteTestBase {
    private SqlAggregationModule target;
    private Injector injector;

    @BeforeEach
    public void setUp() {
        this.target = new SqlAggregationModule();
        this.injector = Guice.createInjector((Module[])new Module[]{this.target});
    }

    @Test
    public void testDefaultSqlAggregatorsAreBound() {
        Set sqlAggregators = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<SqlAggregator>>(){}));
        Assert.assertNotNull((Object)sqlAggregators);
        Assert.assertEquals((long)2L, (long)sqlAggregators.size());
        List aggregators = sqlAggregators.stream().sorted(Comparator.comparing(o -> o.getClass().getName())).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)((SqlAggregator)aggregators.get(0)), (Matcher)CoreMatchers.instanceOf(ApproxCountDistinctSqlAggregator.class));
        MatcherAssert.assertThat((Object)((SqlAggregator)aggregators.get(1)), (Matcher)CoreMatchers.instanceOf(CountSqlAggregator.class));
    }
}

