/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.druid.java.util.common.FileUtils;

public class TempDirProducer
implements Closeable {
    private final File tempDir;

    public TempDirProducer(String prefix) {
        this.tempDir = FileUtils.createTempDir((String)prefix);
    }

    public TempDirProducer(TempDirProducer tempDirProducer, String prefix) {
        this.tempDir = FileUtils.createTempDirInLocation((Path)tempDirProducer.tempDir.toPath(), (String)prefix);
    }

    public TempDirProducer getProducer(String prefix) {
        return new TempDirProducer(this, prefix);
    }

    public File newTempFolder(String prefix) {
        return FileUtils.createTempDirInLocation((Path)this.tempDir.toPath(), (String)prefix);
    }

    public File newTempFolder() {
        return this.newTempFolder(null);
    }

    @Override
    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this.tempDir);
    }
}

