/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.sql.calcite.DrillWindowQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.util.CacheTestHelperModule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SqlTestFrameworkConfigTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SqlTestFrameworkConfig.class).usingGetClass().verify();
    }

    @Test
    public void testAnnotationProcessingChain() throws Exception {
        List<Annotation> annotations = SqlTestFrameworkConfig.collectAnnotations(C.class, D.class.getMethod("imaginaryTestMethod1", new Class[0]));
        SqlTestFrameworkConfig config = new SqlTestFrameworkConfig(annotations);
        Assertions.assertEquals((int)1, (int)config.minTopNThreshold);
        Assertions.assertEquals((int)3, (int)config.numMergeBuffers);
        Assertions.assertEquals((Object)CacheTestHelperModule.ResultCacheMode.ENABLED, (Object)config.resultCache);
    }

    @Test
    public void testAnnotationOverridingClassHasDefault() throws Exception {
        List<Annotation> annotations = SqlTestFrameworkConfig.collectAnnotations(D.class, D.class.getMethod("imaginaryTestMethod2", new Class[0]));
        SqlTestFrameworkConfig config = new SqlTestFrameworkConfig(annotations);
        Assertions.assertEquals((int)2, (int)config.minTopNThreshold);
        Assertions.assertEquals((int)3, (int)config.numMergeBuffers);
        Assertions.assertEquals((Object)CacheTestHelperModule.ResultCacheMode.ENABLED, (Object)config.resultCache);
    }

    @Test
    public void testAnnotationOverridingClassChangesDefault() throws Exception {
        List<Annotation> annotations = SqlTestFrameworkConfig.collectAnnotations(D.class, D.class.getMethod("imaginaryTestMethod3", new Class[0]));
        SqlTestFrameworkConfig config = new SqlTestFrameworkConfig(annotations);
        Assertions.assertEquals((int)2, (int)config.minTopNThreshold);
        Assertions.assertEquals((int)1, (int)config.numMergeBuffers);
        Assertions.assertEquals((Object)CacheTestHelperModule.ResultCacheMode.ENABLED, (Object)config.resultCache);
    }

    @Test
    public void testAnnotationsAtTestLevel() throws Exception {
        List<Annotation> annotations = SqlTestFrameworkConfig.collectAnnotations(D.class, D.class.getMethod("imaginaryTestMethod4", new Class[0]));
        SqlTestFrameworkConfig config = new SqlTestFrameworkConfig(annotations);
        Assertions.assertEquals((int)1, (int)config.minTopNThreshold);
        Assertions.assertEquals((int)1, (int)config.numMergeBuffers);
        Assertions.assertEquals((Object)CacheTestHelperModule.ResultCacheMode.DISABLED, (Object)config.resultCache);
    }

    @Test
    public void testInvalidConfigKeySpecified() {
        ImmutableMap configMap = ImmutableMap.builder().put((Object)"nonExistent", (Object)"someValue").build();
        IAE e = (IAE)Assertions.assertThrows(IAE.class, () -> new SqlTestFrameworkConfig((Map<String, String>)configMap));
        Assertions.assertEquals((Object)"Invalid configuration key(s) specified [[nonExistent]]; valid options are [[numMergeBuffers, minTopNThreshold, resultCache, componentSupplier, datasets]]", (Object)e.getMessage());
    }

    @Test
    public void testURI() {
        SqlTestFrameworkConfig c = new SqlTestFrameworkConfig((Map<String, String>)ImmutableMap.of((Object)"componentSupplier", (Object)DrillWindowQueryTest.DrillComponentSupplier.class.getSimpleName()));
        URI uri = c.getDruidTestURI();
        Assertions.assertEquals((Object)"druidtest:///?componentSupplier=DrillComponentSupplier", (Object)uri.toString());
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    static class C
    extends B {
        C() {
        }

        @SqlTestFrameworkConfig.MinTopNThreshold(value=1)
        public void imaginaryTestMethod1() {
        }

        public void imaginaryTestMethod2() {
        }
    }

    @SqlTestFrameworkConfig.MinTopNThreshold(value=2)
    static class D
    extends C {
        D() {
        }

        @SqlTestFrameworkConfig.NumMergeBuffers(value=1)
        public void imaginaryTestMethod3() {
        }

        @SqlTestFrameworkConfig.ResultCache(value=CacheTestHelperModule.ResultCacheMode.DISABLED)
        @SqlTestFrameworkConfig.NumMergeBuffers(value=1)
        @SqlTestFrameworkConfig.MinTopNThreshold(value=1)
        public void imaginaryTestMethod4() {
        }
    }

    @SqlTestFrameworkConfig.ResultCache(value=CacheTestHelperModule.ResultCacheMode.ENABLED)
    static class B {
        B() {
        }
    }
}

