/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.MultiComponentSupplier;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.util.CacheTestHelperModule;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class SqlTestFrameworkConfig {
    private static final Set<String> KNOWN_CONFIG_KEYS = ImmutableSet.builder().add((Object)NumMergeBuffers.PROCESSOR.getConfigName()).add((Object)MinTopNThreshold.PROCESSOR.getConfigName()).add((Object)ResultCache.PROCESSOR.getConfigName()).add((Object)ComponentSupplier.PROCESSOR.getConfigName()).add((Object)Datasets.PROCESSOR.getConfigName()).build();
    public final int numMergeBuffers;
    public final int minTopNThreshold;
    public final CacheTestHelperModule.ResultCacheMode resultCache;
    public final Class<? extends SqlTestFramework.QueryComponentSupplier> componentSupplier;
    public final String datasets;
    static LoadingCache<String, Set<Class<? extends SqlTestFramework.QueryComponentSupplier>>> componentSupplierClassCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Set<Class<? extends SqlTestFramework.QueryComponentSupplier>>>(){

        public Set<Class<? extends SqlTestFramework.QueryComponentSupplier>> load(String pkg) {
            ConfigurationBuilder cfg = new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(true)}).setUrls(ClasspathHelper.forJavaClassPath()).filterInputsBy(new FilterBuilder().includePackage(new String[]{pkg}).and(s -> s.contains("ComponentSupplier")));
            Set baseComponentClazzes = new Reflections((Configuration)cfg).getSubTypesOf(SqlTestFramework.QueryComponentSupplier.class);
            LinkedHashSet<Class<? extends SqlTestFramework.QueryComponentSupplier>> retVal = new LinkedHashSet<Class<? extends SqlTestFramework.QueryComponentSupplier>>(baseComponentClazzes);
            for (Class baseClazz : baseComponentClazzes) {
                if (!MultiComponentSupplier.class.isAssignableFrom(baseClazz) || baseClazz == MultiComponentSupplier.class) continue;
                Class multiClazz = baseClazz;
                MultiComponentSupplier.registerComponentSupplier(multiClazz);
                retVal.addAll(MultiComponentSupplier.getSuppliers(multiClazz));
            }
            return retVal;
        }
    });

    public SqlTestFrameworkConfig(List<Annotation> annotations) {
        try {
            this.numMergeBuffers = NumMergeBuffers.PROCESSOR.fromAnnotations(annotations);
            this.minTopNThreshold = MinTopNThreshold.PROCESSOR.fromAnnotations(annotations);
            this.resultCache = ResultCache.PROCESSOR.fromAnnotations(annotations);
            this.componentSupplier = ComponentSupplier.PROCESSOR.fromAnnotations(annotations);
            this.datasets = Datasets.PROCESSOR.fromAnnotations(annotations);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SqlTestFrameworkConfig(Map<String, String> queryParams) {
        this.validateConfigKeys(queryParams.keySet());
        try {
            this.numMergeBuffers = NumMergeBuffers.PROCESSOR.fromMap(queryParams);
            this.minTopNThreshold = MinTopNThreshold.PROCESSOR.fromMap(queryParams);
            this.resultCache = ResultCache.PROCESSOR.fromMap(queryParams);
            this.componentSupplier = ComponentSupplier.PROCESSOR.fromMap(queryParams);
            this.datasets = Datasets.PROCESSOR.fromMap(queryParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void validateConfigKeys(Set<String> keySet) {
        Sets.SetView diff = Sets.difference(keySet, KNOWN_CONFIG_KEYS);
        if (diff.isEmpty()) {
            return;
        }
        throw new IAE("Invalid configuration key(s) specified [%s]; valid options are [%s]", new Object[]{diff, KNOWN_CONFIG_KEYS});
    }

    public int hashCode() {
        return Objects.hash(this.minTopNThreshold, this.numMergeBuffers, this.resultCache, this.componentSupplier, this.datasets);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTestFrameworkConfig other = (SqlTestFrameworkConfig)obj;
        return this.minTopNThreshold == other.minTopNThreshold && this.numMergeBuffers == other.numMergeBuffers && this.resultCache == other.resultCache && this.componentSupplier == other.componentSupplier && Objects.equals(this.datasets, other.datasets);
    }

    public static List<Annotation> collectAnnotations(Class<?> testClass, Method method) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(Arrays.asList(method.getAnnotations()));
        for (Class<?> clz = testClass; clz != null; clz = clz.getSuperclass()) {
            annotations.addAll(Arrays.asList(clz.getAnnotations()));
        }
        annotations.removeIf(annotation -> annotation.annotationType().getDeclaringClass() != SqlTestFrameworkConfig.class);
        return annotations;
    }

    public URI getDruidTestURI() {
        try {
            Map<String, String> params = this.getNonDefaultMap();
            URIBuilder ub = new URIBuilder("druidtest:///");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                ub.setParameter(entry.getKey(), entry.getValue());
            }
            ub.setPath("///");
            return ub.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getNonDefaultMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        SqlTestFrameworkConfig def = new SqlTestFrameworkConfig(Collections.emptyList());
        if (def.numMergeBuffers != this.numMergeBuffers) {
            map.put("numMergeBuffers", String.valueOf(this.numMergeBuffers));
        }
        if (def.minTopNThreshold != this.minTopNThreshold) {
            map.put("minTopNThreshold", String.valueOf(this.minTopNThreshold));
        }
        if (def.componentSupplier != this.componentSupplier) {
            map.put("componentSupplier", this.componentSupplier.getSimpleName());
        }
        if (!this.equals(new SqlTestFrameworkConfig(map))) {
            throw new IAE("Can't reproduce config via map!", new Object[0]);
        }
        return map;
    }

    public static SqlTestFrameworkConfig fromURL(String url) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        try {
            URI uri = new URI(url);
            if (uri.getHost() != null || uri.getPort() != -1) {
                throw DruidException.defensive((String)"URI [%s] is invalid ; only query parameters are supported.", (Object[])new Object[]{url});
            }
            List params = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
            for (NameValuePair pair : params) {
                queryParams.put(pair.getName(), pair.getValue());
            }
        }
        catch (URISyntaxException e) {
            throw DruidException.defensive((Throwable)e, (String)"Can't decode URI", (Object[])new Object[0]);
        }
        return new SqlTestFrameworkConfig(queryParams);
    }

    @Nonnull
    private static Class<? extends SqlTestFramework.QueryComponentSupplier> getQueryComponentSupplierForName(String name) throws Exception {
        for (String pkg : new String[]{"org.apache.druid.sql.calcite", ""}) {
            Set availableSuppliers = (Set)componentSupplierClassCache.get((Object)pkg);
            for (Class cl : availableSuppliers) {
                if (!cl.getSimpleName().equals(name)) continue;
                return cl;
            }
        }
        List knownNames = ((Set)componentSupplierClassCache.get((Object)"")).stream().map(Class::getSimpleName).collect(Collectors.toList());
        throw new IAE("ComponentSupplier [%s] is not known; known ones are [%s]", new Object[]{name, knownNames});
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @NumMergeBuffers(value=-1)
    public static @interface NumMergeBuffers {
        public static final ConfigOptionProcessor<Integer> PROCESSOR = new ConfigOptionProcessor<Integer>(NumMergeBuffers.class){

            @Override
            public Integer fromString(String str) throws NumberFormatException {
                return Integer.valueOf(str);
            }
        };

        public int value();
    }

    public static abstract class ConfigOptionProcessor<T> {
        final Class<? extends Annotation> annotationClass;

        public ConfigOptionProcessor(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        public final String getConfigName() {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.annotationClass.getSimpleName());
        }

        public final T fromAnnotations(List<Annotation> annotations) throws Exception {
            Method method = this.annotationClass.getMethod("value", new Class[0]);
            for (Annotation annotation : annotations) {
                if (!this.annotationClass.isInstance(annotation)) continue;
                return (T)method.invoke((Object)annotation, new Object[0]);
            }
            return this.defaultValue();
        }

        @Nonnull
        public final T defaultValue() throws Exception {
            Method method = this.annotationClass.getMethod("value", new Class[0]);
            Annotation annotation = this.annotationClass.getAnnotation(this.annotationClass);
            Preconditions.checkNotNull((Object)annotation, (Object)StringUtils.format((String)"Annotation class [%s] must be annotated with itself to set default value", (Object[])new Object[]{this.annotationClass}));
            return (T)method.invoke((Object)annotation, new Object[0]);
        }

        public final T fromMap(Map<String, String> map) throws Exception {
            String key = this.getConfigName();
            String value = map.get(key);
            if (value == null) {
                return this.defaultValue();
            }
            return this.fromString(value);
        }

        public abstract T fromString(String var1) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @MinTopNThreshold(value=1000)
    public static @interface MinTopNThreshold {
        public static final ConfigOptionProcessor<Integer> PROCESSOR = new ConfigOptionProcessor<Integer>(MinTopNThreshold.class){

            @Override
            public Integer fromString(String str) throws NumberFormatException {
                return Integer.valueOf(str);
            }
        };

        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ResultCache(value=CacheTestHelperModule.ResultCacheMode.DISABLED)
    public static @interface ResultCache {
        public static final ConfigOptionProcessor<CacheTestHelperModule.ResultCacheMode> PROCESSOR = new ConfigOptionProcessor<CacheTestHelperModule.ResultCacheMode>(ResultCache.class){

            @Override
            public CacheTestHelperModule.ResultCacheMode fromString(String str) {
                return CacheTestHelperModule.ResultCacheMode.valueOf((String)str);
            }
        };

        public CacheTestHelperModule.ResultCacheMode value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @ComponentSupplier(value=SqlTestFramework.StandardComponentSupplier.class)
    public static @interface ComponentSupplier {
        public static final ConfigOptionProcessor<Class<? extends SqlTestFramework.QueryComponentSupplier>> PROCESSOR = new ConfigOptionProcessor<Class<? extends SqlTestFramework.QueryComponentSupplier>>(ComponentSupplier.class){

            @Override
            public Class<? extends SqlTestFramework.QueryComponentSupplier> fromString(String name) throws Exception {
                return SqlTestFrameworkConfig.getQueryComponentSupplierForName(name);
            }
        };

        public Class<? extends SqlTestFramework.QueryComponentSupplier> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Datasets(value="")
    public static @interface Datasets {
        public static final ConfigOptionProcessor<String> PROCESSOR = new ConfigOptionProcessor<String>(Datasets.class){

            @Override
            public String fromString(String name) {
                return name;
            }
        };

        public String value();
    }

    public static class ConfigurationInstance {
        public SqlTestFramework framework;

        ConfigurationInstance(SqlTestFrameworkConfig config, SqlTestFramework.QueryComponentSupplier testHost) {
            SqlTestFramework.Builder builder = new SqlTestFramework.Builder(testHost).withConfig(config).catalogResolver(testHost.createCatalogResolver()).minTopNThreshold(config.minTopNThreshold).mergeBufferCount(config.numMergeBuffers).withOverrideModule(config.resultCache.makeModule());
            this.framework = builder.build();
        }

        public ConfigurationInstance(SqlTestFrameworkConfig config, Function<SqlTestFramework.QueryComponentSupplier, SqlTestFramework.QueryComponentSupplier> queryComponentSupplierWrapper) throws Exception {
            this(config, queryComponentSupplierWrapper.apply(ConfigurationInstance.makeQueryComponentSupplier(config.componentSupplier)));
        }

        private static SqlTestFramework.QueryComponentSupplier makeQueryComponentSupplier(Class<? extends SqlTestFramework.QueryComponentSupplier> supplierClazz) throws Exception {
            Constructor<? extends SqlTestFramework.QueryComponentSupplier> constructor = supplierClazz.getConstructor(TempDirProducer.class);
            return constructor.newInstance(new TempDirProducer("druid-test"));
        }

        public void close() {
            this.framework.close();
        }
    }

    public static class Rule
    implements AfterAllCallback,
    BeforeEachCallback {
        SqlTestFrameworkConfigStore configStore = new SqlTestFrameworkConfigStore(Function.identity());
        private SqlTestFrameworkConfig config;
        private Method method;
        private String testName;

        public void afterAll(ExtensionContext context) {
            this.configStore.close();
        }

        public void beforeEach(ExtensionContext context) {
            this.makeConfigFromContext(context);
        }

        public void makeConfigFromContext(ExtensionContext context) {
            this.testName = this.buildTestCaseName(context);
            this.method = (Method)context.getTestMethod().get();
            Class testClass = (Class)context.getTestClass().get();
            List<Annotation> annotations = SqlTestFrameworkConfig.collectAnnotations(testClass, this.method);
            this.setConfig(new SqlTestFrameworkConfig(annotations));
        }

        public void setConfig(SqlTestFrameworkConfig config) {
            this.config = config;
        }

        public String buildTestCaseName(ExtensionContext context) {
            ArrayList<String> names = new ArrayList<String>();
            Pattern pattern = Pattern.compile("\\([^)]*\\)");
            do {
                names.add(0, pattern.matcher(context.getDisplayName()).replaceAll(""));
            } while ((context = (ExtensionContext)context.getParent().get()).getTestMethod().isPresent());
            return Joiner.on((String)"@").join(names);
        }

        public SqlTestFrameworkConfig getConfig() {
            return this.config;
        }

        public SqlTestFramework get() throws Exception {
            return this.configStore.getConfigurationInstance((SqlTestFrameworkConfig)this.config).framework;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return this.method.getAnnotation(annotationType);
        }

        public String testName() {
            return this.testName;
        }
    }

    public static class SqlTestFrameworkConfigStore
    implements Closeable {
        private final Function<SqlTestFramework.QueryComponentSupplier, SqlTestFramework.QueryComponentSupplier> queryComponentSupplierWrapper;
        Map<SqlTestFrameworkConfig, ConfigurationInstance> configMap = new HashMap<SqlTestFrameworkConfig, ConfigurationInstance>();

        public SqlTestFrameworkConfigStore(Function<SqlTestFramework.QueryComponentSupplier, SqlTestFramework.QueryComponentSupplier> queryComponentSupplierWrapper) {
            this.queryComponentSupplierWrapper = queryComponentSupplierWrapper;
        }

        public ConfigurationInstance getConfigurationInstance(SqlTestFrameworkConfig config) throws Exception {
            ConfigurationInstance ret = this.configMap.get(config);
            if (!this.configMap.containsKey(config)) {
                ret = new ConfigurationInstance(config, this.queryComponentSupplierWrapper);
                this.configMap.put(config, ret);
            }
            return ret;
        }

        @Override
        public void close() {
            for (ConfigurationInstance f : this.configMap.values()) {
                f.close();
            }
            this.configMap.clear();
        }
    }
}

