/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.druid.java.util.common.StringUtils;

public class SqlSchema {
    private final List<ColumnSignature> columns;

    public SqlSchema(List<ColumnSignature> columns) {
        this.columns = columns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SqlSchema of(RelDataType rowType) {
        Builder builder = new Builder();
        List fields = rowType.getFieldList();
        for (RelDataTypeField field : fields) {
            builder.column(field.getName(), field.getType().getFullTypeString());
        }
        return builder.build();
    }

    public String toString() {
        return "(" + this.columns.stream().map(c -> c.toString()).collect(Collectors.joining(", ")) + ")";
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SqlSchema other = (SqlSchema)o;
        return Objects.equals(this.columns, other.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public static class Builder {
        private final List<ColumnSignature> columns = new ArrayList<ColumnSignature>();

        public Builder column(String name, String type) {
            this.columns.add(new ColumnSignature(name, type));
            return this;
        }

        public SqlSchema build() {
            return new SqlSchema(this.columns);
        }
    }

    public static class ColumnSignature {
        private final String name;
        private final String type;

        public ColumnSignature(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public String type() {
            return this.type;
        }

        public String toString() {
            return StringUtils.format((String)"%s %s", (Object[])new Object[]{this.name, this.type});
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ColumnSignature other = (ColumnSignature)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

