/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.inject.Module;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.DruidInjectorBuilder;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.util.SqlTestFramework;

public abstract class MultiComponentSupplier
implements SqlTestFramework.QueryComponentSupplier {
    private static final Map<Class<? extends SqlTestFramework.QueryComponentSupplier>, Set<Class<? extends MultiComponentSupplier>>> KNOWN_SUB_QUERY_COMPONENT_SUPPLIERS = new LinkedHashMap<Class<? extends SqlTestFramework.QueryComponentSupplier>, Set<Class<? extends MultiComponentSupplier>>>();

    public static void registerComponentSupplier(Class<? extends MultiComponentSupplier> clazz) {
        List<Class<? extends SqlTestFramework.QueryComponentSupplier>> subSuppliers = MultiComponentSupplier.getSuppliers(clazz);
        for (Class<? extends SqlTestFramework.QueryComponentSupplier> subSupplier : subSuppliers) {
            KNOWN_SUB_QUERY_COMPONENT_SUPPLIERS.computeIfAbsent(subSupplier, ignore -> new LinkedHashSet()).add(clazz);
        }
    }

    public static Set<Class<? extends MultiComponentSupplier>> findParentSuppliers(Class<? extends SqlTestFramework.QueryComponentSupplier> clazz) {
        return KNOWN_SUB_QUERY_COMPONENT_SUPPLIERS.get(clazz);
    }

    public static List<Class<? extends SqlTestFramework.QueryComponentSupplier>> getSuppliers(Class<? extends MultiComponentSupplier> clazz) {
        ComponentSuppliers a = clazz.getAnnotation(ComponentSuppliers.class);
        if (a == null || a.value().length == 0) {
            throw DruidException.defensive((String)"No component suppliers found [%s].", (Object[])new Object[]{clazz.getName()});
        }
        return Arrays.asList(a.value());
    }

    private DruidException unsupportedException() {
        return DruidException.defensive((String)("Unexpected call made to " + this.getClass().getName()), (Object[])new Object[0]);
    }

    @Override
    public void gatherProperties(Properties properties) {
        throw this.unsupportedException();
    }

    @Override
    public DruidModule getCoreModule() {
        throw this.unsupportedException();
    }

    @Override
    public DruidModule getOverrideModule() {
        throw this.unsupportedException();
    }

    @Override
    public SpecificSegmentsQuerySegmentWalker addSegmentsToWalker(SpecificSegmentsQuerySegmentWalker walker) {
        throw this.unsupportedException();
    }

    @Override
    public Class<? extends SqlEngine> getSqlEngineClass() {
        throw this.unsupportedException();
    }

    @Override
    public JoinableFactoryWrapper createJoinableFactoryWrapper(LookupExtractorFactoryContainerProvider lookupProvider) {
        throw this.unsupportedException();
    }

    @Override
    public void finalizeTestFramework(SqlTestFramework sqlTestFramework) {
        throw this.unsupportedException();
    }

    @Override
    public SqlTestFramework.PlannerComponentSupplier getPlannerComponentSupplier() {
        throw this.unsupportedException();
    }

    @Override
    public void configureGuice(DruidInjectorBuilder injectorBuilder, List<Module> overrideModules) {
        throw this.unsupportedException();
    }

    @Override
    public Boolean isExplainSupported() {
        throw this.unsupportedException();
    }

    @Override
    public QueryRunnerFactoryConglomerate wrapConglomerate(QueryRunnerFactoryConglomerate conglomerate, Closer resourceCloser) {
        throw this.unsupportedException();
    }

    @Override
    public TempDirProducer getTempDirProducer() {
        throw this.unsupportedException();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ComponentSuppliers {
        public Class<? extends SqlTestFramework.QueryComponentSupplier>[] value();
    }
}

