/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class CalciteUnionQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testUnionAllDifferentTablesWithMapping() {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("numfoo")))).setInterval(CalciteUnionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteUnionQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"def", (Object)"a"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteUnionQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testJoinUnionAllDifferentTablesWithMapping() {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("numfoo")))).setInterval(CalciteUnionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteUnionQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"def", (Object)"a"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteUnionQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testUnionAllTablesColumnCountMismatch() {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteUnionQueryTest.invalidSqlIs("Column count mismatch in UNION ALL (line [3], column [42])"));
        }
    }

    @Test
    public void testUnionAllTablesColumnTypeMismatchFloatLong() {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo2 UNION ALL SELECT dim1, dim2, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'en'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo2"), (Object)new TableDataSource("foo")))).setInterval(CalciteUnionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteUnionQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"en", (Object)"a"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteUnionQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 1.0, 1L}, (Object)new Object[]{"1", "a", 4.0, 1L}, (Object)new Object[]{"druid", "en", 1.0, 1L}));
    }

    @Test
    public void testUnionFlipFlop() {
        String sql = "SELECT\ndim1,dim2,count(1) \nFROM (SELECT dim1 as dim1, dim2 as dim2 FROM foo UNION ALL SELECT dim2 as dim1, dim1 as dim2 FROM foo)\nWHERE dim1 = 'def' OR dim2 = 'def'\nGROUP BY 1, 2";
        if (this.testBuilder().isDecoupledMode()) {
            this.cannotVectorize();
            this.testBuilder().sql(sql).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "def", 1L}, (Object)new Object[]{"def", "abc", 1L})).run();
        } else {
            this.assertQueryIsUnplannable(sql, "names queried for each table are different");
        }
    }

    @Test
    public void testUnionAllTablesColumnTypeMismatchStringLong() {
        String sql = "SELECT\ndim3, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim3, dim2, m1 FROM foo2 UNION ALL SELECT dim3, dim2, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'en'\nGROUP BY 1, 2";
        if (this.testBuilder().isDecoupledMode()) {
            this.cannotVectorize();
            this.testBuilder().sql(sql).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 4.0, 1L}, (Object)new Object[]{"11", "en", 1.0, 1L}, (Object)new Object[]{"a", "a", 1.0, 1L}, (Object)new Object[]{"b", "a", 1.0, 1L})).run();
        } else {
            this.assertQueryIsUnplannable(sql, "SQL requires union between inputs that are not simple table scans and involve a filter or aliasing. Or column types of tables being unioned are not of same type.");
        }
    }

    @Test
    public void testUnionAllTablesWhenMappingIsRequired() {
        String sql = "SELECT\nc, COUNT(*)\nFROM (SELECT dim1 AS c, m1 FROM foo UNION ALL SELECT dim2 AS c, m1 FROM numfoo)\nWHERE c = 'a' OR c = 'def'\nGROUP BY 1";
        if (this.testBuilder().isDecoupledMode()) {
            this.cannotVectorize();
            this.testBuilder().sql(sql).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"def", 1L})).run();
        } else {
            this.assertQueryIsUnplannable(sql, "SQL requires union between two tables and column names queried for each table are different Left: [dim1], Right: [dim2].");
        }
    }

    @Test
    public void testUnionDifferentColumnOrder() {
        String sql = "SELECT dim2, dim1, m1 FROM foo2 UNION SELECT dim1, dim2, m1 FROM foo";
        if (this.testBuilder().isDecoupledMode()) {
            this.testBuilder().sql(sql).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"def", 2L})).expectedResults(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "10.1", Float.valueOf(2.0f)}, (Object)new Object[]{null, "abc", Float.valueOf(6.0f)}, (Object)new Object[]{"", "2", Float.valueOf(3.0f)}, (Object)new Object[]{"a", "", Float.valueOf(1.0f)}, (Object)new Object[]{"a", "1", Float.valueOf(4.0f)}, (Object)new Object[]{"abc", "def", Float.valueOf(5.0f)}, (Object)new Object[]{"en", "druid", Float.valueOf(1.0f)}, (Object)new Object[]{"he", "\u05d3\u05e8\u05d5\u05d0\u05d9\u05d3", Float.valueOf(1.0f)}, (Object)new Object[]{"ru", "\u0434\u0440\u0443\u0438\u0434", Float.valueOf(1.0f)})).run();
        } else {
            this.assertQueryIsUnplannable(sql, "SQL requires 'UNION' but only 'UNION ALL' is supported.");
        }
    }

    @Test
    public void testUnionAllTablesWhenCastAndMappingIsRequired() {
        String sql = "SELECT\nc, COUNT(*)\nFROM (SELECT dim1 AS c, m1 FROM foo UNION ALL SELECT cnt AS c, m1 FROM numfoo)\nWHERE c = '1' OR c = 'def'\nGROUP BY 1";
        if (this.testBuilder().isDecoupledMode()) {
            this.cannotVectorize();
            this.testBuilder().sql(sql).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"1", 7L}, (Object)new Object[]{"def", 1L})).run();
        } else {
            this.assertQueryIsUnplannable(sql, "SQL requires union between inputs that are not simple table scans and involve a filter or aliasing. Or column types of tables being unioned are not of same type.");
        }
    }

    @Test
    public void testUnionAllSameTableTwice() {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteUnionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteUnionQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"def", (Object)"a"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteUnionQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testUnionAllSameTableTwiceWithSameMapping() {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteUnionQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteUnionQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"def", (Object)"a"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteUnionQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testUnionAllSameTableTwiceWithDifferentMapping() {
        String sql = "SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim2, dim1, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2";
        if (this.testBuilder().isDecoupledMode()) {
            this.testBuilder().sql(sql).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L})).run();
        } else {
            this.assertQueryIsUnplannable(sql, "SQL requires union between two tables and column names queried for each table are different Left: [dim1, dim2, m1], Right: [dim2, dim1, m1].");
        }
    }

    @Test
    public void testUnionAllThreeTablesColumnCountMismatch1() {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM numfoo UNION ALL SELECT * FROM foo UNION ALL SELECT * from foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteUnionQueryTest.invalidSqlIs("Column count mismatch in UNION ALL (line [3], column [45])"));
        }
    }

    @Test
    public void testUnionAllThreeTablesColumnCountMismatch2() {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM numfoo UNION ALL SELECT * FROM foo UNION ALL SELECT * from foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteUnionQueryTest.invalidSqlIs("Column count mismatch in UNION ALL (line [3], column [45])"));
        }
    }

    @Test
    public void testUnionAllThreeTablesColumnCountMismatch3() {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM foo UNION ALL SELECT * from numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteUnionQueryTest.invalidSqlIs("Column count mismatch in UNION ALL (line [3], column [70])"));
        }
    }
}

