/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.junit.jupiter.api.Test;

public class CalciteTimeBoundaryQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testMaxTimeQuery() {
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, String> expectedContext = new HashMap<String, String>(QUERY_CONTEXT_DEFAULT);
        expectedContext.put("maxTimeArrayOutputName", "a0");
        this.testQuery("SELECT MAX(__time) AS maxTime FROM foo", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").bound("maxTime").context(expectedContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2001-01-03").getMillis()}));
    }

    @Test
    public void testMinTimeQuery() {
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, String> expectedContext = new HashMap<String, String>(QUERY_CONTEXT_DEFAULT);
        expectedContext.put("minTimeArrayOutputName", "a0");
        this.testQuery("SELECT MIN(__time) AS minTime FROM foo", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").bound("minTime").context(expectedContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000-01-01").getMillis()}));
    }

    @Test
    public void testMinTimeQueryWithTimeFilters() {
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, String> expectedContext = new HashMap<String, String>(QUERY_CONTEXT_DEFAULT);
        expectedContext.put("minTimeArrayOutputName", "a0");
        this.testQuery("SELECT MIN(__time) AS minTime FROM foo where __time >= '2001-01-01' and __time < '2003-01-01'", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2001-01-01T00:00:00.000Z/2003-01-01T00:00:00.000Z")))).bound("minTime").context(expectedContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2001-01-01").getMillis()}));
    }

    @Test
    public void testMinTimeQueryWithTimeAndColumnFilters() {
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, String> expectedContext = new HashMap<String, String>(QUERY_CONTEXT_DEFAULT);
        expectedContext.put("minTimeArrayOutputName", "a0");
        this.testQuery("SELECT MIN(__time) AS minTime FROM foo\nwhere __time >= '2001-01-01' and __time < '2003-01-01'\nand dim2 = 'abc'", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2001-01-01T00:00:00.000Z/2003-01-01T00:00:00.000Z")))).bound("minTime").filters(CalciteTimeBoundaryQueryTest.equality("dim2", "abc", ColumnType.STRING)).context(expectedContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2001-01-02").getMillis()}));
    }

    @Test
    public void testMinTimeQueryWithTimeAndExpressionFilters() {
        this.cannotVectorizeUnlessFallback();
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("enableTimeBoundaryPlanning", true);
        this.testQuery("SELECT MIN(__time) AS minTime FROM foo\nwhere __time >= '2001-01-01' and __time < '2003-01-01'\nand upper(dim2) = 'ABC'", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2001-01-01T00:00:00.000Z/2003-01-01T00:00:00.000Z")))).virtualColumns(new VirtualColumn[]{CalciteTimeBoundaryQueryTest.expressionVirtualColumn("v0", "upper(\"dim2\")", ColumnType.STRING)}).filters(CalciteTimeBoundaryQueryTest.equality("v0", "ABC", ColumnType.STRING)).aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "__time")}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2001-01-02").getMillis()}));
    }

    @Test
    public void testMinMaxTimeQuery() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("enableTimeBoundaryPlanning", true);
        this.testQuery("SELECT MIN(__time) AS minTime, MAX(__time) as maxTime FROM foo", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteTimeBoundaryQueryTest.querySegmentSpec(Filtration.eternity())).aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "__time"), new LongMaxAggregatorFactory("a1", "__time")}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000-01-01").getMillis(), DateTimes.of((String)"2001-01-03").getMillis()}));
    }

    @Test
    public void testMaxTimeQueryWithJoin() {
        this.cannotVectorize();
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("enableTimeBoundaryPlanning", true);
        this.testBuilder().sql("SELECT MAX(t1.__time)\nFROM foo t1\nINNER JOIN foo t2 ON CAST(t1.m1 AS BIGINT) = t2.cnt\n").queryContext(context).expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newTimeBoundaryQueryBuilder().dataSource((DataSource)CalciteTimeBoundaryQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteTimeBoundaryQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteTimeBoundaryQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"cnt"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(context).build()), "j0.", CalciteTimeBoundaryQueryTest.equalsCondition(CalciteTimeBoundaryQueryTest.makeExpression("CAST(\"m1\", 'LONG')"), CalciteTimeBoundaryQueryTest.makeColumnExpression("j0.cnt")), JoinType.INNER)).bound("maxTime").context(context).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L})).run();
    }
}

