/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SingleValueAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TypedInFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@SqlTestFrameworkConfig.ComponentSupplier(value=SubqueryComponentSupplier.class)
public class CalciteSubqueryTest
extends BaseCalciteQueryTest {
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        constructors.add(new Object[]{"without memory limit", QUERY_CONTEXT_DEFAULT});
        constructors.add(new Object[]{"with memory limit", QUERY_CONTEXT_WITH_SUBQUERY_MEMORY_LIMIT});
        return constructors;
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testExactCountDistinctUsingSubqueryWithWhereToOuterFilter(String testName, Map<String, Object> queryContext) {
        if (!queryContext.containsKey("maxSubqueryBytes")) {
            this.cannotVectorize();
        }
        Map contextWithLexicographicTopN = QueryContexts.override(queryContext, (String)"useLexicographicTopN", (Object)true);
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2 LIMIT 1)\nWHERE cnt > 0", (Map<String, Object>)contextWithLexicographicTopN, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(1).build())).setDimFilter(CalciteSubqueryTest.range("a0", ColumnType.LONG, 0L, null, true, false)).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(contextWithLexicographicTopN).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L, 1L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSubqueryOnDataSourceWithMissingColumnsInSegments(String testName, Map<String, Object> queryContext) {
        if (!queryContext.containsKey("maxSubqueryBytes")) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT\n  __time,\n  col1,\n  col2,\n  col3,\n  COUNT(*)\nFROM (SELECT * FROM dsMissingCol LIMIT 10)\nGROUP BY 1, 2, 3, 4", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("dsMissingCol").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "col1", "col2", "col3"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(10L).build())).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("col1", "d1", ColumnType.STRING), new DefaultDimensionSpec("col2", "d2", ColumnType.STRING), new DefaultDimensionSpec("col3", "d3", ColumnType.STRING)}).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "abc", null, "def", 1L}, (Object)new Object[]{946684800000L, "foo", "bar", null, 1L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testExactCountDistinctOfSemiJoinResult(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 <> ''\n  ) AND __time >= '2000-01-01' AND __time < '2002-01-01'\n)", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteSubqueryTest.not(CalciteSubqueryTest.equality("dim1", "", ColumnType.STRING))).setDimensions(CalciteSubqueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteSubqueryTest.equalsCondition(DruidExpression.ofExpression((ColumnType)ColumnType.STRING, null, args -> "substring(\"dim2\", 0, 1)", Collections.emptyList()), DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"j0.d0")), JoinType.INNER)).setInterval(CalciteSubqueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2002-01-01"))).setGranularity(Granularities.ALL).setDimensions(CalciteSubqueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testTwoExactCountDistincts(String testName, Map<String, Object> queryContext) {
        this.testQuery(PLANNER_CONFIG_NO_HLL, queryContext, "SELECT COUNT(distinct dim1), COUNT(distinct dim2) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteSubqueryTest.notNull("d0"))}).setContext(QUERY_CONTEXT_DEFAULT).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteSubqueryTest.notNull("d0"))}).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"a0", "j0.a0"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 3L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testViewAndJoin(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        Map<String, Object> queryContextModified = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("SELECT COUNT(*) FROM view.cview as a INNER JOIN druid.foo d on d.dim2 = a.dim2 WHERE a.dim1_firstchar <> 'z' ", queryContextModified, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(queryContextModified).build()), "j0.", "(\"dim2\" == \"j0.dim2\")", JoinType.INNER, CalciteSubqueryTest.range("dim2", ColumnType.STRING, "a", "a", false, false)), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(queryContextModified).build()), "_j0.", "('a' == \"_j0.dim2\")", JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{CalciteSubqueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)})).filters((DimFilter)CalciteSubqueryTest.not(CalciteSubqueryTest.equality("v0", "z", ColumnType.STRING))).granularity(Granularities.ALL).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(queryContextModified).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testGroupByWithPostAggregatorReferencingTimeFloorColumnOnTimeseries(String testName, Map<String, Object> queryContext) {
        if (!queryContext.containsKey("maxSubqueryBytes")) {
            this.cannotVectorize();
        }
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT TIME_FORMAT(\"date\", 'yyyy-MM'), SUM(x)\nFROM (\n    SELECT\n        FLOOR(__time to hour) as \"date\",\n        COUNT(*) as x\n    FROM foo\n    GROUP BY 1\n)\nGROUP BY 1", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.HOUR).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteSubqueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()).setInterval(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{CalciteSubqueryTest.expressionVirtualColumn("v0", "timestamp_format(\"d0\",'yyyy-MM','UTC')", ColumnType.STRING)}).setGranularity(Granularities.ALL).addDimension((DimensionSpec)new DefaultDimensionSpec("v0", "_d0")).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("_a0", "a0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2000-01", 3L}, (Object)new Object[]{"2001-01", 3L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testUsingSubqueryAsFilterWithInnerSort(String testName, Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1, dim2 FROM druid.foo\n WHERE dim2 IN (\n   SELECT dim2\n   FROM druid.foo\n   GROUP BY dim2\n   ORDER BY dim2 DESC\n )", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteSubqueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteSubqueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"dim2"), DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"j0.d0")), JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a"}, (Object)new Object[]{"2", ""}, (Object)new Object[]{"1", "a"}, (Object)new Object[]{"def", "abc"}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testUsingSubqueryAsFilterOnTwoColumns(String testName, Map<String, Object> queryContext) {
        this.testQuery("SELECT __time, cnt, dim1, dim2 FROM druid.foo  WHERE (dim1, dim2) IN (   SELECT dim1, dim2 FROM (     SELECT dim1, dim2, COUNT(*)     FROM druid.foo     WHERE dim2 = 'abc'     GROUP BY dim1, dim2     HAVING COUNT(*) = 1   ) )", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteSubqueryTest.equality("dim2", "abc", ColumnType.STRING)).setDimensions(CalciteSubqueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteSubqueryTest.expressionPostAgg("p0", "'abc'", ColumnType.STRING)}).setHavingSpec((HavingSpec)CalciteSubqueryTest.having(CalciteSubqueryTest.equality("a0", 1L, ColumnType.LONG))).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", StringUtils.format((String)"(%s && %s)", (Object[])new Object[]{CalciteSubqueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"dim1"), DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"j0.d0")), CalciteSubqueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"dim2"), DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"j0.p0"))}), JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSubqueryTest.expressionVirtualColumn("v0", "'abc'", ColumnType.STRING)}).columns(new String[]{"__time", "cnt", "dim1", "v0"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSubqueryTest.timestamp("2001-01-02"), 1L, "def", "abc"}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testMinMaxAvgDailyCountWithLimit(String testName, Map<String, Object> queryContext) {
        if (!queryContext.containsKey("maxSubqueryBytes")) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT * FROM (  SELECT max(cnt), min(cnt), avg(cnt), TIME_EXTRACT(max(t), 'EPOCH') last_time, count(1) num_days FROM (\n      SELECT TIME_FLOOR(__time, 'P1D') AS t, count(1) cnt\n      FROM \"foo\"\n      GROUP BY 1\n  )) LIMIT 1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(CalciteSubqueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build())).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0"), new LongMinAggregatorFactory("_a1", "a0"), new DoubleSumAggregatorFactory("_a2:sum", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a2:count"), CalciteSubqueryTest.notNull("a0")), new LongMaxAggregatorFactory("_a3", "d0"), new CountAggregatorFactory("_a4")})).setPostAggregatorSpecs(new PostAggregator[]{new ArithmeticPostAggregator("_a2", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "_a2:sum"), (Object)new FieldAccessPostAggregator(null, "_a2:count"))), CalciteSubqueryTest.expressionPostAgg("p0", "timestamp_extract(\"_a3\",'EPOCH','UTC')", ColumnType.LONG)}).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 1L, 1.0, 978480000L, 6L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testEmptyGroupWithOffsetDoesntInfiniteLoop(String testName, Map<String, Object> queryContext) {
        this.testQuery("SELECT r0.c, r1.c\nFROM (\n  SELECT COUNT(*) AS c\n  FROM \"foo\"\n  GROUP BY ()\n  OFFSET 1\n) AS r0\nLEFT JOIN (\n  SELECT COUNT(*) AS c\n  FROM \"foo\"\n  GROUP BY ()\n) AS r1 ON TRUE LIMIT 10", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().offset(1).limit(10).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.LEFT, null)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"a0", "j0.a0"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).limit(10L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testMaxSubqueryRows(String testName, Map<String, Object> queryContext) {
        if ("without memory limit".equals(testName)) {
            this.testMaxSubqueryRowsWithoutMemoryLimit(testName, queryContext);
        } else {
            this.testMaxSubQueryRowsWithLimit(testName, queryContext);
        }
    }

    private void testMaxSubqueryRowsWithoutMemoryLimit(String testName, Map<String, Object> queryContext) {
        HashMap<String, Object> modifiedQueryContext = new HashMap<String, Object>(queryContext);
        modifiedQueryContext.put("maxSubqueryRows", 1);
        modifiedQueryContext.put("useLexicographicTopN", true);
        this.testQueryThrows("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2 LIMIT 2) \nWHERE cnt > 0", modifiedQueryContext, ResourceLimitExceededException.class, (Matcher<Throwable>)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot issue the query, subqueries generated results beyond maximum[1] rows. Try setting the 'maxSubqueryBytes' in the query context to 'auto' for enabling byte based limit, which chooses an optimal limit based on memory size and result's heap usage or manually configure the values of either 'maxSubqueryBytes' or 'maxSubqueryRows' in the query context. Manually alter the value carefully as it can cause the broker to go out of memory.")));
    }

    private void testMaxSubQueryRowsWithLimit(String testName, Map<String, Object> queryContext) {
        HashMap<String, Object> modifiedQueryContext = new HashMap<String, Object>(queryContext);
        modifiedQueryContext.put("maxSubqueryRows", 1);
        modifiedQueryContext.put("useLexicographicTopN", true);
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2 LIMIT 1)\nWHERE cnt > 0", (Map<String, Object>)modifiedQueryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(1).context(modifiedQueryContext).build())).setDimFilter(CalciteSubqueryTest.range("a0", ColumnType.LONG, 0L, null, true, false)).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(modifiedQueryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L, 1L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testZeroMaxNumericInFilter(String testName, Map<String, Object> queryContext) {
        Throwable exception = Assert.assertThrows(UOE.class, () -> {
            HashMap<String, Object> modifiedQueryContext = new HashMap<String, Object>(queryContext);
            modifiedQueryContext.put("maxNumericInFilters", 0);
            this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)modifiedQueryContext, "SELECT COUNT(*)\nFROM druid.numfoo\nWHERE dim6 IN (\n1,2,3\n)\n", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("[maxNumericInFilters] must be greater than 0"));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testUseTimeFloorInsteadOfGranularityOnJoinResult(String testName, Map<String, Object> queryContext) {
        if (!queryContext.containsKey("maxSubqueryBytes")) {
            this.cannotVectorize();
        }
        this.testQuery("WITH main AS (SELECT * FROM foo LIMIT 2)\nSELECT TIME_FLOOR(__time, 'PT1H') AS \"time\", dim1, COUNT(*)\nFROM main\nWHERE dim1 IN (SELECT dim1 FROM main GROUP BY 1 ORDER BY COUNT(*) DESC LIMIT 5)\nGROUP BY 1, 2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteSubqueryTest.join((DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).limit(2L).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).limit(2L).build())).setInterval(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).setGranularity(Granularities.ALL).setDimensions(CalciteSubqueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(5))).build()), "j0.", "(\"dim1\" == \"j0.d0\")", JoinType.INNER)).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSubqueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'PT1H',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSubqueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim1", "d1")})).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "", 1L}, (Object)new Object[]{946771200000L, "10.1", 1L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testJoinWithTimeDimension(String testName, Map<String, Object> queryContext) {
        this.testQuery(PLANNER_CONFIG_DEFAULT, queryContext, "SELECT count(*) FROM druid.foo t1 inner join druid.foo t2 on t1.__time = t2.__time", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"__time"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(queryContext).build()), (String)"j0.", (String)"(\"__time\" == \"j0.__time\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testUsingSubqueryWithLimit(String testName, Map<String, Object> queryContext) {
        if (!queryContext.containsKey("maxSubqueryBytes")) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT COUNT(*) AS cnt FROM ( SELECT * FROM druid.foo LIMIT 10 ) tmpA", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSubqueryTest.expressionVirtualColumn("v0", "0", ColumnType.LONG)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).limit(10L).context(queryContext).build()).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSelfJoin(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM druid.foo x, druid.foo y\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{36L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testJoinWithSubqueries(String testName, Map<String, Object> queryContext) {
        ArrayList<Object[]> results = new ArrayList<Object[]>((Collection<Object[]>)ImmutableList.of((Object)new Object[]{"", null}, (Object)new Object[]{"10.1", null}, (Object)new Object[]{"2", null}, (Object)new Object[]{"1", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"abc", null}));
        this.testQuery("SELECT a.dim1, b.dim2\nFROM (SELECT na.dim1 as dim1, nb.dim2 as dim2 FROM foo na LEFT JOIN foo2 nb ON na.dim1 = nb.dim1) a\nFULL OUTER JOIN\n(SELECT nc.dim1 as dim1, nd.dim2 as dim2 FROM foo nc LEFT JOIN foo2 nd ON nc.dim1 = nd.dim1) b\nON a.dim1 = b.dim1", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo2").columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).eternityInterval().build()), (String)"j0.", (String)"(\"dim1\" == \"j0.dim1\")", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo2").columns(new String[]{"dim1", "dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).eternityInterval().build()), (String)"j0.", (String)"(\"dim1\" == \"j0.dim1\")", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).columns(new String[]{"dim1", "j0.dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).eternityInterval().build()), (String)"_j0.", (String)"(\"dim1\" == \"_j0.dim1\")", (JoinType)JoinType.FULL, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).columns(new String[]{"dim1", "_j0.j0.dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).eternityInterval().build()), (List<Object[]>)results);
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSingleValueFloatAgg(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT count(*) FROM foo where m1 <= (select min(m1) + 4 from foo)").expectedQuery((Query<?>)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1")}).postAggregators(new PostAggregator[]{CalciteSubqueryTest.expressionPostAgg("p0", "(\"a0\" + 4)", ColumnType.FLOAT)}).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteSubqueryTest.expressionFilter("(\"m1\" <= \"j0.p0\")")).context(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{5L})).run();
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSingleValueDoubleAgg(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT count(*) FROM foo where m1 >= (select max(m1) - 3.5 from foo)").expectedQuery((Query<?>)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new FloatMaxAggregatorFactory("a0", "m1")}).postAggregators(new PostAggregator[]{CalciteSubqueryTest.expressionPostAgg("p0", "(\"a0\" - 3.5)", ColumnType.DOUBLE)}).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteSubqueryTest.expressionFilter("(\"m1\" >= \"j0.p0\")")).context(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{4L})).run();
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSingleValueLongAgg(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT count(*) FROM wikipedia where __time >= (select max(__time) - INTERVAL '10' MINUTE from wikipedia)").expectedQuery((Query<?>)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("wikipedia"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("wikipedia").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).postAggregators(new PostAggregator[]{CalciteSubqueryTest.expressionPostAgg("p0", "(\"a0\" - 600000)", ColumnType.LONG)}).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteSubqueryTest.expressionFilter("(\"__time\" >= \"j0.p0\")")).context(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{220L})).run();
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSingleValueStringAgg(String testName, Map<String, Object> queryContext) {
        this.testBuilder().sql("SELECT count(*) FROM wikipedia where channel = (select channel from wikipedia order by __time desc LIMIT 1 OFFSET 6)").expectedQuery((Query<?>)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("wikipedia"), (DataSource)new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("wikipedia").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).offset(6L).limit(1L).order(Order.DESCENDING).columns(new String[]{"channel", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"channel\" == \"j0.channel\")", JoinType.INNER)).intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSubqueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{1256L})).run();
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSingleValueStringMultipleRowsAgg(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQueryThrows("SELECT  count(*) FROM wikipedia where channel = (select channel from wikipedia order by __time desc LIMIT 2 OFFSET 6)", RuntimeException.class, "java.util.concurrent.ExecutionException: org.apache.druid.error.DruidException: Subquery expression returned more than one row");
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testSingleValueEmptyInnerAgg(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT distinct countryName FROM wikipedia where countryName = ( select countryName from wikipedia where channel in ('abc', 'xyz'))", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteSubqueryTest.join((DataSource)new TableDataSource("wikipedia"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("wikipedia").intervals(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteSubqueryTest.expressionVirtualColumn("v0", "\"countryName\"", ColumnType.STRING)}).aggregators(new AggregatorFactory[]{new SingleValueAggregatorFactory("a0", "v0", ColumnType.STRING)}).filters(CalciteSubqueryTest.in("channel", Arrays.asList("abc", "xyz"))).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"countryName\" == \"j0.a0\")", JoinType.INNER)).addDimension((DimensionSpec)new DefaultDimensionSpec("countryName", "d0", ColumnType.STRING)).setInterval(CalciteSubqueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testGroupBySubqueryWithEarliestAggregator(String testName, Map<String, Object> queryContext) {
        this.cannotVectorize();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{"", "a", "a", ""}, (Object)new Object[]{"", "b", "a", ""}, (Object)new Object[]{"1", "", "a", "1"}, (Object)new Object[]{"10.1", "b", null, "10.1"}, (Object)new Object[]{"10.1", "c", null, "10.1"}, (Object)new Object[]{"2", "d", "", "2"}, (Object)new Object[]{"abc", null, null, "abc"}, (Object)new Object[]{"def", null, "abc", "def"});
        this.testQuery("SELECT a.dim1, a.dim3, a.e_dim2, b.dim1 FROM ( SELECT dim1, dim3, EARLIEST(dim2) AS e_dim2  FROM foo GROUP BY 1, 2 LIMIT 100) a INNER JOIN foo b ON a.dim1 = b.dim1", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim3", "d1", ColumnType.STRING)}).addAggregator((AggregatorFactory)new StringFirstAggregatorFactory("a0", "dim2", "__time", Integer.valueOf(1024))).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.emptyList(), Integer.valueOf(100))).build()), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (String)"j0.", (String)"(\"d0\" == \"j0.dim1\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)TestExprMacroTable.INSTANCE, null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"d0", "d1", "a0", "j0.dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expectedResults);
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testTopNSubqueryWithEarliestAggregator(String testName, Map<String, Object> queryContext) {
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{"", "a", ""}, (Object)new Object[]{"1", "a", "1"}, (Object)new Object[]{"10.1", null, "10.1"}, (Object)new Object[]{"2", "", "2"}, (Object)new Object[]{"abc", null, "abc"}, (Object)new Object[]{"def", "abc", "def"});
        Map contextWithTopN = QueryContexts.override(queryContext, (String)"useLexicographicTopN", (Object)true);
        this.testQuery("SELECT a.dim1, a.e_dim2, b.dim1 FROM ( SELECT dim1, EARLIEST(dim2) AS e_dim2  FROM foo  GROUP BY 1  LIMIT 100) a INNER JOIN foo b ON a.dim1 = b.dim1", (Map<String, Object>)contextWithTopN, (List<Query<?>>)ImmutableList.of((Object)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(100).intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0", "dim2", "__time", Integer.valueOf(1024))}).build()), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (String)"j0.", (String)"(\"d0\" == \"j0.dim1\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)TestExprMacroTable.INSTANCE, null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"d0", "a0", "j0.dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(contextWithTopN).build()), (List<Object[]>)expectedResults);
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testTimeseriesSubqueryWithEarliestAggregator(String testName, Map<String, Object> queryContext) {
        this.testQuery("SELECT a.__time, a.e_dim2, b.__time FROM ( SELECT TIME_FLOOR(\"__time\", 'PT24H') as __time, EARLIEST(dim2) AS e_dim2  FROM foo  GROUP BY 1 ) a INNER JOIN foo b ON a.__time = b.__time", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteSubqueryTest.newScanQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).granularity((Granularity)new PeriodGranularity(new Period((Object)"PT24H"), null, DateTimeZone.UTC)).aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0", "dim2", "__time", Integer.valueOf(1024))}).build()), (DataSource)new QueryDataSource((Query)CalciteSubqueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"__time"}).columnTypes(new ColumnType[]{ColumnType.LONG}).build()), (String)"j0.", (String)"(\"d0\" == \"j0.__time\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)TestExprMacroTable.INSTANCE, null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).intervals(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).columns(new String[]{"d0", "a0", "j0.__time"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.LONG}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "a", 946684800000L}, (Object)new Object[]{946771200000L, null, 946771200000L}, (Object)new Object[]{946857600000L, "", 946857600000L}, (Object)new Object[]{978307200000L, "a", 978307200000L}, (Object)new Object[]{978393600000L, "abc", 978393600000L}, (Object)new Object[]{978480000000L, null, 978480000000L}));
    }

    @MethodSource(value={"constructorFeeder"})
    @ParameterizedTest(name="{0}")
    public void testScalarInArrayToUseHavingFilter(String testName, Map<String, Object> queryContext) {
        this.cannotVectorizeUnlessFallback();
        TypedInFilter filter = new TypedInFilter("v0", ColumnType.LONG, null, (List)ImmutableList.of((Object)1, (Object)17), null);
        this.testQuery("select countryName from (select countryName, length(countryName) as cname from wikipedia group by countryName) where SCALAR_IN_ARRAY(cname, ARRAY[17, 1])", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new TableDataSource("wikipedia")).setInterval(CalciteSubqueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{CalciteSubqueryTest.expressionVirtualColumn("v0", "strlen(\"countryName\")", ColumnType.LONG)}).setDimFilter((DimFilter)filter).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("countryName", "d0", ColumnType.STRING)}).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"Republic of Korea"}));
    }

    public static class SubqueryComponentSupplier
    extends SqlTestFramework.StandardComponentSupplier {
        private final TempDirProducer tmpDirProducer;

        public SubqueryComponentSupplier(TempDirProducer tempDirProducer) {
            super(tempDirProducer);
            this.tmpDirProducer = tempDirProducer;
        }

        @Override
        public SpecificSegmentsQuerySegmentWalker addSegmentsToWalker(SpecificSegmentsQuerySegmentWalker walker) {
            String datasource1 = "dsMissingCol";
            File tmpFolder = this.tempDirProducer.newTempFolder();
            ImmutableList rawRows1 = ImmutableList.of((Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"col1", (Object)"foo").put((Object)"col2", (Object)"bar").build());
            List rows1 = rawRows1.stream().map(mapInputRow -> MapInputRowParser.parse((InputRowSchema)new InputRowSchema(new TimestampSpec("t", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"col1", (Object)"col2"))), null), (Map)mapInputRow)).collect(Collectors.toList());
            QueryableIndex queryableIndex1 = IndexBuilder.create().tmpDir(new File(tmpFolder, "dsMissingCol")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OnHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withRollup(false).withDimensionsSpec(new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("col1"), (Object)new StringDimensionSchema("col2")))).build()).rows(rows1).buildMMappedIndex();
            ImmutableList rawRows2 = ImmutableList.of((Object)ImmutableMap.builder().put((Object)"t", (Object)"2000-01-01").put((Object)"col1", (Object)"abc").put((Object)"col3", (Object)"def").build());
            List rows2 = rawRows2.stream().map(mapInputRow -> MapInputRowParser.parse((InputRowSchema)new InputRowSchema(new TimestampSpec("t", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"col1", (Object)"col3"))), null), (Map)mapInputRow)).collect(Collectors.toList());
            QueryableIndex queryableIndex2 = IndexBuilder.create().tmpDir(new File(tmpFolder, "dsMissingCol")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OnHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withRollup(false).withDimensionsSpec(new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("col1"), (Object)new StringDimensionSchema("col3")))).build()).rows(rows2).buildMMappedIndex();
            super.addSegmentsToWalker(walker);
            walker.add(DataSegment.builder().dataSource("dsMissingCol").interval(Intervals.ETERNITY).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), queryableIndex1);
            walker.add(DataSegment.builder().dataSource("dsMissingCol").interval(Intervals.ETERNITY).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build(), queryableIndex2);
            return walker;
        }
    }
}

