/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import org.apache.druid.error.DruidException;
import org.apache.druid.query.Query;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.CalciteIngestionDmlTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=StrictInsertComponentSupplier.class)
public class CalciteStrictInsertTest
extends CalciteIngestionDmlTest {
    @Test
    public void testInsertIntoNewTable() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "Cannot INSERT into [dst] because it does not exist").verify();
    }

    @Test
    public void testInsertIntoExisting() {
        this.testIngestionQuery().sql("INSERT INTO druid.numfoo SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("numfoo", FOO_TABLE_SIGNATURE).expectResources(CalciteStrictInsertTest.dataSourceRead("foo"), CalciteStrictInsertTest.dataSourceWrite("numfoo")).expectQuery((Query)CalciteStrictInsertTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteStrictInsertTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    static class StrictInsertComponentSupplier
    extends CalciteIngestionDmlTest.IngestionDmlComponentSupplier {
        public StrictInsertComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public CatalogResolver createCatalogResolver() {
            return new CatalogResolver.NullCatalogResolver(){

                public boolean ingestRequiresExistingTable() {
                    return true;
                }
            };
        }
    }
}

