/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.CalciteIngestionDmlTest;
import org.apache.druid.sql.calcite.external.Externals;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class CalciteReplaceDmlTest
extends CalciteIngestionDmlTest {
    private static final Map<String, Object> REPLACE_ALL_TIME_CHUNKS = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)"{\"type\":\"all\"}", (Object)"sqlReplaceTimeChunks", (Object)"all");

    protected Map<String, Object> addReplaceTimeChunkToQueryContext(Map<String, Object> context, String replaceTimeChunks) {
        return ImmutableMap.builder().putAll(context).put((Object)"sqlReplaceTimeChunks", (Object)replaceTimeChunks).build();
    }

    @Test
    public void testReplaceFromTableWithReplaceAll() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceFromTableWithDeleteWhereClause() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00' SELECT * FROM foo PARTITIONED BY DAY").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.addReplaceTimeChunkToQueryContext(this.queryContextWithGranularity(Granularities.DAY), "2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z")).build()).verify();
    }

    @Test
    public void testReplaceFromTableWithTimeZoneInQueryContext() {
        HashMap<String, Object> context = new HashMap<String, Object>(DEFAULT_CONTEXT);
        context.put("sqlTimeZone", "+05:30");
        this.testIngestionQuery().context(context).sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 05:30:00' AND __time < TIMESTAMP '2000-01-02 05:30:00' SELECT * FROM foo PARTITIONED BY DAY").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.addReplaceTimeChunkToQueryContext(this.queryContextWithGranularity(Granularities.DAY), "2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z")).build()).verify();
    }

    @Test
    public void testReplaceFromTableWithIntervalLargerThanOneGranularity() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01' AND __time < TIMESTAMP '2000-05-01' SELECT * FROM foo PARTITIONED BY MONTH").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.addReplaceTimeChunkToQueryContext(this.queryContextWithGranularity(Granularities.MONTH), "2000-01-01T00:00:00.000Z/2000-05-01T00:00:00.000Z")).build()).verify();
    }

    @Test
    public void testReplaceFromTableWithComplexDeleteWhereClause() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01' AND __time < TIMESTAMP '2000-02-01' OR __time >= TIMESTAMP '2000-03-01' AND __time < TIMESTAMP '2000-04-01' SELECT * FROM foo PARTITIONED BY MONTH").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.addReplaceTimeChunkToQueryContext(this.queryContextWithGranularity(Granularities.MONTH), "2000-01-01T00:00:00.000Z/2000-02-01T00:00:00.000Z,2000-03-01T00:00:00.000Z/2000-04-01T00:00:00.000Z")).build()).verify();
    }

    @Test
    public void testReplaceFromTableWithBetweenClause() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time BETWEEN TIMESTAMP '2000-01-01' AND TIMESTAMP '2000-01-31 23:59:59.999' SELECT * FROM foo PARTITIONED BY MONTH").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.addReplaceTimeChunkToQueryContext(this.queryContextWithGranularity(Granularities.MONTH), "2000-01-01T00:00:00.000Z/2000-02-01T00:00:00.000Z")).build()).verify();
    }

    @Test
    public void testReplaceForUnsupportedDeleteWhereClause() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time LIKE '20__-02-01' SELECT * FROM foo PARTITIONED BY MONTH").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Invalid OVERWRITE WHERE clause [`__time` LIKE '20__-02-01']: Unsupported operation [LIKE] in OVERWRITE WHERE clause.")).verify();
    }

    @Test
    public void testReplaceForInvalidDeleteWhereClause() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE TRUE SELECT * FROM foo PARTITIONED BY MONTH").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Invalid OVERWRITE WHERE clause [TRUE]: expected clause including AND, OR, NOT, >, <, >=, <= OR BETWEEN operators")).verify();
    }

    @Test
    public void testReplaceForDeleteWhereClauseOnUnsupportedColumns() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE dim1 > TIMESTAMP '2000-01-05 00:00:00' SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("OVERWRITE WHERE clause only supports filtering on the __time column, got [947030400000 < dim1 as numeric]")).verify();
    }

    @Test
    public void testReplaceWithOrderBy() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT * FROM foo ORDER BY dim1 PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Cannot use an ORDER BY clause on a Query of type [REPLACE], use CLUSTERED BY instead")).verify();
    }

    @Test
    public void testReplaceForMisalignedPartitionInterval() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-05 00:00:00' AND __time <= TIMESTAMP '2000-01-06 00:00:00' SELECT * FROM foo PARTITIONED BY MONTH").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("OVERWRITE WHERE clause identified interval [2000-01-05T00:00:00.000Z/2000-01-06T00:00:00.001Z] which is not aligned with PARTITIONED BY granularity [{type=period, period=P1M, timeZone=UTC, origin=null}]")).verify();
    }

    @Test
    public void testReplaceForInvalidPartition() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-05 00:00:00' AND __time <= TIMESTAMP '2000-02-05 00:00:00' SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("OVERWRITE WHERE clause identified interval [2000-01-05T00:00:00.000Z/2000-02-05T00:00:00.001Z] which is not aligned with PARTITIONED BY granularity [AllGranularity]")).verify();
    }

    @Test
    public void testReplaceFromTableWithEmptyInterval() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time < TIMESTAMP '2000-01-01' AND __time > TIMESTAMP '2000-01-01' SELECT * FROM foo PARTITIONED BY MONTH").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("The OVERWRITE WHERE clause [(__time as numeric < 946684800000 && 946684800000 < __time as numeric)] produced no time intervals, are the bounds overly restrictive?")).verify();
    }

    @Test
    public void testReplaceForWithInvalidInterval() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-INVALID0:00' AND __time <= TIMESTAMP '2000-02-05 00:00:00' SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(DruidException.class).verify();
    }

    @Test
    public void testReplaceForWithoutPartitionSpec() {
        this.testIngestionQuery().sql("REPLACE INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(DruidException.class).verify();
    }

    @Test
    public void testReplaceFromView() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT * FROM view.aview PARTITIONED BY ALL TIME").expectTarget("dst", RowSignature.builder().add("dim1_firstchar", ColumnType.STRING).build()).expectResources(CalciteReplaceDmlTest.viewRead("aview"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteReplaceDmlTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters(CalciteReplaceDmlTest.equality("dim2", "a", ColumnType.STRING)).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceIntoQualifiedTable() {
        this.testIngestionQuery().sql("REPLACE INTO druid.dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceContainingWithList() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL WITH foo_data AS (SELECT * FROM foo) SELECT dim1, dim3 FROM foo_data PARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("dim1", ColumnType.STRING).add("dim3", ColumnType.STRING).build()).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceIntoInvalidDataSourceName() {
        this.testIngestionQuery().sql("REPLACE INTO \"in/valid\" OVERWRITE ALL SELECT dim1, dim2 FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [table]: Value [in/valid] cannot contain '/'.")).verify();
    }

    @Test
    public void testReplaceUsingColumnList() {
        this.testIngestionQuery().sql("REPLACE INTO dst (foo, bar) OVERWRITE ALL SELECT dim1, dim2 FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Operation [REPLACE] cannot be run with a target column list, given [dst (`foo`, `bar`)]")).verify();
    }

    @Test
    public void testReplaceWithoutPartitionedBy() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Operation [REPLACE] requires a PARTITIONED BY to be explicitly defined, but none was found.")).verify();
    }

    @Test
    public void testReplaceWithoutPartitionedByWithClusteredBy() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo CLUSTERED BY dim1").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("CLUSTERED BY found before PARTITIONED BY, CLUSTERED BY must come after the PARTITIONED BY clause")).verify();
    }

    @Test
    public void testReplaceWithoutOverwriteClause() {
        this.testIngestionQuery().sql("REPLACE INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Missing time chunk information in OVERWRITE clause for REPLACE. Use OVERWRITE WHERE <__time based condition> or OVERWRITE ALL to overwrite the entire table.")).verify();
    }

    @Test
    public void testReplaceWithoutCompleteOverwriteClause() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Missing time chunk information in OVERWRITE clause for REPLACE. Use OVERWRITE WHERE <__time based condition> or OVERWRITE ALL to overwrite the entire table.")).verify();
    }

    @Test
    public void testReplaceIntoSystemTable() {
        this.testIngestionQuery().sql("REPLACE INTO INFORMATION_SCHEMA.COLUMNS OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Table [INFORMATION_SCHEMA.COLUMNS] does not support operation [REPLACE] because it is not a Druid datasource")).verify();
    }

    @Test
    public void testReplaceIntoView() {
        this.testIngestionQuery().sql("REPLACE INTO view.aview OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Table [view.aview] does not support operation [REPLACE] because it is not a Druid datasource")).verify();
    }

    @Test
    public void testReplaceFromUnauthorizedDataSource() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT * FROM \"%s\" PARTITIONED BY ALL TIME", "forbiddenDatasource", new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testReplaceIntoUnauthorizedDataSource() {
        this.testIngestionQuery().sql("REPLACE INTO \"%s\" OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME", "forbiddenDatasource", new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testReplaceIntoNonexistentSchema() {
        this.testIngestionQuery().sql("REPLACE INTO nonexistent.dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Table [nonexistent.dst] does not support operation [REPLACE] because it is not a Druid datasource")).verify();
    }

    @Test
    public void testReplaceFromExternal() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(CalciteReplaceDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceWithPartitionedByAndLimitOffset() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testIngestionQuery().sql("REPLACE INTO druid.dst OVERWRITE ALL SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo LIMIT 10 OFFSET 20 PARTITIONED BY DAY").expectTarget("dst", targetRowSignature).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.STRING}).virtualColumns(new VirtualColumn[]{CalciteReplaceDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).limit(10L).offset(20L).context(this.addReplaceTimeChunkToQueryContext(this.queryContextWithGranularity(Granularities.DAY), "all")).build()).verify();
    }

    @Test
    public void testReplaceWithClusteredBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testIngestionQuery().sql("REPLACE INTO druid.dst OVERWRITE ALL SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo PARTITIONED BY DAY CLUSTERED BY 2, dim1").expectTarget("dst", targetRowSignature).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.STRING}).virtualColumns(new VirtualColumn[]{CalciteReplaceDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"v0"), (Object)OrderBy.ascending((String)"dim1"))).context(this.addReplaceTimeChunkToQueryContext(this.queryContextWithGranularity(Granularities.DAY), "all")).build()).verify();
    }

    @Test
    public void testPartitionedBySupportedGranularityLiteralClauses() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).build();
        Map<String, Granularity> partitionedByToGranularity = Arrays.stream(GranularityType.values()).collect(Collectors.toMap(Enum::name, GranularityType::getDefaultGranularity));
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        partitionedByToGranularity.forEach((partitionedByArgument, expectedGranularity) -> {
            ImmutableMap queryContext = null;
            try {
                queryContext = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)queryJsonMapper.writeValueAsString(expectedGranularity));
            }
            catch (JsonProcessingException e) {
                Assert.fail((String)e.getMessage());
            }
            this.testIngestionQuery().sql(StringUtils.format((String)"REPLACE INTO druid.dst OVERWRITE ALL SELECT __time, dim1 FROM foo PARTITIONED BY '%s'", (Object[])new Object[]{partitionedByArgument})).expectTarget("dst", targetRowSignature).expectResources(CalciteReplaceDmlTest.dataSourceRead("foo"), CalciteReplaceDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).context((Map)queryContext).build()).verify();
            this.didTest = false;
        });
        this.didTest = true;
    }

    @Test
    public void testReplaceWithPartitionedByContainingInvalidGranularity() {
        try {
            this.testQuery("REPLACE INTO dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY 'invalid_granularity'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Exception should be thrown");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteReplaceDmlTest.invalidSqlIs("Invalid granularity['invalid_granularity'] specified after PARTITIONED BY clause. Expected 'SECOND', 'MINUTE', 'FIVE_MINUTE', 'TEN_MINUTE', 'FIFTEEN_MINUTE', 'THIRTY_MINUTE', 'HOUR', 'SIX_HOUR', 'EIGHT_HOUR', 'DAY', 'MONTH', 'QUARTER', 'YEAR', 'ALL', ALL TIME, FLOOR() or TIME_FLOOR()"));
        }
        this.didTest = true;
    }

    @Test
    public void testExplainReplaceFromExternal() throws IOException {
        this.skipVectorize();
        String query = StringUtils.format((String)"EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE ALL SELECT * FROM %s PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)});
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        ScanQuery expectedQuery = CalciteReplaceDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context((Map)queryJsonMapper.readValue("{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"all\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT)).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).build();
        String legacyExplanation = "DruidQueryRel(query=[" + queryJsonMapper.writeValueAsString((Object)expectedQuery) + "], signature=[{x:STRING, y:STRING, z:LONG}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"inline\",\"data\":\"a,b,1\\nc,d,2\\n\"},\"inputFormat\":{\"type\":\"csv\",\"columns\":[\"x\",\"y\",\"z\"]},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"x\",\"y\",\"z\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"all\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"x\",\"outputColumn\":\"x\"},{\"queryColumn\":\"y\",\"outputColumn\":\"y\"},{\"queryColumn\":\"z\",\"outputColumn\":\"z\"}]}]";
        String resources = "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":{\"type\":\"all\"},\"replaceTimeChunks\":\"all\"}";
        this.testQuery(PLANNER_CONFIG_LEGACY_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), query, CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{legacyExplanation, "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":{\"type\":\"all\"},\"replaceTimeChunks\":\"all\"}"}), null));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), query, CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"inline\",\"data\":\"a,b,1\\nc,d,2\\n\"},\"inputFormat\":{\"type\":\"csv\",\"columns\":[\"x\",\"y\",\"z\"]},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"x\",\"y\",\"z\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"all\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"x\",\"outputColumn\":\"x\"},{\"queryColumn\":\"y\",\"outputColumn\":\"y\"},{\"queryColumn\":\"z\",\"outputColumn\":\"z\"}]}]", "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":{\"type\":\"all\"},\"replaceTimeChunks\":\"all\"}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainReplaceTimeChunksWithPartitioningAndClustering() throws IOException {
        this.skipVectorize();
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        ScanQuery expectedQuery = CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"dim1"))).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context((Map)queryJsonMapper.readValue("{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT)).build();
        String legacyExplanation = "DruidQueryRel(query=[" + queryJsonMapper.writeValueAsString((Object)expectedQuery) + "], signature=[{__time:LONG, dim1:STRING, dim2:STRING, dim3:STRING, cnt:LONG, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"dim1\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"dim1\",\"dim2\",\"dim3\",\"cnt\",\"m1\",\"m2\",\"unique_dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\",\"LONG\",\"FLOAT\",\"DOUBLE\",\"COMPLEX<hyperUnique>\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"dim2\",\"outputColumn\":\"dim2\"},{\"queryColumn\":\"dim3\",\"outputColumn\":\"dim3\"},{\"queryColumn\":\"cnt\",\"outputColumn\":\"cnt\"},{\"queryColumn\":\"m1\",\"outputColumn\":\"m1\"},{\"queryColumn\":\"m2\",\"outputColumn\":\"m2\"},{\"queryColumn\":\"unique_dim1\",\"outputColumn\":\"unique_dim1\"}]}]";
        String resources = "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"DAY\",\"clusteredBy\":[\"dim1\"],\"replaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\"}";
        String sql = "EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00' SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY dim1 ASC";
        this.testQuery(PLANNER_CONFIG_LEGACY_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00' SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY dim1 ASC", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{legacyExplanation, "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"DAY\",\"clusteredBy\":[\"dim1\"],\"replaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\"}"}), null));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00' SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY dim1 ASC", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"dim1\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"dim1\",\"dim2\",\"dim3\",\"cnt\",\"m1\",\"m2\",\"unique_dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\",\"LONG\",\"FLOAT\",\"DOUBLE\",\"COMPLEX<hyperUnique>\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"dim2\",\"outputColumn\":\"dim2\"},{\"queryColumn\":\"dim3\",\"outputColumn\":\"dim3\"},{\"queryColumn\":\"cnt\",\"outputColumn\":\"cnt\"},{\"queryColumn\":\"m1\",\"outputColumn\":\"m1\"},{\"queryColumn\":\"m2\",\"outputColumn\":\"m2\"},{\"queryColumn\":\"unique_dim1\",\"outputColumn\":\"unique_dim1\"}]}]", "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"DAY\",\"clusteredBy\":[\"dim1\"],\"replaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\"}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainReplaceWithLimitAndClusteredByOrdinals() throws IOException {
        this.skipVectorize();
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        ScanQuery expectedQuery = CalciteReplaceDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).limit(10L).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"), (Object)OrderBy.ascending((String)"dim1"), (Object)OrderBy.ascending((String)"dim3"), (Object)OrderBy.ascending((String)"dim2"))).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context((Map)queryJsonMapper.readValue("{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"HOUR\\\"\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT)).build();
        String legacyExplanation = "DruidQueryRel(query=[" + queryJsonMapper.writeValueAsString((Object)expectedQuery) + "], signature=[{__time:LONG, dim1:STRING, dim2:STRING, dim3:STRING, cnt:LONG, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"limit\":10,\"orderBy\":[{\"columnName\":\"__time\",\"order\":\"ascending\"},{\"columnName\":\"dim1\",\"order\":\"ascending\"},{\"columnName\":\"dim3\",\"order\":\"ascending\"},{\"columnName\":\"dim2\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"dim1\",\"dim2\",\"dim3\",\"cnt\",\"m1\",\"m2\",\"unique_dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"HOUR\\\"\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\",\"LONG\",\"FLOAT\",\"DOUBLE\",\"COMPLEX<hyperUnique>\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"dim2\",\"outputColumn\":\"dim2\"},{\"queryColumn\":\"dim3\",\"outputColumn\":\"dim3\"},{\"queryColumn\":\"cnt\",\"outputColumn\":\"cnt\"},{\"queryColumn\":\"m1\",\"outputColumn\":\"m1\"},{\"queryColumn\":\"m2\",\"outputColumn\":\"m2\"},{\"queryColumn\":\"unique_dim1\",\"outputColumn\":\"unique_dim1\"}]}]";
        String resources = "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"__time\",\"dim1\",\"dim3\",\"dim2\"],\"replaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\"}";
        String sql = "EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'   SELECT * FROM foo LIMIT 10 PARTITIONED BY HOUR CLUSTERED BY __time, dim1, 4, dim2";
        this.testQuery(PLANNER_CONFIG_LEGACY_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'   SELECT * FROM foo LIMIT 10 PARTITIONED BY HOUR CLUSTERED BY __time, dim1, 4, dim2", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{legacyExplanation, "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"__time\",\"dim1\",\"dim3\",\"dim2\"],\"replaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\"}"}), null));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'   SELECT * FROM foo LIMIT 10 PARTITIONED BY HOUR CLUSTERED BY __time, dim1, 4, dim2", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"limit\":10,\"orderBy\":[{\"columnName\":\"__time\",\"order\":\"ascending\"},{\"columnName\":\"dim1\",\"order\":\"ascending\"},{\"columnName\":\"dim3\",\"order\":\"ascending\"},{\"columnName\":\"dim2\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"dim1\",\"dim2\",\"dim3\",\"cnt\",\"m1\",\"m2\",\"unique_dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"HOUR\\\"\",\"sqlQueryId\":\"dummy\",\"sqlReplaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\",\"LONG\",\"FLOAT\",\"DOUBLE\",\"COMPLEX<hyperUnique>\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"dim2\",\"outputColumn\":\"dim2\"},{\"queryColumn\":\"dim3\",\"outputColumn\":\"dim3\"},{\"queryColumn\":\"cnt\",\"outputColumn\":\"cnt\"},{\"queryColumn\":\"m1\",\"outputColumn\":\"m1\"},{\"queryColumn\":\"m2\",\"outputColumn\":\"m2\"},{\"queryColumn\":\"unique_dim1\",\"outputColumn\":\"unique_dim1\"}]}]", "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"REPLACE\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"__time\",\"dim1\",\"dim3\",\"dim2\"],\"replaceTimeChunks\":\"2000-01-01T00:00:00.000Z/2000-01-02T00:00:00.000Z\"}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainPlanReplaceWithClusteredByDescThrowsException() {
        this.skipVectorize();
        String sql = "EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00' SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY dim1 DESC";
        this.testIngestionQuery().sql("EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00' SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY dim1 DESC").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Invalid CLUSTERED BY clause [`dim1` DESC]: cannot sort in descending order.")).verify();
    }

    @Test
    public void testExplainReplaceFromExternalUnauthorized() {
        Assert.assertThrows(ForbiddenException.class, () -> this.testQuery(StringUtils.format((String)"EXPLAIN PLAN FOR REPLACE INTO dst OVERWRITE ALL SELECT * FROM %s PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        this.didTest = true;
    }

    @Test
    public void testReplaceFromExternalUnauthorized() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testReplaceWithNonExistentOrdinalInClusteredBy() {
        String sql = "REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'  SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY 1, 2, 100";
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'  SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY 1, 2, 100").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlContains("Ordinal out of range")).verify();
    }

    @Test
    public void testReplaceWithNegativeOrdinalInClusteredBy() {
        String sql = "REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'  SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY 1, -2, 3 DESC";
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'  SELECT * FROM foo PARTITIONED BY DAY CLUSTERED BY 1, -2, 3 DESC").expectValidationError((Matcher<Throwable>)CalciteReplaceDmlTest.invalidSqlIs("Ordinal [-2] specified in the CLUSTERED BY clause is invalid. It must be a positive integer.")).verify();
    }

    @Test
    public void testReplaceFromExternalProjectSort() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT x || y AS xy, z FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("xy", ColumnType.STRING).add("z", ColumnType.LONG).build()).expectResources(CalciteReplaceDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteReplaceDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteReplaceDmlTest.expressionVirtualColumn("v0", "concat(\"x\",\"y\")", ColumnType.STRING)}).columns(new String[]{"v0", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceFromExternalAggregate() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT x, SUM(z) AS sum_z, COUNT(*) AS cnt FROM %s GROUP BY 1 PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("x", ColumnType.STRING).add("sum_z", ColumnType.LONG).add("cnt", ColumnType.LONG).build()).expectResources(CalciteReplaceDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)this.externalDataSource).setInterval(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteReplaceDmlTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("x", "d0")})).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "z"), new CountAggregatorFactory("a1")}).setContext(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceFromExternalAggregateAll() {
        this.testIngestionQuery().sql("REPLACE INTO dst OVERWRITE ALL SELECT COUNT(*) AS cnt FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("cnt", ColumnType.LONG).build()).expectResources(CalciteReplaceDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)this.externalDataSource).setInterval(CalciteReplaceDmlTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(REPLACE_ALL_TIME_CHUNKS).build()).verify();
    }

    @Test
    public void testReplaceWithSqlOuterLimit() {
        HashMap<String, Object> context = new HashMap<String, Object>(DEFAULT_CONTEXT);
        context.put("sqlOuterLimit", 100);
        this.testIngestionQuery().context(context).sql("REPLACE INTO dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)DruidExceptionMatcher.invalidInput().expectMessageIs("Context parameter [sqlOuterLimit] cannot be provided on operator [REPLACE]")).verify();
    }
}

