/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Test;

public class CalciteMultiValueStringQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testMultiValueStringWorksLikeStringGroupBy() {
        this.cannotVectorize();
        HashMap<String, Object> groupByOnMultiValueColumnEnabled = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        groupByOnMultiValueColumnEnabled.put("groupByEnableMultiValueUnnesting", true);
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"bfoo", 2L}, (Object)new Object[]{"afoo", 1L}, (Object)new Object[]{"cfoo", 1L}, (Object)new Object[]{"dfoo", 1L}, (Object)new Object[]{"foo", 1L});
        this.testQuery("SELECT concat(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)groupByOnMultiValueColumnEnabled, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'foo')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testMultiValueStringGroupByDoesNotWork() {
        HashMap<String, Object> groupByOnMultiValueColumnDisabled = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        groupByOnMultiValueColumnDisabled.put("groupByEnableMultiValueUnnesting", false);
        this.testQueryThrows("SELECT concat(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", groupByOnMultiValueColumnDisabled, RuntimeException.class, (Matcher<Throwable>)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)StringUtils.format((String)"org.apache.druid.query.groupby.epinephelinae.UnexpectedMultiValueDimensionException: Encountered multi-value dimension [%s] that cannot be processed with '%s' set to false. Consider setting '%s' to true in your query context.", (Object[])new Object[]{"v0", "groupByEnableMultiValueUnnesting", "groupByEnableMultiValueUnnesting"}))));
    }

    @Test
    public void testMultiValueStringWorksLikeStringGroupByWithFilter() {
        this.cannotVectorize();
        this.testQuery("SELECT concat(dim3, '', 'foo'), SUM(cnt) FROM druid.numfoo where concat(dim3, '', 'foo') = 'bfoo' GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'','foo')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setDimFilter(CalciteMultiValueStringQueryTest.equality("v0", "bfoo", ColumnType.STRING)).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"bfoo", 2L}, (Object)new Object[]{"afoo", 1L}, (Object)new Object[]{"cfoo", 1L}));
    }

    @Test
    public void testMultiValueStringWorksLikeStringScan() {
        this.testQuery("SELECT concat(dim3, 'foo') FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'foo')", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"afoo\",\"bfoo\"]"}, (Object)new Object[]{"[\"bfoo\",\"cfoo\"]"}, (Object)new Object[]{"dfoo"}, (Object)new Object[]{"foo"}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testMultiValueStringWorksLikeStringSelfConcatScan() {
        this.testQuery("SELECT concat(dim3, '-lol-', dim3) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'-lol-',\"dim3\")", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a-lol-a\",\"b-lol-b\"]"}, (Object)new Object[]{"[\"b-lol-b\",\"c-lol-c\"]"}, (Object)new Object[]{"d-lol-d"}, (Object)new Object[]{"-lol-"}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testMultiValueStringWorksLikeStringScanWithFilter() {
        this.testQuery("SELECT concat(dim3, '', 'foo') FROM druid.numfoo where concat(dim3, '', 'foo') = 'bfoo'", (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'','foo')", ColumnType.STRING)}).filters(CalciteMultiValueStringQueryTest.equality("v0", "bfoo", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"v0")).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"afoo\",\"bfoo\"]"}, (Object)new Object[]{"[\"bfoo\",\"cfoo\"]"}));
    }

    @Test
    public void testMultiValueStringOverlapFilter() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_OVERLAP(dim3, ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters(CalciteMultiValueStringQueryTest.in("dim3", (Collection<String>)ImmutableList.of((Object)"a", (Object)"b"))).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}));
    }

    @Test
    public void testMultiValueStringOverlapFilterNull() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_OVERLAP(dim3, ARRAY[NULL]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)NullFilter.forColumn((String)"dim3")).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testMultiValueStringOverlapFilterNonLiteral() {
        this.testQuery("SELECT dim2, dim3 FROM druid.numfoo WHERE MV_OVERLAP(dim3, ARRAY[dim2]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)CalciteMultiValueStringQueryTest.expressionFilter("mv_overlap(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim2", "dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "[\"a\",\"b\"]"}, (Object)new Object[]{null, null}));
    }

    @Test
    public void testMultiValueStringContainsFilter() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_CONTAINS(dim3, ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)CalciteMultiValueStringQueryTest.and(CalciteMultiValueStringQueryTest.equality("dim3", "a", ColumnType.STRING), CalciteMultiValueStringQueryTest.equality("dim3", "b", ColumnType.STRING))).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testMultiValueStringContainsFilterNull() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_CONTAINS(dim3, ARRAY[NULL]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)NullFilter.forColumn((String)"dim3")).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testMultiValueStringContainsArrayOfOneElement() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_CONTAINS(dim3, ARRAY['a']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters(CalciteMultiValueStringQueryTest.equality("dim3", "a", ColumnType.STRING)).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testMultiValueStringContainsArrayOfNonLiteral() {
        this.testQuery("SELECT dim2, ARRAY[dim2], dim3 FROM druid.numfoo WHERE MV_CONTAINS(dim3, ARRAY[dim2]) LIMIT 5", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array(\"dim2\")", ColumnType.STRING_ARRAY)}).filters((DimFilter)CalciteMultiValueStringQueryTest.expressionFilter("mv_contains(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim2", "v0", "dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING_ARRAY, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", Collections.singletonList("a"), "[\"a\",\"b\"]"}, (Object)new Object[]{null, Collections.singletonList(null), null}));
    }

    @Test
    public void testMultiValueStringSlice() {
        this.testQuery("SELECT MV_SLICE(dim3, 1) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_slice(\"dim3\",1)", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"[]"}, (Object)new Object[]{"[]"}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testMultiValueStringLength() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1, MV_LENGTH(dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1, 2 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 2, 1L}, (Object)new Object[]{"10.1", 2, 1L}, (Object)new Object[]{"1", 1, 1L}, (Object)new Object[]{"2", 1, 1L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"def", null, 1L}));
    }

    @Test
    public void testMultiValueStringAppend() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{"foo", 4L}, (Object)new Object[]{null, 2L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT MV_APPEND(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_append(\"dim3\",'foo')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringPrepend() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{"foo", 4L}, (Object)new Object[]{null, 2L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT MV_PREPEND('foo', dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_prepend('foo',\"dim3\")", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringPrependAppend() {
        this.cannotVectorizeUnlessFallback();
        ImmutableList results = ImmutableList.of((Object)new Object[]{null, null, 2L}, (Object)new Object[]{"foo,", ",foo", 1L}, (Object)new Object[]{"foo,a,b", "a,b,foo", 1L}, (Object)new Object[]{"foo,b,c", "b,c,foo", 1L}, (Object)new Object[]{"foo,d", "d,foo", 1L});
        this.testQuery("SELECT MV_TO_STRING(MV_PREPEND('foo', dim3), ','), MV_TO_STRING(MV_APPEND(dim3, 'foo'), ','), SUM(cnt) FROM druid.numfoo GROUP BY 1,2 ORDER BY 3 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_to_string(array_prepend('foo',\"dim3\"),',')", ColumnType.STRING), CalciteMultiValueStringQueryTest.expressionVirtualColumn("v1", "array_to_string(array_append(\"dim3\",'foo'),',')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("v1", "d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringConcat() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{"b", 4L}, (Object)new Object[]{null, 2L}, (Object)new Object[]{"", 2L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"c", 2L}, (Object)new Object[]{"d", 2L});
        this.testQuery("SELECT MV_CONCAT(dim3, dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_concat(\"dim3\",\"dim3\")", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringConcatBackwardsCompat0dot22andOlder() {
        try {
            ExpressionProcessing.initializeForHomogenizeNullMultiValueStrings();
            this.cannotVectorize();
            ImmutableList results = ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 4L}, (Object)new Object[]{"", 2L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"c", 2L}, (Object)new Object[]{"d", 2L});
            this.testQuery("SELECT MV_CONCAT(dim3, dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_concat(\"dim3\",\"dim3\")", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
        }
        finally {
            ExpressionProcessing.initializeForTests();
        }
    }

    @Test
    public void testMultiValueStringOffset() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT MV_OFFSET(dim3, 1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_offset(\"dim3\",1)", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testMultiValueStringOrdinal() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT MV_ORDINAL(dim3, 2), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_ordinal(\"dim3\",2)", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testMultiValueStringOffsetOf() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT MV_OFFSET_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_offset_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{0, 1L}, (Object)new Object[]{1, 1L}));
    }

    @Test
    public void testMultiValueStringOrdinalOf() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT MV_ORDINAL_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_ordinal_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{1, 1L}, (Object)new Object[]{2, 1L}));
    }

    @Test
    public void testMultiValueStringToString() {
        this.cannotVectorizeUnlessFallback();
        ImmutableList results = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a,b", 1L}, (Object)new Object[]{"b,c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT MV_TO_STRING(dim3, ','), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_to_string(\"dim3\",',')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringToStringToMultiValueString() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{"d", 5L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L});
        this.testQuery("SELECT STRING_TO_MV(CONCAT(MV_TO_STRING(dim3, ','), ',d'), ','), SUM(cnt) FROM druid.numfoo WHERE MV_LENGTH(dim3) > 0 GROUP BY 1 ORDER BY 2 DESC, 1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG), CalciteMultiValueStringQueryTest.expressionVirtualColumn("v1", "string_to_array(concat(array_to_string(\"dim3\",','),',d'),',')", ColumnType.STRING)}).setDimFilter(CalciteMultiValueStringQueryTest.range("v0", ColumnType.LONG, 0L, null, true, false)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testSelectAndFilterByStringToMV() {
        this.testBuilder().sql("SELECT STRING_TO_MV(CONCAT(MV_TO_STRING(dim3, ','), ',d'), ',') FROM druid.numfoo WHERE MV_CONTAINS(STRING_TO_MV(CONCAT(MV_TO_STRING(dim3, ','), ',d'), ','), 'd')").expectedQuery((Query<?>)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "string_to_array(concat(array_to_string(\"dim3\",','),',d'),',')", ColumnType.STRING)}).filters((DimFilter)CalciteMultiValueStringQueryTest.expressionFilter("mv_contains(string_to_array(concat(array_to_string(\"dim3\",','),',d'),','),'d')")).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\",\"d\"]"}, (Object)new Object[]{"[\"b\",\"c\",\"d\"]"}, (Object)new Object[]{"[\"d\",\"d\"]"}, (Object)new Object[]{"[\"\",\"d\"]"})).run();
    }

    @Test
    public void testStringToMVOfConstant() {
        this.testBuilder().sql("SELECT m1, STRING_TO_MV('a,b', ',') AS mv FROM druid.numfoo GROUP BY 1").expectedQuery((Query<?>)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setPostAggregatorSpecs(new PostAggregator[]{CalciteMultiValueStringQueryTest.expressionPostAgg("p0", "string_to_array('a,b',',')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)})).setContext(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), "[\"a\",\"b\"]"}, (Object)new Object[]{Float.valueOf(2.0f), "[\"a\",\"b\"]"}, (Object)new Object[]{Float.valueOf(3.0f), "[\"a\",\"b\"]"}, (Object)new Object[]{Float.valueOf(4.0f), "[\"a\",\"b\"]"}, (Object)new Object[]{Float.valueOf(5.0f), "[\"a\",\"b\"]"}, (Object)new Object[]{Float.valueOf(6.0f), "[\"a\",\"b\"]"})).run();
    }

    @Test
    public void testStringToMVOfConstantGroupedBy() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT m1, STRING_TO_MV('a,b', ',') AS mv FROM druid.numfoo GROUP BY 1, 2").expectedQuery((Query<?>)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "string_to_array('a,b',',')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT), new DefaultDimensionSpec("v0", "d1", ColumnType.STRING)})).setContext(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), "a"}, (Object)new Object[]{Float.valueOf(1.0f), "b"}, (Object)new Object[]{Float.valueOf(2.0f), "a"}, (Object)new Object[]{Float.valueOf(2.0f), "b"}, (Object)new Object[]{Float.valueOf(3.0f), "a"}, (Object)new Object[]{Float.valueOf(3.0f), "b"}, (Object)new Object[]{Float.valueOf(4.0f), "a"}, (Object)new Object[]{Float.valueOf(4.0f), "b"}, (Object)new Object[]{Float.valueOf(5.0f), "a"}, (Object)new Object[]{Float.valueOf(5.0f), "b"}, (Object)new Object[]{Float.valueOf(6.0f), "a"}, (Object)new Object[]{Float.valueOf(6.0f), "b"}, (Object[])new Object[0][])).run();
    }

    @Test
    public void testStringToMVOfStringAgg() {
        this.cannotVectorize();
        String expectedResult = "[\"\",\"10.1\",\"2\",\"1\",\"def\",\"abc\"]";
        this.testBuilder().sql("SELECT STRING_TO_MV(STRING_AGG(dim1, ','), ',') AS mv, COUNT(*) cnt FROM druid.numfoo").expectedQuery((Query<?>)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"dim1\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteMultiValueStringQueryTest.notNull("dim1")), new CountAggregatorFactory("a1")}).postAggregators(new PostAggregator[]{CalciteMultiValueStringQueryTest.expressionPostAgg("p0", "string_to_array(\"a0\",',')", ColumnType.STRING)}).context(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"\",\"10.1\",\"2\",\"1\",\"def\",\"abc\"]", 6L})).run();
    }

    @Test
    public void testMultiValueListFilter() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_FILTER_ONLY(dim3, ARRAY['b']), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 2L}));
    }

    @Test
    public void testMultiValueListFilterNonLiteral() {
        this.testQuery("SELECT MV_FILTER_ONLY(dim3, ARRAY[dim2]) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "filter((x) -> array_contains(array(\"dim2\"), x), \"dim3\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testMultiValueListFilterDeny() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_FILTER_NONE(dim3, ARRAY['b']), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(false))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L}));
    }

    @Test
    public void testMultiValueListFilterDenyNonLiteral() {
        this.testQuery("SELECT MV_FILTER_NONE(dim3, ARRAY[dim2]) FROM druid.numfoo", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "filter((x) -> !array_contains(array(\"dim2\"), x), \"dim3\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"[\"b\",\"c\"]"}, (Object)new Object[]{"d"}, (Object)new Object[]{""}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testMultiValueListFilterComposed() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_LENGTH(MV_FILTER_ONLY(dim3, ARRAY['b'])), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"v1\")", ColumnType.LONG), new ListFilteredVirtualColumn("v1", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{1, 2L}));
    }

    @Test
    public void testMultiValueListFilterComposedNested() {
        this.cannotVectorize();
        this.testQuery("SELECT COALESCE(MV_FILTER_ONLY(dim3, ARRAY['b']), 'no b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "nvl(\"v1\",'no b')", ColumnType.STRING), new ListFilteredVirtualColumn("v1", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 2L}));
    }

    @Test
    public void testMultiValueListFilterComposedNested2Input() {
        this.cannotVectorize();
        this.testQuery("SELECT COALESCE(MV_FILTER_ONLY(dim3, ARRAY['b']), dim1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "nvl(\"v1\",\"dim1\")", ColumnType.STRING), new ListFilteredVirtualColumn("v1", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 2L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testMultiValueListFilterComposedNestedNullLiteral() {
        this.cannotVectorize();
        HashSet<String> filter = new HashSet<String>();
        filter.add(null);
        filter.add("b");
        this.testQuery("SELECT COALESCE(MV_FILTER_ONLY(dim3, ARRAY[NULL, 'b']), 'no b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "nvl(\"v1\",'no b')", ColumnType.STRING), new ListFilteredVirtualColumn("v1", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), filter, Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"no b", 1L}));
    }

    @Test
    public void testMultiValueListFilterComposedDeny() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_LENGTH(MV_FILTER_NONE(dim3, ARRAY['b'])), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"v1\")", ColumnType.LONG), new ListFilteredVirtualColumn("v1", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(false))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1, 4L}, (Object)new Object[]{null, 2L}));
    }

    @Test
    public void testMultiValueListFilterComposedMultipleExpressions() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_LENGTH(MV_FILTER_ONLY(dim3, ARRAY['b'])), MV_LENGTH(dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1,2 ORDER BY 3 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"v2\")", ColumnType.LONG), CalciteMultiValueStringQueryTest.expressionVirtualColumn("v1", "array_length(\"dim3\")", ColumnType.LONG), new ListFilteredVirtualColumn("v2", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, 2L}, (Object)new Object[]{null, 1, 2L}, (Object)new Object[]{1, 2, 2L}));
    }

    @Test
    public void testFilterOnMultiValueListFilterNoMatch() {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, SUM(cnt) FROM druid.numfoo WHERE MV_FILTER_ONLY(dim3, ARRAY['b']) = 'a' GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimFilter(CalciteMultiValueStringQueryTest.equality("v0", "a", ColumnType.STRING)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterOnMultiValueListFilterMatch() {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, SUM(cnt) FROM druid.numfoo WHERE MV_FILTER_ONLY(dim3, ARRAY['b']) = 'b' GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimFilter(CalciteMultiValueStringQueryTest.equality("v0", "b", ColumnType.STRING)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testFilterOnMultiValueListFilterMatchLike() {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, SUM(cnt) FROM druid.numfoo WHERE MV_FILTER_ONLY(dim3, ARRAY['b']) LIKE 'b%' GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimFilter((DimFilter)new LikeDimFilter("v0", "b%", null, null)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testMultiValueToArrayGroupAsArrayWithMultiValueDimension() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_TO_ARRAY(dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim3\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d"), 1L}));
    }

    @Test
    public void testMultiValueToArrayGroupAsArrayWithSingleValueDim() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_TO_ARRAY(dim1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim1\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"10.1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"abc"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"def"), 1L}));
    }

    @Test
    public void testMultiValueToArrayGroupAsArrayWithSingleValueDimIsNotConvertedToTopN() {
        this.cannotVectorize();
        this.testQuery("SELECT MV_TO_ARRAY(dim1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC limit 10", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim1\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(10))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"10.1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"abc"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"def"), 1L}));
    }

    @Test
    public void testMultiValueToArrayMoreArgs() {
        this.testQueryThrows("SELECT MV_TO_ARRAY(dim3,dim3) FROM druid.numfoo", CalciteMultiValueStringQueryTest.invalidSqlContains("Invalid number of arguments to function"));
    }

    @Test
    public void testMultiValueToArrayNoArgs() {
        this.testQueryThrows("SELECT MV_TO_ARRAY() FROM druid.numfoo", CalciteMultiValueStringQueryTest.invalidSqlContains("Invalid number of arguments to function"));
    }

    @Test
    public void testMultiValueToArrayArgsWithMultiValueDimFunc() {
        this.testQueryThrows("SELECT MV_TO_ARRAY(concat(dim3,'c')) FROM druid.numfoo", RuntimeException.class, "Function[mv_to_array] argument (concat [dim3, c]) should be an identifier expression. Use array() instead");
    }

    @Test
    public void testMultiValueToArrayArgsWithSingleDimFunc() {
        this.testQueryThrows("SELECT MV_TO_ARRAY(concat(dim1,'c')) FROM druid.numfoo", RuntimeException.class, "Function[mv_to_array] argument (concat [dim1, c]) should be an identifier expression. Use array() instead");
    }

    @Test
    public void testMultiValueToArrayArgsWithConstant() {
        this.testQueryThrows("SELECT MV_TO_ARRAY(concat(dim1,'c')) FROM druid.numfoo", RuntimeException.class, "Function[mv_to_array] argument (concat [dim1, c]) should be an identifier expression. Use array() instead");
    }

    @Test
    public void testMultiValueToArrayArgsWithArray() {
        this.testQueryThrows("SELECT MV_TO_ARRAY(Array[1,2]) FROM druid.numfoo", RuntimeException.class, "Function[mv_to_array] argument (array [1, 2]) should be an identifier expression. Use array() instead");
    }

    @Test
    public void testMultiValueStringOverlapFilterCoalesceNvl() {
        this.testQuery("SELECT COALESCE(dim3, 'other') FROM druid.numfoo WHERE MV_OVERLAP(COALESCE(MV_TO_ARRAY(dim3), ARRAY['other']), ARRAY['a', 'b', 'other']) OR MV_OVERLAP(NVL(MV_TO_ARRAY(dim3), ARRAY['other']), ARRAY['a', 'b', 'other']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "nvl(\"dim3\",'other')", ColumnType.STRING, this.queryFramework().macroTable())}).filters((DimFilter)CalciteMultiValueStringQueryTest.expressionFilter("mv_overlap(nvl(mv_to_array(\"dim3\"),array('other')),array('a','b','other'))")).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}, (Object)new Object[]{"other"}, (Object)new Object[]{"other"}));
    }

    @Test
    public void testMultiValueStringOverlapFilterCoalesceSingleValue() {
        this.testQuery("SELECT COALESCE(dim3, 'other') FROM druid.numfoo WHERE MV_OVERLAP(COALESCE(dim3, 'other'), ARRAY['a', 'b', 'other']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "nvl(\"dim3\",'other')", ColumnType.STRING)}).filters((DimFilter)CalciteMultiValueStringQueryTest.or(CalciteMultiValueStringQueryTest.isNull("dim3"), CalciteMultiValueStringQueryTest.in("dim3", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"b", (Object)"other")))).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}, (Object)new Object[]{"other"}, (Object)new Object[]{"other"}));
    }

    @Test
    public void testMultiValueStringOverlapFilterCoalesceSingleValueOtherColumn() {
        this.testQuery("SELECT COALESCE(dim3, dim2) FROM druid.numfoo WHERE MV_OVERLAP(COALESCE(dim3, dim2), ARRAY['a', 'b', 'other']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "nvl(\"dim3\",\"dim2\")", ColumnType.STRING, this.queryFramework().macroTable())}).filters((DimFilter)CalciteMultiValueStringQueryTest.or(new DimFilter[]{CalciteMultiValueStringQueryTest.and(CalciteMultiValueStringQueryTest.in("dim3", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"b", (Object)"other")), CalciteMultiValueStringQueryTest.notNull("dim3")), CalciteMultiValueStringQueryTest.and(CalciteMultiValueStringQueryTest.isNull("dim3"), CalciteMultiValueStringQueryTest.in("dim2", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"b", (Object)"other")))})).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}));
    }

    @Test
    public void testMultiValueStringOverlapFilterInconsistentUsage() {
        this.testQueryThrows("SELECT COALESCE(dim3, 'other') FROM druid.numfoo WHERE MV_OVERLAP(COALESCE(dim3, ARRAY['other']), ARRAY['a', 'b', 'other']) LIMIT 5", CalciteMultiValueStringQueryTest.invalidSqlContains("Illegal mixing of types in CASE or COALESCE statement"));
    }

    @Test
    public void testMultiValuedFilterOnlyWhenLookupPullsInDuplicates() {
        this.cannotVectorize();
        this.testBuilder().sql("SELECT \n  MV_FILTER_ONLY(LOOKUP(dim3,'lookyloo'),ARRAY[null]),count(1) \nFROM druid.foo AS t group by 1\n").expectedQuery((Query<?>)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new ExtractionDimensionSpec("dim3", "dim3", ColumnType.STRING, (ExtractionFn)new RegisteredLookupExtractionFn(null, "lookyloo", false, null, null, Boolean.valueOf(false))), Collections.singleton(null), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{null, 7L})).run();
    }

    @Test
    public void testMvContainsFilterWithExtractionFn() {
        Druids.ScanQueryBuilder builder = CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "substring(\"dim3\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteMultiValueStringQueryTest.and(CalciteMultiValueStringQueryTest.equality("v0", "a", ColumnType.STRING), CalciteMultiValueStringQueryTest.equality("v0", "b", ColumnType.STRING)));
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_CONTAINS(SUBSTRING(dim3, 1, 1), ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)builder.build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testMvContainsSelectColumns() {
        this.testQuery("SELECT MV_CONTAINS(dim3, ARRAY['a', 'b']), MV_OVERLAP(dim3, ARRAY['a', 'b']) FROM druid.numfoo LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_contains(\"dim3\",array('a','b'))", ColumnType.LONG), CalciteMultiValueStringQueryTest.expressionVirtualColumn("v1", "mv_overlap(\"dim3\",array('a','b'))", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{true, true}, (Object)new Object[]{false, true}, (Object)new Object[]{false, false}, (Object)new Object[]{false, false}, (Object)new Object[]{false, null}));
    }

    @Test
    public void testMvContainsOnMvConcat() {
        this.testQuery("SELECT dim3, MV_CONTAINS(MV_CONCAT(dim3, ARRAY['c']), ARRAY['a', 'b']), MV_OVERLAP(MV_CONCAT(dim3, ARRAY['c']), ARRAY['a', 'b']) FROM druid.numfoo LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3", "v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG, ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_contains(array_concat(\"dim3\",array('c')),array('a','b'))", ColumnType.LONG), CalciteMultiValueStringQueryTest.expressionVirtualColumn("v1", "mv_overlap(array_concat(\"dim3\",array('c')),array('a','b'))", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", true, true}, (Object)new Object[]{"[\"b\",\"c\"]", false, true}, (Object)new Object[]{"d", false, false}, (Object)new Object[]{"", false, false}, (Object)new Object[]{null, false, null}));
    }
}

