/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.DecoupledTestConfig;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CalciteCorrelatedQueryTest
extends BaseCalciteQueryTest {
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCorrelatedSubquery(Map<String, Object> queryContext) {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select avg(\"users\") from (\n            select floor(__time to day), count(distinct user) \"users\" from visits f where f.country = visits.country group by 1\n        )\n     ) as \"DAU\"\nfrom visits \ngroup by 1", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimFilter(CalciteCorrelatedQueryTest.notNull("country")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0:a", null, Collections.singletonList(new DefaultDimensionSpec("user", "user")), false, true)}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("a0", "a0:a"))).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0:sum", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0:count"), CalciteCorrelatedQueryTest.notNull("a0"))}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("_a0", "quotient", Arrays.asList(new FieldAccessPostAggregator(null, "_a0:sum"), new FieldAccessPostAggregator(null, "_a0:count"))))).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT)).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new DoubleAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"India", 2.0}, (Object)new Object[]{"USA", 1.0}, (Object)new Object[]{"canada", 3.0}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCorrelatedSubqueryWithLeftFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(*) \"users\" from visits f where f.country = visits.country group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' and __time between '2021-01-01 01:00:00' AND '2021-01-02 23:59:59' group by 1", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimFilter(CalciteCorrelatedQueryTest.notNull("country")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT, CalciteCorrelatedQueryTest.equality("city", "B", ColumnType.STRING))).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.of((String)"2021-01-01T01:00:00.000Z/2021-01-02T23:59:59.001Z"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 4L}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCorrelatedSubqueryWithLeftFilter_leftDirectAccessDisabled(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(*) \"users\" from visits f where f.country = visits.country group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' and __time between '2021-01-01 01:00:00' AND '2021-01-02 23:59:59' group by 1", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new QueryDataSource((Query)CalciteCorrelatedQueryTest.newScanQueryBuilder().dataSource("visits").intervals(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.of((String)"2021-01-01T01:00:00.000Z/2021-01-02T23:59:59.001Z"))).filters(CalciteCorrelatedQueryTest.equality("city", "B", ColumnType.STRING)).columns(new String[]{"__time", "country", "city"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING}).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimFilter(CalciteCorrelatedQueryTest.notNull("country")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT)).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 4L}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCorrelatedSubqueryWithCorrelatedQueryFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(user) \"users\" from visits f where f.country = visits.country and f.city = 'A' group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' group by 1", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteCorrelatedQueryTest.notNull("user"))}).setDimFilter((DimFilter)CalciteCorrelatedQueryTest.and(CalciteCorrelatedQueryTest.equality("city", "A", ColumnType.STRING), CalciteCorrelatedQueryTest.notNull("country"))).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT, CalciteCorrelatedQueryTest.equality("city", "B", ColumnType.STRING))).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 2L}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCorrelatedSubqueryWithCorrelatedQueryFilter_Scan(Map<String, Object> queryContext) {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(user) \"users\" from visits f where f.country = visits.country and f.city = 'A' group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' group by 1", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteCorrelatedQueryTest.notNull("user"))}).setDimFilter((DimFilter)CalciteCorrelatedQueryTest.and(CalciteCorrelatedQueryTest.equality("city", "A", ColumnType.STRING), CalciteCorrelatedQueryTest.notNull("country"))).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT, CalciteCorrelatedQueryTest.equality("city", "B", ColumnType.STRING))).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 2L}));
    }

    private Map<String, Object> withTimestampResultContext(Map<String, Object> input, String timestampResultField, Granularity granularity) {
        return this.withTimestampResultContext(input, timestampResultField, 0, granularity);
    }
}

