/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.SqlType;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.ArrayContainsElementFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.DecoupledTestConfig;
import org.apache.druid.sql.calcite.NotYetSupported;
import org.apache.druid.sql.calcite.QueryTestRunner;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.http.SqlParameter;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=SqlTestFramework.StandardComponentSupplier.class)
public class CalciteArraysQueryTest
extends BaseCalciteQueryTest {
    private static final Map<String, Object> QUERY_CONTEXT_UNNEST = ImmutableMap.builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"sqlStringifyArrays", (Object)false).build();

    public static void assertResultsDeepEquals(String sql, List<Object[]> expected, List<Object[]> results) {
        for (int row = 0; row < results.size(); ++row) {
            for (int col = 0; col < results.get(row).length; ++col) {
                String rowString = StringUtils.format((String)"result #%d: %s", (Object[])new Object[]{row + 1, sql});
                CalciteArraysQueryTest.assertDeepEquals(rowString + " - column: " + col + ":", expected.get(row)[col], results.get(row)[col]);
            }
        }
    }

    public static void assertDeepEquals(String path, Object expected, Object actual) {
        if (expected instanceof List && actual instanceof List) {
            List expectedList = (List)expected;
            List actualList = (List)actual;
            Assert.assertEquals((String)(path + " arrays length mismatch"), (long)expectedList.size(), (long)actualList.size());
            for (int i = 0; i < expectedList.size(); ++i) {
                CalciteArraysQueryTest.assertDeepEquals(path + "[" + i + "]", expectedList.get(i), actualList.get(i));
            }
        } else {
            Assert.assertEquals((String)path, (Object)expected, (Object)actual);
        }
    }

    @Test
    public void testSelectConstantArrayExpressionFromTable() {
        this.testQuery("SELECT ARRAY[1,2] as arr, dim1 FROM foo LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(1,2)", ColumnType.LONG_ARRAY)}).columns(new String[]{"v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1,2]", ""}));
    }

    @Test
    public void testGroupByArrayFromCase() {
        this.cannotVectorize();
        this.testQuery("SELECT CASE WHEN dim4 = 'a' THEN ARRAY['foo','bar','baz'] END as mv_value, count(1) from numfoo GROUP BY 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "case_searched((\"dim4\" == 'a'),array('foo','bar','baz'),null)", ColumnType.STRING_ARRAY)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz"), 3L}));
    }

    @Test
    public void testGroupByArrayColumnFromCase() {
        this.cannotVectorize();
        this.testQuery("SELECT CASE WHEN arrayStringNulls = ARRAY['a', 'b'] THEN arrayLongNulls END as arr, count(1) from arrays GROUP BY 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("arrays").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "case_searched((\"arrayStringNulls\" == array('a','b')),\"arrayLongNulls\",null)", ColumnType.LONG_ARRAY)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG_ARRAY)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 11L}, (Object)new Object[]{Arrays.asList(1L, null, 3L), 1L}, (Object)new Object[]{Arrays.asList(2L, 3L), 2L}));
    }

    @Test
    public void testSelectNonConstantArrayExpressionFromTable() {
        this.testQuery("SELECT ARRAY[CONCAT(dim1, 'word'),'up'] as arr, dim1 FROM foo LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(concat(\"dim1\",'word'),'up')", ColumnType.STRING_ARRAY)}).columns(new String[]{"v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"word\",\"up\"]", ""}, (Object)new Object[]{"[\"10.1word\",\"up\"]", "10.1"}, (Object)new Object[]{"[\"2word\",\"up\"]", "2"}, (Object)new Object[]{"[\"1word\",\"up\"]", "1"}, (Object)new Object[]{"[\"defword\",\"up\"]", "def"}));
    }

    @Test
    public void testSelectNonConstantArrayExpressionFromTableForMultival() {
        this.msqIncompatible();
        String sql = "SELECT ARRAY[CONCAT(dim3, 'word'),'up'] as arr, dim1 FROM foo LIMIT 5";
        ScanQuery scanQuery = CalciteArraysQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(concat(\"dim3\",'word'),'up')", ColumnType.STRING_ARRAY)}).columns(new String[]{"v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build();
        this.testQuery("SELECT ARRAY[CONCAT(dim3, 'word'),'up'] as arr, dim1 FROM foo LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)scanQuery), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[[\"aword\",\"up\"],[\"bword\",\"up\"]]", ""}, (Object)new Object[]{"[[\"bword\",\"up\"],[\"cword\",\"up\"]]", "10.1"}, (Object)new Object[]{"[[\"dword\",\"up\"]]", "2"}, (Object)new Object[]{"[[\"word\",\"up\"]]", "1"}, (Object)new Object[]{"[[null,\"up\"]]", "def"}));
    }

    @Test
    public void testSomeArrayFunctionsWithScanQuery() {
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{"", "a", "[\"a\",\"b\"]", 7L, null, 1.0, null, "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.9,2.2,4.3]", "[\"a\",\"b\",\"foo\"]", "[\"foo\",\"a\"]", "[1,2,7]", "[null,1,2]", "[1.2,2.2,1.0]", "[null,1.1,2.2]", "[\"a\",\"a\",\"b\"]", "[7,null]", "[1.0,null]", 7L, 1.0, 7L, 1.0});
        RowSignature resultSignature = RowSignature.builder().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("dim3", ColumnType.STRING).add("l1", ColumnType.LONG).add("l2", ColumnType.LONG).add("dbl1", ColumnType.DOUBLE).add("dbl2", ColumnType.DOUBLE).add("EXPR$7", ColumnType.STRING_ARRAY).add("EXPR$8", ColumnType.LONG_ARRAY).add("EXPR$9", ColumnType.DOUBLE_ARRAY).add("EXPR$10", ColumnType.STRING_ARRAY).add("EXPR$11", ColumnType.STRING_ARRAY).add("EXPR$12", ColumnType.LONG_ARRAY).add("EXPR$13", ColumnType.LONG_ARRAY).add("EXPR$14", ColumnType.DOUBLE_ARRAY).add("EXPR$15", ColumnType.DOUBLE_ARRAY).add("EXPR$16", ColumnType.STRING_ARRAY).add("EXPR$17", ColumnType.LONG_ARRAY).add("EXPR$18", ColumnType.DOUBLE_ARRAY).add("EXPR$19", ColumnType.LONG).add("EXPR$20", ColumnType.DOUBLE).add("EXPR$21", ColumnType.LONG).add("EXPR$22", ColumnType.DOUBLE).build();
        this.testQuery("SELECT dim1, dim2, dim3, l1, l2, dbl1, dbl2, ARRAY['a', 'b', 'c'], ARRAY[1,2,3], ARRAY[1.9, 2.2, 4.3], ARRAY_APPEND(dim3, 'foo'), ARRAY_PREPEND('foo', ARRAY[dim2]), ARRAY_APPEND(ARRAY[1,2], l1), ARRAY_PREPEND(l2, ARRAY[1,2]), ARRAY_APPEND(ARRAY[1.2,2.2], dbl1), ARRAY_PREPEND(dbl2, ARRAY[1.1,2.2]), ARRAY_CONCAT(dim2,dim3), ARRAY_CONCAT(ARRAY[l1],ARRAY[l2]), ARRAY_CONCAT(ARRAY[dbl1],ARRAY[dbl2]), ARRAY_OFFSET(ARRAY[l1],0), ARRAY_OFFSET(ARRAY[dbl1],0), ARRAY_ORDINAL(ARRAY[l1],1), ARRAY_ORDINAL(ARRAY[dbl1],1) FROM druid.numfoo LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array('a','b','c')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array(1,2,3)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v10", "array_concat(array(\"l1\"),array(\"l2\"))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v11", "array_concat(array(\"dbl1\"),array(\"dbl2\"))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v12", "array_offset(array(\"l1\"),0)", ColumnType.LONG), CalciteArraysQueryTest.expressionVirtualColumn("v13", "array_offset(array(\"dbl1\"),0)", ColumnType.DOUBLE), CalciteArraysQueryTest.expressionVirtualColumn("v14", "array_ordinal(array(\"l1\"),1)", ColumnType.LONG), CalciteArraysQueryTest.expressionVirtualColumn("v15", "array_ordinal(array(\"dbl1\"),1)", ColumnType.DOUBLE), CalciteArraysQueryTest.expressionVirtualColumn("v2", "array(1.9,2.2,4.3)", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v3", "array_append(\"dim3\",'foo')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v4", "array_prepend('foo',array(\"dim2\"))", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v5", "array_append(array(1,2),\"l1\")", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v6", "array_prepend(\"l2\",array(1,2))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v7", "array_append(array(1.2,2.2),\"dbl1\")", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v8", "array_prepend(\"dbl2\",array(1.1,2.2))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v9", "array_concat(\"dim2\",\"dim3\")", ColumnType.STRING_ARRAY)}).columns(new String[]{"dim1", "dim2", "dim3", "l1", "l2", "dbl1", "dbl2", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15"}).columnTypes(resultSignature.getColumnTypes()).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expectedResults, resultSignature);
    }

    @Test
    public void testSomeArrayFunctionsWithScanQueryArrayColumns() {
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{null, "[]", null, null, null, "[1]", "[2]", null, null, null, "[1,2,3]", null, null, null, null, null, null, null}, (Object)new Object[]{"[\"a\",\"b\"]", "[2,3]", "[null]", "[\"a\",\"b\",\"foo\"]", "[\"foo\",\"a\",\"b\"]", "[2,3,1]", "[2,2,3]", "[null,1.1]", "[2.2,null]", null, null, null, "a", 2L, null, "a", 2L, null}, (Object)new Object[]{"[\"b\",\"b\"]", "[1]", null, "[\"b\",\"b\",\"foo\"]", "[\"foo\",\"b\",\"b\"]", "[1,1]", "[2,1]", null, null, "[\"d\",\"e\",\"b\",\"b\"]", "[1,4,1]", null, "b", 1L, null, "b", 1L, null}, (Object)new Object[]{null, "[null,2,9]", "[999.0,5.5,null]", null, null, "[null,2,9,1]", "[2,null,2,9]", "[999.0,5.5,null,1.1]", "[2.2,999.0,5.5,null]", null, null, null, null, null, 999.0, null, null, 999.0}, (Object)new Object[]{"[\"a\",\"b\"]", "[1,null,3]", "[1.1,2.2,null]", "[\"a\",\"b\",\"foo\"]", "[\"foo\",\"a\",\"b\"]", "[1,null,3,1]", "[2,1,null,3]", "[1.1,2.2,null,1.1]", "[2.2,1.1,2.2,null]", "[\"a\",\"b\",\"a\",\"b\"]", "[1,2,3,1,null,3]", "[1.1,2.2,3.3,1.1,2.2,null]", "a", 1L, 1.1, "a", 1L, 1.1}, (Object)new Object[]{"[\"d\",null,\"b\"]", "[1,2,3]", "[null,2.2,null]", "[\"d\",null,\"b\",\"foo\"]", "[\"foo\",\"d\",null,\"b\"]", "[1,2,3,1]", "[2,1,2,3]", "[null,2.2,null,1.1]", "[2.2,null,2.2,null]", "[\"b\",\"c\",\"d\",null,\"b\"]", "[1,2,3,4,1,2,3]", "[1.1,3.3,null,2.2,null]", "d", 1L, null, "d", 1L, null}, (Object)new Object[]{"[null,\"b\"]", null, "[999.0,null,5.5]", "[null,\"b\",\"foo\"]", "[\"foo\",null,\"b\"]", null, null, "[999.0,null,5.5,1.1]", "[2.2,999.0,null,5.5]", "[\"a\",\"b\",\"c\",null,\"b\"]", null, "[3.3,4.4,5.5,999.0,null,5.5]", null, null, 999.0, null, null, 999.0}, (Object)new Object[]{null, null, "[]", null, null, null, null, "[1.1]", "[2.2]", null, null, "[1.1,2.2,3.3]", null, null, null, null, null, null}, (Object)new Object[]{"[\"a\",\"b\"]", "[2,3]", "[null,1.1]", "[\"a\",\"b\",\"foo\"]", "[\"foo\",\"a\",\"b\"]", "[2,3,1]", "[2,2,3]", "[null,1.1,1.1]", "[2.2,null,1.1]", null, null, null, "a", 2L, null, "a", 2L, null}, (Object)new Object[]{"[\"b\",\"b\"]", "[null]", null, "[\"b\",\"b\",\"foo\"]", "[\"foo\",\"b\",\"b\"]", "[null,1]", "[2,null]", null, null, "[\"d\",\"e\",\"b\",\"b\"]", "[1,4,null]", null, "b", null, null, "b", null, null}, (Object)new Object[]{"[null]", "[null,2,9]", "[999.0,5.5,null]", "[null,\"foo\"]", "[\"foo\",null]", "[null,2,9,1]", "[2,null,2,9]", "[999.0,5.5,null,1.1]", "[2.2,999.0,5.5,null]", "[\"a\",\"b\",null]", null, null, null, null, 999.0, null, null, 999.0}, (Object)new Object[]{"[]", "[1,null,3]", "[1.1,2.2,null]", "[\"foo\"]", "[\"foo\"]", "[1,null,3,1]", "[2,1,null,3]", "[1.1,2.2,null,1.1]", "[2.2,1.1,2.2,null]", "[\"a\",\"b\"]", "[1,2,3,1,null,3]", "[1.1,2.2,3.3,1.1,2.2,null]", null, 1L, 1.1, null, 1L, 1.1}, (Object[])new Object[][]{{"[\"d\",null,\"b\"]", "[1,2,3]", "[null,2.2,null]", "[\"d\",null,\"b\",\"foo\"]", "[\"foo\",\"d\",null,\"b\"]", "[1,2,3,1]", "[2,1,2,3]", "[null,2.2,null,1.1]", "[2.2,null,2.2,null]", "[\"b\",\"c\",\"d\",null,\"b\"]", "[1,2,3,4,1,2,3]", "[1.1,3.3,null,2.2,null]", "d", 1L, null, "d", 1L, null}, {"[null,\"b\"]", null, "[999.0,null,5.5]", "[null,\"b\",\"foo\"]", "[\"foo\",null,\"b\"]", null, null, "[999.0,null,5.5,1.1]", "[2.2,999.0,null,5.5]", "[\"a\",\"b\",\"c\",null,\"b\"]", null, "[3.3,4.4,5.5,999.0,null,5.5]", null, null, 999.0, null, null, 999.0}});
        RowSignature resultSignature = RowSignature.builder().add("arrayStringNulls", ColumnType.STRING_ARRAY).add("arrayLongNulls", ColumnType.LONG_ARRAY).add("arrayDoubleNulls", ColumnType.DOUBLE_ARRAY).add("EXPR$3", ColumnType.STRING_ARRAY).add("EXPR$4", ColumnType.STRING_ARRAY).add("EXPR$5", ColumnType.LONG_ARRAY).add("EXPR$6", ColumnType.LONG_ARRAY).add("EXPR$7", ColumnType.DOUBLE_ARRAY).add("EXPR$8", ColumnType.DOUBLE_ARRAY).add("EXPR$9", ColumnType.STRING_ARRAY).add("EXPR$10", ColumnType.LONG_ARRAY).add("EXPR$11", ColumnType.DOUBLE_ARRAY).add("EXPR$12", ColumnType.STRING).add("EXPR$13", ColumnType.LONG).add("EXPR$14", ColumnType.DOUBLE).add("EXPR$15", ColumnType.STRING).add("EXPR$16", ColumnType.LONG).add("EXPR$17", ColumnType.DOUBLE).build();
        this.testQuery("SELECT arrayStringNulls, arrayLongNulls, arrayDoubleNulls, ARRAY_APPEND(arrayStringNulls, 'foo'), ARRAY_PREPEND('foo', arrayStringNulls), ARRAY_APPEND(arrayLongNulls, 1), ARRAY_PREPEND(2, arrayLongNulls), ARRAY_APPEND(arrayDoubleNulls, 1.1), ARRAY_PREPEND(2.2, arrayDoubleNulls), ARRAY_CONCAT(arrayString,arrayStringNulls), ARRAY_CONCAT(arrayLong,arrayLongNulls), ARRAY_CONCAT(arrayDouble,arrayDoubleNulls), ARRAY_OFFSET(arrayStringNulls,0), ARRAY_OFFSET(arrayLongNulls,0), ARRAY_OFFSET(arrayDoubleNulls,0), ARRAY_ORDINAL(arrayStringNulls,1), ARRAY_ORDINAL(arrayLongNulls,1), ARRAY_ORDINAL(arrayDoubleNulls,1) FROM druid.arrays", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_append(\"arrayStringNulls\",'foo')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array_prepend('foo',\"arrayStringNulls\")", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v10", "array_offset(\"arrayLongNulls\",0)", ColumnType.LONG), CalciteArraysQueryTest.expressionVirtualColumn("v11", "array_offset(\"arrayDoubleNulls\",0)", ColumnType.DOUBLE), CalciteArraysQueryTest.expressionVirtualColumn("v12", "array_ordinal(\"arrayStringNulls\",1)", ColumnType.STRING), CalciteArraysQueryTest.expressionVirtualColumn("v13", "array_ordinal(\"arrayLongNulls\",1)", ColumnType.LONG), CalciteArraysQueryTest.expressionVirtualColumn("v14", "array_ordinal(\"arrayDoubleNulls\",1)", ColumnType.DOUBLE), CalciteArraysQueryTest.expressionVirtualColumn("v2", "array_append(\"arrayLongNulls\",1)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v3", "array_prepend(2,\"arrayLongNulls\")", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v4", "array_append(\"arrayDoubleNulls\",1.1)", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v5", "array_prepend(2.2,\"arrayDoubleNulls\")", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v6", "array_concat(\"arrayString\",\"arrayStringNulls\")", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v7", "array_concat(\"arrayLong\",\"arrayLongNulls\")", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v8", "array_concat(\"arrayDouble\",\"arrayDoubleNulls\")", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v9", "array_offset(\"arrayStringNulls\",0)", ColumnType.STRING)}).columns(new String[]{"arrayStringNulls", "arrayLongNulls", "arrayDoubleNulls", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14"}).columnTypes(resultSignature.getColumnTypes()).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expectedResults, resultSignature);
    }

    @Test
    public void testSomeArrayFunctionsWithScanQueryNoStringify() {
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{"", "a", "[\"a\",\"b\"]", Arrays.asList("a", "b", "c"), Arrays.asList(1L, 2L, 3L), Arrays.asList(1.9, 2.2, 4.3), Arrays.asList("a", "b", "foo"), Arrays.asList("foo", "a"), Arrays.asList(1L, 2L, 7L), Arrays.asList(null, 1L, 2L), Arrays.asList(1.2, 2.2, 1.0), Arrays.asList(null, 1.1, 2.2), Arrays.asList("a", "a", "b"), Arrays.asList(7L, null), Arrays.asList(1.0, null)});
        this.testQuery("SELECT dim1, dim2, dim3, ARRAY['a', 'b', 'c'], ARRAY[1,2,3], ARRAY[1.9, 2.2, 4.3], ARRAY_APPEND(dim3, 'foo'), ARRAY_PREPEND('foo', ARRAY[dim2]), ARRAY_APPEND(ARRAY[1,2], l1), ARRAY_PREPEND(l2, ARRAY[1,2]), ARRAY_APPEND(ARRAY[1.2,2.2], dbl1), ARRAY_PREPEND(dbl2, ARRAY[1.1,2.2]), ARRAY_CONCAT(dim2,dim3), ARRAY_CONCAT(ARRAY[l1],ARRAY[l2]), ARRAY_CONCAT(ARRAY[dbl1],ARRAY[dbl2]) FROM druid.numfoo LIMIT 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array('a','b','c')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array(1,2,3)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v10", "array_concat(array(\"l1\"),array(\"l2\"))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v11", "array_concat(array(\"dbl1\"),array(\"dbl2\"))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v2", "array(1.9,2.2,4.3)", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v3", "array_append(\"dim3\",'foo')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v4", "array_prepend('foo',array(\"dim2\"))", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v5", "array_append(array(1,2),\"l1\")", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v6", "array_prepend(\"l2\",array(1,2))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v7", "array_append(array(1.2,2.2),\"dbl1\")", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v8", "array_prepend(\"dbl2\",array(1.1,2.2))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v9", "array_concat(\"dim2\",\"dim3\")", ColumnType.STRING_ARRAY)}).columns(new String[]{"dim1", "dim2", "dim3", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.ofArray((ColumnType)ColumnType.STRING), ColumnType.ofArray((ColumnType)ColumnType.LONG), ColumnType.ofArray((ColumnType)ColumnType.DOUBLE), ColumnType.ofArray((ColumnType)ColumnType.STRING), ColumnType.ofArray((ColumnType)ColumnType.STRING), ColumnType.ofArray((ColumnType)ColumnType.LONG), ColumnType.ofArray((ColumnType)ColumnType.LONG), ColumnType.ofArray((ColumnType)ColumnType.DOUBLE), ColumnType.ofArray((ColumnType)ColumnType.DOUBLE), ColumnType.ofArray((ColumnType)ColumnType.STRING), ColumnType.ofArray((ColumnType)ColumnType.LONG), ColumnType.ofArray((ColumnType)ColumnType.DOUBLE)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)expectedResults);
    }

    @Test
    public void testArrayOverlapFilter() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_OVERLAP(dim3, ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteArraysQueryTest.in("dim3", (Collection<String>)ImmutableList.of((Object)"a", (Object)"b"))).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}));
    }

    @Test
    public void testArrayOverlapFilterStringArrayColumn() {
        this.testQuery("SELECT arrayStringNulls FROM druid.arrays WHERE ARRAY_OVERLAP(arrayStringNulls, ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{new ArrayContainsElementFilter("arrayStringNulls", ColumnType.STRING, (Object)"a", null), new ArrayContainsElementFilter("arrayStringNulls", ColumnType.STRING, (Object)"b", null)})).columns(new String[]{"arrayStringNulls"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"b\"]"}, (Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"d\",null,\"b\"]"}, (Object)new Object[]{"[null,\"b\"]"}));
    }

    @Test
    public void testArrayOverlapFilterLongArrayColumn() {
        this.testQuery("SELECT arrayLongNulls FROM druid.arrays WHERE ARRAY_OVERLAP(arrayLongNulls, ARRAY[1, 2]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)1L, null), new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)2L, null)})).columns(new String[]{"arrayLongNulls"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[2,3]"}, (Object)new Object[]{"[1]"}, (Object)new Object[]{"[null,2,9]"}, (Object)new Object[]{"[1,null,3]"}, (Object)new Object[]{"[1,2,3]"}));
    }

    @Test
    public void testArrayOverlapFilterDoubleArrayColumn() {
        this.testQuery("SELECT arrayDoubleNulls FROM druid.arrays WHERE ARRAY_OVERLAP(arrayDoubleNulls, ARRAY[1.1, 2.2]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{new ArrayContainsElementFilter("arrayDoubleNulls", ColumnType.DOUBLE, (Object)1.1, null), new ArrayContainsElementFilter("arrayDoubleNulls", ColumnType.DOUBLE, (Object)2.2, null)})).columns(new String[]{"arrayDoubleNulls"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1.1,2.2,null]"}, (Object)new Object[]{"[null,2.2,null]"}, (Object)new Object[]{"[null,1.1]"}, (Object)new Object[]{"[1.1,2.2,null]"}, (Object)new Object[]{"[null,2.2,null]"}));
    }

    @Test
    public void testArrayOverlapFilterWithExtractionFn() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_OVERLAP(SUBSTRING(dim3, 1, 1), ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new InDimFilter("dim3", (Collection)ImmutableList.of((Object)"a", (Object)"b"), (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}));
    }

    @Test
    public void testArrayOverlapFilterNonLiteral() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_OVERLAP(dim3, ARRAY[dim2]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_overlap(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayOverlapFilterArrayStringColumns() {
        this.testQuery("SELECT arrayStringNulls, arrayString FROM druid.arrays WHERE ARRAY_OVERLAP(arrayStringNulls, arrayString) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_overlap(\"arrayStringNulls\",\"arrayString\")")).columns(new String[]{"arrayStringNulls", "arrayString"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "[\"a\",\"b\"]"}, (Object)new Object[]{"[\"d\",null,\"b\"]", "[\"b\",\"c\"]"}, (Object)new Object[]{"[null,\"b\"]", "[\"a\",\"b\",\"c\"]"}, (Object)new Object[]{"[\"d\",null,\"b\"]", "[\"b\",\"c\"]"}, (Object)new Object[]{"[null,\"b\"]", "[\"a\",\"b\",\"c\"]"}));
    }

    @Test
    public void testArrayOverlapFilterArrayLongColumns() {
        this.testQuery("SELECT arrayLongNulls, arrayLong FROM druid.arrays WHERE ARRAY_OVERLAP(arrayLongNulls, arrayLong) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_overlap(\"arrayLongNulls\",\"arrayLong\")")).columns(new String[]{"arrayLongNulls", "arrayLong"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY, ColumnType.LONG_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1]", "[1,4]"}, (Object)new Object[]{"[1,null,3]", "[1,2,3]"}, (Object)new Object[]{"[1,2,3]", "[1,2,3,4]"}, (Object)new Object[]{"[1,null,3]", "[1,2,3]"}, (Object)new Object[]{"[1,2,3]", "[1,2,3,4]"}));
    }

    @Test
    public void testArrayOverlapFilterArrayDoubleColumns() {
        this.testQuery("SELECT arrayDoubleNulls, arrayDouble FROM druid.arrays WHERE ARRAY_OVERLAP(arrayDoubleNulls, arrayDouble) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_overlap(\"arrayDoubleNulls\",\"arrayDouble\")")).columns(new String[]{"arrayDoubleNulls", "arrayDouble"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE_ARRAY, ColumnType.DOUBLE_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1.1,2.2,null]", "[1.1,2.2,3.3]"}, (Object)new Object[]{"[999.0,null,5.5]", "[3.3,4.4,5.5]"}, (Object)new Object[]{"[1.1,2.2,null]", "[1.1,2.2,3.3]"}, (Object)new Object[]{"[999.0,null,5.5]", "[3.3,4.4,5.5]"}));
    }

    @Test
    public void testArrayOverlapFilterWithDynamicParameter() {
        Druids.ScanQueryBuilder builder = CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_overlap(array(1.0,1.7,null),array(\"dbl1\"))")).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT);
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.ARRAY, Arrays.asList(1.0, 1.7, null))), "SELECT dim3 FROM druid.numfoo WHERE ARRAY_OVERLAP(?, ARRAY[dbl1]) LIMIT 5", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)builder.build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}, (Object)new Object[]{""}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testArrayContainsFilter() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(dim3, ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("dim3", "a", ColumnType.STRING), CalciteArraysQueryTest.equality("dim3", "b", ColumnType.STRING))).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsFilterArrayStringColumn() {
        this.testQuery("SELECT arrayStringNulls FROM druid.arrays WHERE ARRAY_CONTAINS(arrayStringNulls, ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.and(new DimFilter[]{new ArrayContainsElementFilter("arrayStringNulls", ColumnType.STRING, (Object)"a", null), new ArrayContainsElementFilter("arrayStringNulls", ColumnType.STRING, (Object)"b", null)})).columns(new String[]{"arrayStringNulls"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsFilterArrayLongColumn() {
        this.testQuery("SELECT arrayLongNulls FROM druid.arrays WHERE ARRAY_CONTAINS(arrayLongNulls, ARRAY[1, null]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.and(new DimFilter[]{new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)1L, null), new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, null, null)})).columns(new String[]{"arrayLongNulls"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1,null,3]"}, (Object)new Object[]{"[1,null,3]"}));
    }

    @Test
    public void testArrayContainsFilterArrayDoubleColumn() {
        this.testQuery("SELECT arrayDoubleNulls FROM druid.arrays WHERE ARRAY_CONTAINS(arrayDoubleNulls, ARRAY[1.1, null]) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.and(new DimFilter[]{new ArrayContainsElementFilter("arrayDoubleNulls", ColumnType.DOUBLE, (Object)1.1, null), new ArrayContainsElementFilter("arrayDoubleNulls", ColumnType.DOUBLE, null, null)})).columns(new String[]{"arrayDoubleNulls"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1.1,2.2,null]"}, (Object)new Object[]{"[null,1.1]"}, (Object)new Object[]{"[1.1,2.2,null]"}));
    }

    @Test
    public void testArrayContainsFilterWithExtractionFn() {
        Druids.ScanQueryBuilder builder = CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "substring(\"dim3\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("v0", "a", ColumnType.STRING), CalciteArraysQueryTest.equality("v0", "b", ColumnType.STRING)));
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(SUBSTRING(dim3, 1, 1), ARRAY['a','b']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)builder.build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsArrayOfOneElement() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(dim3, ARRAY['a']) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteArraysQueryTest.equality("dim3", "a", ColumnType.STRING)).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsArrayOfNonLiteral() {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(dim3, ARRAY[dim2]) LIMIT 5", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_contains(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsFilterArrayStringColumns() {
        this.testQuery("SELECT arrayStringNulls, arrayString FROM druid.arrays WHERE ARRAY_CONTAINS(arrayStringNulls, arrayString) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_contains(\"arrayStringNulls\",\"arrayString\")")).columns(new String[]{"arrayStringNulls", "arrayString"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsArrayStringColumns() {
        this.testQuery("SELECT ARRAY_CONTAINS(arrayStringNulls, ARRAY['a', 'b']), ARRAY_CONTAINS(arrayStringNulls, arrayString) FROM druid.arrays LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_contains(\"arrayStringNulls\",array('a','b'))", ColumnType.LONG), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array_contains(\"arrayStringNulls\",\"arrayString\")", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null}, (Object)new Object[]{true, false}, (Object)new Object[]{false, false}, (Object)new Object[]{null, null}, (Object)new Object[]{true, true}));
    }

    @Test
    public void testArrayContainsFilterArrayLongColumns() {
        this.testQuery("SELECT arrayLong, arrayLongNulls FROM druid.arrays WHERE ARRAY_CONTAINS(arrayLong, arrayLongNulls) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_contains(\"arrayLong\",\"arrayLongNulls\")")).columns(new String[]{"arrayLong", "arrayLongNulls"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY, ColumnType.LONG_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1,2,3]", "[]"}, (Object)new Object[]{"[1,4]", "[1]"}, (Object)new Object[]{"[1,2,3,4]", "[1,2,3]"}, (Object)new Object[]{"[1,2,3,4]", "[1,2,3]"}));
    }

    @Test
    public void testArrayContainsFilterArrayDoubleColumns() {
        this.testQuery("SELECT arrayDoubleNulls, arrayDouble FROM druid.arrays WHERE ARRAY_CONTAINS(arrayDoubleNulls, arrayDouble) LIMIT 5", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_contains(\"arrayDoubleNulls\",\"arrayDouble\")")).columns(new String[]{"arrayDoubleNulls", "arrayDouble"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE_ARRAY, ColumnType.DOUBLE_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testArrayContainsConstantNull() {
        this.testQuery("SELECT ARRAY_CONTAINS(null, ARRAY['a','b'])", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}));
    }

    @Test
    public void testArrayContainsFilterWithDynamicParameter() {
        Druids.ScanQueryBuilder builder = CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_contains(array(1,null),array((\"dbl1\" > 1)))")).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT);
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.ARRAY, Arrays.asList(true, null))), "SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(?, ARRAY[dbl1>1]) LIMIT 5", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)builder.build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"b\",\"c\"]"}, (Object)new Object[]{""}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testScalarInArrayFilter() {
        this.testQuery("SELECT dim2 FROM druid.numfoo\nWHERE\n  SCALAR_IN_ARRAY(dim2, ARRAY['a', 'd'])\n  OR SCALAR_IN_ARRAY(SUBSTRING(dim1, 1, 1), ARRAY[NULL, 'foo', 'bar'])\n  OR SCALAR_IN_ARRAY(cnt * 2, ARRAY[3])\n", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(VirtualColumns.create((List)ImmutableList.of((Object)CalciteArraysQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING), (Object)CalciteArraysQueryTest.expressionVirtualColumn("v1", "(\"cnt\" * 2)", ColumnType.LONG)))).filters((DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.in("dim2", Arrays.asList("a", "d")), CalciteArraysQueryTest.in("v0", Arrays.asList(null, "foo", "bar")), CalciteArraysQueryTest.in("v1", ColumnType.LONG, Collections.singletonList(3L)))).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"a"}));
    }

    @Test
    public void testNotScalarInArrayFilter() {
        this.testQuery("SELECT dim2 FROM druid.numfoo\nWHERE NOT SCALAR_IN_ARRAY(dim2, ARRAY['a', 'd'])\n", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.not(CalciteArraysQueryTest.in("dim2", Arrays.asList("a", "d")))).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"abc"}));
    }

    @Test
    public void testArrayScalarInFilter_MVD() {
        String expectedValueForEmptyMvd = this.queryFramework().engine().name().equals("msq-task") ? null : "not abd";
        this.testBuilder().sql("SELECT dim3, (CASE WHEN scalar_in_array(dim3, Array['a', 'b', 'd']) THEN 'abd' ELSE 'not abd' END) FROM druid.numfoo").expectedQueries((List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "case_searched(scalar_in_array(\"dim3\",array('a','b','d')),'abd','not abd')", ColumnType.STRING)}).columns(new String[]{"dim3", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "[\"abd\",\"abd\"]"}, (Object)new Object[]{"[\"b\",\"c\"]", "[\"abd\",\"not abd\"]"}, (Object)new Object[]{"d", "abd"}, (Object)new Object[]{"", "not abd"}, (Object)new Object[]{null, expectedValueForEmptyMvd}, (Object)new Object[]{null, "not abd"})).run();
    }

    @Test
    public void testArraySlice() {
        this.testQuery("SELECT ARRAY_SLICE(dim3, 1) FROM druid.numfoo", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_slice(\"dim3\",1)", ColumnType.STRING_ARRAY)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList("b")}, (Object)new Object[]{Collections.singletonList("c")}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testArraySliceArrayColumns() {
        this.testQuery("SELECT ARRAY_SLICE(arrayString, 1), ARRAY_SLICE(arrayLong, 2), ARRAY_SLICE(arrayDoubleNulls, 1) FROM druid.arrays", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_slice(\"arrayString\",1)", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array_slice(\"arrayLong\",2)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v2", "array_slice(\"arrayDoubleNulls\",1)", ColumnType.DOUBLE_ARRAY)}).columns(new String[]{"v0", "v1", "v2"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.LONG_ARRAY, ColumnType.DOUBLE_ARRAY}).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, Collections.singletonList(3L), null}, (Object)new Object[]{null, null, Collections.emptyList()}, (Object)new Object[]{ImmutableList.of((Object)"e"), Collections.emptyList(), null}, (Object)new Object[]{ImmutableList.of((Object)"b"), null, Arrays.asList(5.5, null)}, (Object)new Object[]{ImmutableList.of((Object)"b"), Collections.singletonList(3L), Arrays.asList(2.2, null)}, (Object)new Object[]{ImmutableList.of((Object)"c"), Arrays.asList(3L, 4L), Arrays.asList(2.2, null)}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c"), Collections.emptyList(), Arrays.asList(null, 5.5)}, (Object)new Object[]{null, Collections.singletonList(3L), null}, (Object)new Object[]{null, null, Collections.singletonList(1.1)}, (Object)new Object[]{ImmutableList.of((Object)"e"), Collections.emptyList(), null}, (Object)new Object[]{ImmutableList.of((Object)"b"), null, Arrays.asList(5.5, null)}, (Object)new Object[]{ImmutableList.of((Object)"b"), Collections.singletonList(3L), Arrays.asList(2.2, null)}, (Object[])new Object[][]{{ImmutableList.of((Object)"c"), Arrays.asList(3L, 4L), Arrays.asList(2.2, null)}, {ImmutableList.of((Object)"b", (Object)"c"), Collections.emptyList(), Arrays.asList(null, 5.5)}}));
    }

    @Test
    public void testArrayLength() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT dim1, ARRAY_LENGTH(dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1, 2 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 2, 1L}, (Object)new Object[]{"10.1", 2, 1L}, (Object)new Object[]{"1", 1, 1L}, (Object)new Object[]{"2", 1, 1L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"def", null, 1L}));
    }

    @Test
    public void testArrayLengthArrayColumn() {
        this.cannotVectorize();
        this.testQuery("SELECT arrayStringNulls, ARRAY_LENGTH(arrayStringNulls), SUM(cnt) FROM druid.arrays GROUP BY 1, 2 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("arrays").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_length(\"arrayStringNulls\")", ColumnType.LONG)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayStringNulls", "d0", ColumnType.STRING_ARRAY), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"d\",null,\"b\"]", 3, 2L}, (Object)new Object[]{"[null,\"b\"]", 2, 2L}, (Object)new Object[]{"[\"a\",\"b\"]", 2, 3L}, (Object)new Object[]{"[\"b\",\"b\"]", 2, 2L}, (Object)new Object[]{"[null]", 1, 1L}, (Object)new Object[]{"[]", 0, 1L}, (Object)new Object[]{null, null, 3L}));
    }

    @Test
    public void testArrayAppend() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)"", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"foo"), 1L});
        this.testQuery("SELECT ARRAY_APPEND(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_append(\"dim3\",'foo')", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayPrepend() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"d"), 1L});
        this.testQuery("SELECT ARRAY_PREPEND('foo', dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_prepend('foo',\"dim3\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayPrependAppend() {
        this.cannotVectorizeUnlessFallback();
        ImmutableList results = ImmutableList.of((Object)new Object[]{null, null, 2L}, (Object)new Object[]{"foo,", ",foo", 1L}, (Object)new Object[]{"foo,a,b", "a,b,foo", 1L}, (Object)new Object[]{"foo,b,c", "b,c,foo", 1L}, (Object)new Object[]{"foo,d", "d,foo", 1L});
        this.testQuery("SELECT ARRAY_TO_STRING(ARRAY_PREPEND('foo', dim3), ','), ARRAY_TO_STRING(ARRAY_APPEND(dim3, 'foo'), ','), SUM(cnt) FROM druid.numfoo GROUP BY 1,2 ORDER BY 3 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_to_string(array_prepend('foo',\"dim3\"),',')", ColumnType.STRING), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array_to_string(array_append(\"dim3\",'foo'),',')", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("v1", "d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayConcat() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)"", (Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"d"), 1L});
        this.testQuery("SELECT ARRAY_CONCAT(dim3, dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_concat(\"dim3\",\"dim3\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayOffset() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT ARRAY_OFFSET(dim3, 1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_offset(\"dim3\",1)", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testArrayGroupAsLongArray() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[l1], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\")", ColumnType.LONG_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 3L}, (Object)new Object[]{ImmutableList.of((Object)0L), 1L}, (Object)new Object[]{ImmutableList.of((Object)7L), 1L}, (Object)new Object[]{ImmutableList.of((Object)325323L), 1L}));
    }

    @Test
    public void testArrayGroupAsLongArrayColumn() {
        this.cannotVectorize();
        this.testQuery("SELECT arrayLongNulls, SUM(cnt) FROM druid.arrays GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("arrays").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayLongNulls", "d0", ColumnType.LONG_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Arrays.asList(null, 2L, 9L), 2L}, (Object)new Object[]{Arrays.asList(1L, null, 3L), 2L}, (Object)new Object[]{Arrays.asList(1L, 2L, 3L), 2L}, (Object)new Object[]{Arrays.asList(2L, 3L), 2L}, (Object)new Object[]{Collections.emptyList(), 1L}, (Object)new Object[]{Collections.singletonList(null), 1L}, (Object)new Object[]{Collections.singletonList(1L), 1L}));
    }

    @Test
    public void testArrayGroupAsDoubleArray() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[dbl1], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"dbl1\")", ColumnType.DOUBLE_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.DOUBLE_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 3L}, (Object)new Object[]{ImmutableList.of((Object)0.0), 1L}, (Object)new Object[]{ImmutableList.of((Object)1.0), 1L}, (Object)new Object[]{ImmutableList.of((Object)1.7), 1L}));
    }

    @Test
    public void testArrayGroupAsDoubleArrayColumn() {
        this.cannotVectorize();
        this.testQuery("SELECT arrayDoubleNulls, SUM(cnt) FROM druid.arrays GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("arrays").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayDoubleNulls", "d0", ColumnType.DOUBLE_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Arrays.asList(null, 2.2, null), 2L}, (Object)new Object[]{Arrays.asList(1.1, 2.2, null), 2L}, (Object)new Object[]{Arrays.asList(999.0, null, 5.5), 2L}, (Object)new Object[]{Arrays.asList(999.0, 5.5, null), 2L}, (Object)new Object[]{Collections.emptyList(), 1L}, (Object)new Object[]{Collections.singletonList(null), 1L}, (Object)new Object[]{Arrays.asList(null, 1.1), 1L}));
    }

    @Test
    public void testArrayGroupAsFloatArray() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[f1], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"f1\")", ColumnType.ofArray((ColumnType)ColumnType.FLOAT))}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.ofArray((ColumnType)ColumnType.FLOAT))})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 3L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(0.0f)), 1L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(0.1f)), 1L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(1.0f)), 1L}));
    }

    @Test
    public void testArrayGroupAsArrayWithFunction() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[ARRAY_ORDINAL(dim3, 2)], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(array_ordinal(\"dim3\",2))", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 4L}, (Object)new Object[]{ImmutableList.of((Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"c"), 1L}));
    }

    @Test
    public void testArrayOrdinal() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT ARRAY_ORDINAL(dim3, 2), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_ordinal(\"dim3\",2)", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testArrayOffsetOf() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT ARRAY_OFFSET_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_offset_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{0, 1L}, (Object)new Object[]{1, 1L}));
    }

    @Test
    public void testArrayOrdinalOf() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT ARRAY_ORDINAL_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_ordinal_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{1, 1L}, (Object)new Object[]{2, 1L}));
    }

    @Test
    public void testArrayToString() {
        this.cannotVectorizeUnlessFallback();
        ImmutableList results = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a,b", 1L}, (Object)new Object[]{"b,c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT ARRAY_TO_STRING(dim3, ','), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_to_string(\"dim3\",',')", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayToStringToMultiValueString() {
        this.cannotVectorize();
        ImmutableList results = ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"d"), 1L});
        this.testQuery("SELECT STRING_TO_ARRAY(CONCAT(ARRAY_TO_STRING(dim3, ','), ',d'), ','), SUM(cnt) FROM druid.numfoo WHERE ARRAY_LENGTH(dim3) > 0 GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG), CalciteArraysQueryTest.expressionVirtualColumn("v1", "string_to_array(concat(array_to_string(\"dim3\",','),',d'),',')", ColumnType.STRING_ARRAY)}).setDimFilter(CalciteArraysQueryTest.range("v0", ColumnType.LONG, 0L, null, true, false)).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayAgg() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(dim1), ARRAY_AGG(DISTINCT dim1), ARRAY_AGG(DISTINCT dim1) FILTER(WHERE dim1 = 'shazbot') FROM foo WHERE dim1 is not null", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteArraysQueryTest.notNull("dim1")).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"dim1\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteArraysQueryTest.equality("dim1", "shazbot", ColumnType.STRING))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"\",\"10.1\",\"2\",\"1\",\"def\",\"abc\"]", "[\"\",\"1\",\"10.1\",\"2\",\"abc\",\"def\"]", null}));
    }

    @Test
    public void testArrayAggMultiValue() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(dim3), ARRAY_AGG(DISTINCT dim3) FROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"dim3\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\",\"b\",\"c\",\"d\",\"\",null,null]", "[null,\"\",\"a\",\"b\",\"c\",\"d\"]"}));
    }

    @Test
    public void testArrayAggNumeric() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(l1), ARRAY_AGG(DISTINCT l1), ARRAY_AGG(dbl1), ARRAY_AGG(DISTINCT dbl1), ARRAY_AGG(f1), ARRAY_AGG(DISTINCT f1) FROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"dbl1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"dbl1\")", "array_concat(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a3", (Set)ImmutableSet.of((Object)"dbl1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dbl1\")", "array_set_add_all(\"__acc\", \"a3\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a4", (Set)ImmutableSet.of((Object)"f1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"f1\")", "array_concat(\"__acc\", \"a4\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a5", (Set)ImmutableSet.of((Object)"f1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"f1\")", "array_set_add_all(\"__acc\", \"a5\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[7,325323,0,null,null,null]", "[null,0,7,325323]", "[1.0,1.7,0.0,null,null,null]", "[null,0.0,1.0,1.7]", "[1.0,0.10000000149011612,0.0,null,null,null]", "[null,0.0,0.10000000149011612,1.0]"}));
    }

    @Test
    public void testArrayAggQuantile() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_QUANTILE(ARRAY_AGG(l1), 0.9) FROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).postAggregators(new PostAggregator[]{CalciteArraysQueryTest.expressionPostAgg("p0", "array_quantile(\"a0\",0.9)", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{260259.80000000002}));
    }

    @Test
    public void testArrayAggArrays() {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(ARRAY[l1, l2]), ARRAY_AGG(DISTINCT ARRAY[l1, l2]) FROM numfoo", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\",\"l2\")", ColumnType.LONG_ARRAY)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (String sql, QueryTestRunner.QueryResults queryResults) -> {
            ImmutableList expected = ImmutableList.of((Object)new Object[]{Arrays.asList(Arrays.asList(7L, null), Arrays.asList(325323L, 325323L), Arrays.asList(0L, 0L), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null)), Arrays.asList(Arrays.asList(null, null), Arrays.asList(0L, 0L), Arrays.asList(7L, null), Arrays.asList(325323L, 325323L))});
            CalciteArraysQueryTest.assertResultsDeepEquals(sql, (List<Object[]>)expected, queryResults.results);
        });
    }

    @Test
    public void testArrayAggArraysWithMaxSizeBytes() {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(ARRAY[l1, l2], 10000), ARRAY_AGG(DISTINCT ARRAY[l1, l2], CAST(10000 AS INTEGER)) FROM numfoo", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\",\"l2\")", ColumnType.LONG_ARRAY)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, new HumanReadableBytes(10000L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, new HumanReadableBytes(10000L), TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (String sql, QueryTestRunner.QueryResults queryResults) -> {
            ImmutableList expected = ImmutableList.of((Object)new Object[]{Arrays.asList(Arrays.asList(7L, null), Arrays.asList(325323L, 325323L), Arrays.asList(0L, 0L), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null)), Arrays.asList(Arrays.asList(null, null), Arrays.asList(0L, 0L), Arrays.asList(7L, null), Arrays.asList(325323L, 325323L))});
            CalciteArraysQueryTest.assertResultsDeepEquals(sql, (List<Object[]>)expected, queryResults.results);
        });
    }

    @Test
    public void testArrayConcatAggArrays() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_CONCAT_AGG(ARRAY[l1, l2]), ARRAY_CONCAT_AGG(DISTINCT ARRAY[l1, l2]) FROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\",\"l2\")", ColumnType.LONG_ARRAY)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_concat(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add_all(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[7,null,325323,325323,0,0,null,null,null,null,null,null]", "[null,0,7,325323]"}));
    }

    @Test
    public void testArrayConcatAggArraysWithMaxSizeBytes() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_CONCAT_AGG(ARRAY[l1, l2], 10000), ARRAY_CONCAT_AGG(DISTINCT ARRAY[l1, l2], CAST(10000 AS INTEGER)) FROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\",\"l2\")", ColumnType.LONG_ARRAY)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_concat(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, new HumanReadableBytes(10000L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add_all(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, new HumanReadableBytes(10000L), TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[7,null,325323,325323,0,0,null,null,null,null,null,null]", "[null,0,7,325323]"}));
    }

    @Test
    public void testArrayAggArrayColumns() {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(arrayLongNulls), ARRAY_AGG(DISTINCT arrayDouble), ARRAY_AGG(DISTINCT arrayStringNulls) FILTER(WHERE arrayLong = ARRAY[2,3]) FROM arrays WHERE arrayDoubleNulls is not null", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteArraysQueryTest.notNull("arrayDoubleNulls")).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"arrayLongNulls"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"arrayLongNulls\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"arrayDouble"), "__acc", "ARRAY<ARRAY<DOUBLE>>[]", "ARRAY<ARRAY<DOUBLE>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"arrayDouble\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"arrayStringNulls"), "__acc", "ARRAY<ARRAY<STRING>>[]", "ARRAY<ARRAY<STRING>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"arrayStringNulls\")", "array_set_add_all(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteArraysQueryTest.equality("arrayLong", ImmutableList.of((Object)2, (Object)3), ColumnType.LONG_ARRAY))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[[2,3],[null,2,9],[1,null,3],[1,2,3],null,null,[2,3],[null,2,9],[1,null,3],[1,2,3],null]", "[null,[1.1,2.2,3.3],[1.1,3.3],[3.3,4.4,5.5]]", "[[null,\"b\"]]"}));
    }

    @Test
    public void testArrayConcatAggArrayColumns() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_CONCAT_AGG(arrayLongNulls), ARRAY_CONCAT_AGG(DISTINCT arrayDouble), ARRAY_CONCAT_AGG(DISTINCT arrayStringNulls) FILTER(WHERE arrayLong = ARRAY[2,3]) FROM arrays WHERE arrayDoubleNulls is not null", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteArraysQueryTest.notNull("arrayDoubleNulls")).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"arrayLongNulls"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_concat(\"__acc\", \"arrayLongNulls\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"arrayDouble"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add_all(\"__acc\", \"arrayDouble\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"arrayStringNulls"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add_all(\"__acc\", \"arrayStringNulls\")", "array_set_add_all(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), CalciteArraysQueryTest.equality("arrayLong", ImmutableList.of((Object)2, (Object)3), ColumnType.LONG_ARRAY))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[2,3,null,2,9,1,null,3,1,2,3,2,3,null,2,9,1,null,3,1,2,3]", "[1.1,2.2,3.3,4.4,5.5]", "[null,\"b\"]"}));
    }

    @Test
    public void testArrayAggToString() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_TO_STRING(ARRAY_AGG(DISTINCT dim1), ',') FROM foo WHERE dim1 is not null", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteArraysQueryTest.notNull("dim1")).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).postAggregators(new PostAggregator[]{CalciteArraysQueryTest.expressionPostAgg("p0", "array_to_string(\"a0\",',')", ColumnType.STRING)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{",1,10.1,2,abc,def"}));
    }

    @Test
    public void testArrayAggExpression() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_TO_STRING(ARRAY_AGG(DISTINCT CONCAT(dim1, dim2)), ',') FROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim2\")", ColumnType.STRING)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).postAggregators(new PostAggregator[]{CalciteArraysQueryTest.expressionPostAgg("p0", "array_to_string(\"a0\",',')", ColumnType.STRING)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"null,1a,2,a,defabc"}));
    }

    @Test
    public void testArrayAggMaxBytes() {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_AGG(l1, 128), ARRAY_AGG(DISTINCT l1, CAST(128 AS INTEGER)) FROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, null, new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[7,325323,0,null,null,null]", "[null,0,7,325323]"}));
    }

    @Test
    public void testArrayAggAsArrayFromJoin() {
        this.cannotVectorize();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{"a", "[\"\",\"10.1\",\"2\"]", ",10.1,2"}, (Object)new Object[]{"a", "[\"\",\"10.1\",\"2\"]", ",10.1,2"}, (Object)new Object[]{"a", "[\"\",\"10.1\",\"2\"]", ",10.1,2"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"});
        this.testQuery("SELECT numfoo.dim4, j.arr, ARRAY_TO_STRING(j.arr, ',') FROM numfoo INNER JOIN (SELECT dim4, ARRAY_AGG(DISTINCT dim1) as arr FROM numfoo WHERE dim1 is not null GROUP BY 1) as j ON numfoo.dim4 = j.dim4", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteArraysQueryTest.notNull("dim1")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim4", "d0")}).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"dim4\" == \"j0.d0\")", JoinType.INNER, null)).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_to_string(\"j0.a0\",',')", ColumnType.STRING)}).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim4", "j0.a0", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING_ARRAY, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)expectedResults);
    }

    @Test
    public void testArrayAggGroupByArrayAggFromSubquery() {
        Map context = QueryContexts.override((Map)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (String)"useLexicographicTopN", (Object)true);
        this.testQuery("SELECT dim2, arr, COUNT(*) FROM (SELECT dim2, ARRAY_AGG(DISTINCT dim1) as arr FROM foo WHERE dim1 is not null GROUP BY 1 LIMIT 5) GROUP BY 1,2", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).filters(CalciteArraysQueryTest.notNull("dim1")).threshold(5).aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).context(context).postAggregators(new PostAggregator[]{CalciteArraysQueryTest.expressionPostAgg("s0", "1", ColumnType.LONG)}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, ImmutableList.of((Object)"10.1", (Object)"abc"), 1L}, (Object)new Object[]{"", ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{"a", ImmutableList.of((Object)"", (Object)"1"), 1L}, (Object)new Object[]{"abc", ImmutableList.of((Object)"def"), 1L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testArrayAggGroupByArrayAggOfLongsFromSubquery() {
        this.cannotVectorize();
        this.testQuery("select cntarray, count(*) from ( select dim1, dim2, ARRAY_AGG(cnt) as cntarray from ( select dim1, dim2, dim3, count(*) as cnt from foo group by 1, 2, 3 ) group by 1, 2 ) group by 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new TableDataSource("foo")).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1"), new DefaultDimensionSpec("dim3", "d2")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0"), new DefaultDimensionSpec("d1", "_d1")}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("_a0", (Set)ImmutableSet.of((Object)"a0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"a0\")", "array_concat(\"__acc\", \"_a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("_a0", "d0", ColumnType.LONG_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)1L), 4L}, (Object)new Object[]{ImmutableList.of((Object)1L, (Object)1L), 2L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testArrayAggGroupByArrayAggOfStringsFromSubquery() {
        this.cannotVectorize();
        this.testQuery("select cntarray, count(*) from ( select dim1, dim2, ARRAY_AGG(cnt) as cntarray from ( select dim1, dim2, dim3, cast( count(*) as VARCHAR ) as cnt from foo group by 1, 2, 3 ) group by 1, 2 ) group by 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new TableDataSource("foo")).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1"), new DefaultDimensionSpec("dim3", "d2")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0"), new DefaultDimensionSpec("d1", "_d1")}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("_a0", (Set)ImmutableSet.of((Object)"a0"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"a0\")", "array_concat(\"__acc\", \"_a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("_a0", "d0", ColumnType.STRING_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"1"), 4L}, (Object)new Object[]{ImmutableList.of((Object)"1", (Object)"1"), 2L}));
    }

    @SqlTestFrameworkConfig.NumMergeBuffers(value=3)
    @Test
    public void testArrayAggGroupByArrayAggOfDoubleFromSubquery() {
        this.cannotVectorize();
        this.testQuery("select cntarray, count(*) from ( select dim1, dim2, ARRAY_AGG(cnt) as cntarray from ( select dim1, dim2, dim3, cast( count(*) as DOUBLE ) as cnt from foo group by 1, 2, 3 ) group by 1, 2 ) group by 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new TableDataSource("foo")).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1"), new DefaultDimensionSpec("dim3", "d2")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0"), new DefaultDimensionSpec("d1", "_d1")}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("_a0", (Set)ImmutableSet.of((Object)"a0"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"a0\")", "array_concat(\"__acc\", \"_a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("_a0", "d0", ColumnType.DOUBLE_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)1.0), 4L}, (Object)new Object[]{ImmutableList.of((Object)1.0, (Object)1.0), 2L}));
    }

    @Test
    public void testArrayAggArrayContainsSubquery() {
        this.cannotVectorize();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{"", "a"}, (Object)new Object[]{"10.1", null}, (Object)new Object[]{"2", ""}, (Object)new Object[]{"1", "a"}, (Object)new Object[]{"def", "abc"}, (Object)new Object[]{"abc", null});
        this.testQuery("SELECT dim1,dim2 FROM foo WHERE ARRAY_CONTAINS((SELECT ARRAY_AGG(DISTINCT dim1) FROM foo WHERE dim1 is not null), dim1)", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteArraysQueryTest.notNull("dim1")).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.LEFT, null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new ExpressionDimFilter("array_contains(\"j0.a0\",\"dim1\")", TestExprMacroTable.INSTANCE)).columns(new String[]{"dim1", "dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)expectedResults);
    }

    @Test
    public void testArrayAggGroupByArrayContainsSubquery() {
        this.cannotVectorize();
        ImmutableList expectedResults = ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L});
        this.testQuery("SELECT dim2, COUNT(*) FROM foo WHERE ARRAY_CONTAINS((SELECT ARRAY_AGG(DISTINCT dim1) FROM foo WHERE dim1 is not null), dim1) GROUP BY 1", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteArraysQueryTest.notNull("dim1")).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.LEFT, null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)new ExpressionDimFilter("array_contains(\"j0.a0\",\"dim1\")", TestExprMacroTable.INSTANCE)).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expectedResults);
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_INLINED)
    @Test
    public void testUnnestInline() {
        this.testQuery("SELECT * FROM UNNEST(ARRAY[1,2,3])", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1}, (Object)new Object[]{2}, (Object)new Object[]{3}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_INLINED)
    @Test
    public void testUnnestInlineWithCount() {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM (select c from UNNEST(ARRAY[1,2,3]) as unnested(c))", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).context(QUERY_CONTEXT_UNNEST).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnest() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}, (Object)new Object[]{""}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testUnnestArrayColumnsString() {
        this.testQuery("SELECT a FROM druid.arrays, UNNEST(arrayString) as unnested (a)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayString\"", ColumnType.STRING_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"d"}, (Object)new Object[]{"e"}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}, (Object[])new Object[][]{{"e"}, {"a"}, {"b"}, {"a"}, {"b"}, {"b"}, {"c"}, {"a"}, {"b"}, {"c"}}));
    }

    @Test
    public void testUnnestArrayColumnsStringThenFunction() {
        this.testQuery("SELECT a || '.txt' FROM druid.arrays, UNNEST(arrayString) as unnested (a)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayString\"", ColumnType.STRING_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "concat(\"j0.unnest\",'.txt')", ColumnType.STRING)}).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"d.txt"}, (Object)new Object[]{"e.txt"}, (Object)new Object[]{"a.txt"}, (Object)new Object[]{"b.txt"}, (Object)new Object[]{"a.txt"}, (Object)new Object[]{"b.txt"}, (Object)new Object[]{"b.txt"}, (Object)new Object[]{"c.txt"}, (Object)new Object[]{"a.txt"}, (Object)new Object[]{"b.txt"}, (Object)new Object[]{"c.txt"}, (Object)new Object[]{"d.txt"}, (Object[])new Object[][]{{"e.txt"}, {"a.txt"}, {"b.txt"}, {"a.txt"}, {"b.txt"}, {"b.txt"}, {"c.txt"}, {"a.txt"}, {"b.txt"}, {"c.txt"}}));
    }

    @Test
    public void testUnnestArrayColumnsStringNulls() {
        this.testQuery("SELECT a FROM druid.arrays, UNNEST(arrayStringNulls) as unnested (a)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"d"}, (Object)new Object[]{null}, (Object)new Object[]{"b"}, (Object)new Object[]{null}, (Object)new Object[]{"b"}, (Object)new Object[]{"a"}, (Object[])new Object[][]{{"b"}, {"b"}, {"b"}, {null}, {"d"}, {null}, {"b"}, {null}, {"b"}}));
    }

    @Test
    public void testUnnestArrayColumnsLong() {
        this.testQuery("SELECT a FROM druid.arrays, UNNEST(arrayLong) as unnested (a)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLong\"", ColumnType.LONG_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object)new Object[]{1L}, (Object)new Object[]{4L}, (Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object)new Object[]{4L}, (Object[])new Object[][]{{2L}, {3L}, {1L}, {2L}, {3L}, {1L}, {4L}, {1L}, {2L}, {3L}, {1L}, {2L}, {3L}, {4L}, {2L}, {3L}}));
    }

    @Test
    public void testUnnestArrayColumnsLongNulls() {
        this.testQuery("SELECT a FROM druid.arrays, UNNEST(arrayLongNulls) as unnested (a)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object)new Object[]{1L}, (Object)new Object[]{null}, (Object)new Object[]{2L}, (Object)new Object[]{9L}, (Object)new Object[]{1L}, (Object)new Object[]{null}, (Object)new Object[]{3L}, (Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object[])new Object[][]{{2L}, {3L}, {null}, {null}, {2L}, {9L}, {1L}, {null}, {3L}, {1L}, {2L}, {3L}}));
    }

    @Test
    public void testUnnestArrayColumnsDouble() {
        this.testQuery("SELECT a FROM druid.arrays, UNNEST(arrayDouble) as unnested (a)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayDouble\"", ColumnType.DOUBLE_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.1}, (Object)new Object[]{2.2}, (Object)new Object[]{3.3}, (Object)new Object[]{2.2}, (Object)new Object[]{3.3}, (Object)new Object[]{4.0}, (Object)new Object[]{1.1}, (Object)new Object[]{2.2}, (Object)new Object[]{3.3}, (Object)new Object[]{1.1}, (Object)new Object[]{3.3}, (Object)new Object[]{3.3}, (Object[])new Object[][]{{4.4}, {5.5}, {1.1}, {2.2}, {3.3}, {2.2}, {3.3}, {4.0}, {1.1}, {2.2}, {3.3}, {1.1}, {3.3}, {3.3}, {4.4}, {5.5}}));
    }

    @Test
    public void testUnnestArrayColumnsDoubleNulls() {
        this.testQuery("SELECT a FROM druid.arrays, UNNEST(arrayDoubleNulls) as unnested (a)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayDoubleNulls\"", ColumnType.DOUBLE_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.DOUBLE}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{999.0}, (Object)new Object[]{5.5}, (Object)new Object[]{null}, (Object)new Object[]{1.1}, (Object)new Object[]{2.2}, (Object)new Object[]{null}, (Object)new Object[]{null}, (Object)new Object[]{2.2}, (Object)new Object[]{null}, (Object)new Object[]{999.0}, (Object)new Object[]{null}, (Object[])new Object[][]{{5.5}, {null}, {1.1}, {999.0}, {5.5}, {null}, {1.1}, {2.2}, {null}, {null}, {2.2}, {null}, {999.0}, {null}, {5.5}}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestTwice() {
        this.testQuery("SELECT dim1, MV_TO_ARRAY(dim3), STRING_TO_ARRAY(dim1, U&'\\005C.') AS dim1_split, dim1_split_unnest, dim3_unnest\nFROM\n  druid.numfoo,\n  UNNEST(STRING_TO_ARRAY(dim1, U&'\\005C.')) as t2 (dim1_split_unnest),\n  UNNEST(MV_TO_ARRAY(dim3)) as t3 (dim3_unnest)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "string_to_array(\"dim1\",'\\u005C.')", ColumnType.STRING_ARRAY), null), (VirtualColumn)this.nestedExpressionVirtualColumn("_j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim3\")", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "string_to_array(\"dim1\",'\\u005C.')", ColumnType.STRING_ARRAY)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"dim1", "v0", "v1", "j0.unnest", "_j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY, ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", ImmutableList.of((Object)"a", (Object)"b"), ImmutableList.of((Object)""), "", "a"}, (Object)new Object[]{"", ImmutableList.of((Object)"a", (Object)"b"), ImmutableList.of((Object)""), "", "b"}, (Object)new Object[]{"10.1", ImmutableList.of((Object)"b", (Object)"c"), ImmutableList.of((Object)"10", (Object)"1"), "10", "b"}, (Object)new Object[]{"10.1", ImmutableList.of((Object)"b", (Object)"c"), ImmutableList.of((Object)"10", (Object)"1"), "10", "c"}, (Object)new Object[]{"10.1", ImmutableList.of((Object)"b", (Object)"c"), ImmutableList.of((Object)"10", (Object)"1"), "1", "b"}, (Object)new Object[]{"10.1", ImmutableList.of((Object)"b", (Object)"c"), ImmutableList.of((Object)"10", (Object)"1"), "1", "c"}, (Object)new Object[]{"2", ImmutableList.of((Object)"d"), ImmutableList.of((Object)"2"), "2", "d"}, (Object)new Object[]{"1", ImmutableList.of((Object)""), ImmutableList.of((Object)"1"), "1", ""}, (Object)new Object[]{"def", null, ImmutableList.of((Object)"def"), "def", null}, (Object)new Object[]{"abc", null, ImmutableList.of((Object)"abc"), "abc", null}));
    }

    @Test
    public void testUnnestTwiceArrayColumns() {
        this.testQuery("SELECT arrayStringNulls, arrayLongNulls, usn, uln  FROM\n  druid.arrays,\n  UNNEST(arrayStringNulls) as t2 (usn),\n  UNNEST(arrayLongNulls) as t3 (uln)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), null), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("_j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"arrayStringNulls", "arrayLongNulls", "j0.unnest", "_j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.LONG_ARRAY, ColumnType.STRING, ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "a", 2L}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "a", 3L}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "b", 2L}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "b", 3L}, (Object)new Object[]{Arrays.asList("b", "b"), Collections.singletonList(1L), "b", 1L}, (Object)new Object[]{Arrays.asList("b", "b"), Collections.singletonList(1L), "b", 1L}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, null, 3L), "a", 1L}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, null, 3L), "a", null}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, null, 3L), "a", 3L}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, null, 3L), "b", 1L}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, null, 3L), "b", null}, (Object)new Object[]{Arrays.asList("a", "b"), Arrays.asList(1L, null, 3L), "b", 3L}, (Object[])new Object[][]{{Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "d", 1L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "d", 2L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "d", 3L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), null, 1L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), null, 2L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), null, 3L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "b", 1L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "b", 2L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "b", 3L}, {Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "a", 2L}, {Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "a", 3L}, {Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "b", 2L}, {Arrays.asList("a", "b"), Arrays.asList(2L, 3L), "b", 3L}, {Arrays.asList("b", "b"), Collections.singletonList(null), "b", null}, {Arrays.asList("b", "b"), Collections.singletonList(null), "b", null}, {Collections.singletonList(null), Arrays.asList(null, 2L, 9L), null, null}, {Collections.singletonList(null), Arrays.asList(null, 2L, 9L), null, 2L}, {Collections.singletonList(null), Arrays.asList(null, 2L, 9L), null, 9L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "d", 1L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "d", 2L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "d", 3L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), null, 1L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), null, 2L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), null, 3L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "b", 1L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "b", 2L}, {Arrays.asList("d", null, "b"), Arrays.asList(1L, 2L, 3L), "b", 3L}}));
    }

    @Test
    public void testUnnestTwiceWithFiltersAndExpressions() {
        this.testQuery("SELECT dim1, MV_TO_ARRAY(dim3), STRING_TO_ARRAY(dim1, U&'\\005C.') AS dim1_split, dim1_split_unnest, dim3_unnest || 'xx'\nFROM\n  druid.numfoo,\n  UNNEST(STRING_TO_ARRAY(dim1, U&'\\005C.')) as t2 (dim1_split_unnest),\n  UNNEST(MV_TO_ARRAY(dim3)) as t3 (dim3_unnest)WHERE dim1_split_unnest IN ('1', '2') AND dim3_unnest LIKE '_'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "string_to_array(\"dim1\",'\\u005C.')", ColumnType.STRING_ARRAY), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableList.of((Object)"1", (Object)"2"))), (VirtualColumn)this.nestedExpressionVirtualColumn("_j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)new LikeDimFilter("_j0.unnest", "_", null, null))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim3\")", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "string_to_array(\"dim1\",'\\u005C.')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v2", "concat(\"_j0.unnest\",'xx')", ColumnType.STRING)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"dim1", "v0", "v1", "j0.unnest", "v2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING_ARRAY, ColumnType.STRING_ARRAY, ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", ImmutableList.of((Object)"b", (Object)"c"), ImmutableList.of((Object)"10", (Object)"1"), "1", "bxx"}, (Object)new Object[]{"10.1", ImmutableList.of((Object)"b", (Object)"c"), ImmutableList.of((Object)"10", (Object)"1"), "1", "cxx"}, (Object)new Object[]{"2", ImmutableList.of((Object)"d"), ImmutableList.of((Object)"2"), "2", "dxx"}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testUnnestThriceWithFiltersOnDimAndUnnestCol() {
        String sql = "    SELECT dimZipf, dim3_unnest1, dim3_unnest2, dim3_unnest3 FROM \n      ( SELECT * FROM \n           ( SELECT * FROM lotsocolumns, UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest1) )           ,UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest2) \n      ), UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest3)  WHERE dimZipf=27 AND dim3_unnest1='Baz'";
        ImmutableList expectedQuerySc = ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("lotsocolumns"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), null), (DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("dimZipf", "27", ColumnType.LONG), CalciteArraysQueryTest.equality("j0.unnest", "Baz", ColumnType.STRING))), (VirtualColumn)this.nestedExpressionVirtualColumn("_j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), null), (VirtualColumn)this.nestedExpressionVirtualColumn("__j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "'Baz'", ColumnType.STRING)}).columns(new String[]{"dimZipf", "v0", "_j0.unnest", "__j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).build());
        this.testQuery(sql, QUERY_CONTEXT_UNNEST, (List<Query<?>>)expectedQuerySc, (List<Object[]>)ImmutableList.of((Object)new Object[]{"27", "Baz", "Baz", "Baz"}, (Object)new Object[]{"27", "Baz", "Baz", "Baz"}, (Object)new Object[]{"27", "Baz", "Baz", "Hello"}, (Object)new Object[]{"27", "Baz", "Baz", "World"}, (Object)new Object[]{"27", "Baz", "Baz", "Baz"}, (Object)new Object[]{"27", "Baz", "Baz", "Baz"}, (Object)new Object[]{"27", "Baz", "Baz", "Hello"}, (Object)new Object[]{"27", "Baz", "Baz", "World"}, (Object)new Object[]{"27", "Baz", "Hello", "Baz"}, (Object)new Object[]{"27", "Baz", "Hello", "Baz"}, (Object)new Object[]{"27", "Baz", "Hello", "Hello"}, (Object)new Object[]{"27", "Baz", "Hello", "World"}, (Object[])new Object[][]{{"27", "Baz", "World", "Baz"}, {"27", "Baz", "World", "Baz"}, {"27", "Baz", "World", "Hello"}, {"27", "Baz", "World", "World"}, {"27", "Baz", "Baz", "Baz"}, {"27", "Baz", "Baz", "Baz"}, {"27", "Baz", "Baz", "Hello"}, {"27", "Baz", "Baz", "World"}, {"27", "Baz", "Baz", "Baz"}, {"27", "Baz", "Baz", "Baz"}, {"27", "Baz", "Baz", "Hello"}, {"27", "Baz", "Baz", "World"}, {"27", "Baz", "Hello", "Baz"}, {"27", "Baz", "Hello", "Baz"}, {"27", "Baz", "Hello", "Hello"}, {"27", "Baz", "Hello", "World"}, {"27", "Baz", "World", "Baz"}, {"27", "Baz", "World", "Baz"}, {"27", "Baz", "World", "Hello"}, {"27", "Baz", "World", "World"}}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN, ignoreDefaultsMode=DecoupledTestConfig.IgnoreDefaultsReson.UNNEST_ARRAY_ISSUE)
    @Test
    public void testUnnestThriceWithFiltersOnDimAndAllUnnestColumns() {
        String sql = "    SELECT dimZipf, dim3_unnest1, dim3_unnest2, dim3_unnest3 FROM \n      ( SELECT * FROM \n           ( SELECT * FROM lotsocolumns, UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest1) )           ,UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest2) \n      ), UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest3)  WHERE dimZipf=27 AND dim3_unnest1='Baz' AND dim3_unnest2='Hello' AND dim3_unnest3='World'";
        ImmutableList expectedQuerySc = ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("lotsocolumns"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), null), (DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("dimZipf", "27", ColumnType.LONG), CalciteArraysQueryTest.equality("j0.unnest", "Baz", ColumnType.STRING))), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("_j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.equality("_j0.unnest", "Hello", ColumnType.STRING)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("__j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.equality("__j0.unnest", "World", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "'Baz'", ColumnType.STRING)}).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"dimZipf", "v0", "_j0.unnest", "__j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).build());
        this.testQuery(sql, QUERY_CONTEXT_UNNEST, (List<Query<?>>)expectedQuerySc, (List<Object[]>)ImmutableList.of((Object)new Object[]{"27", "Baz", "Hello", "World"}, (Object)new Object[]{"27", "Baz", "Hello", "World"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN, ignoreDefaultsMode=DecoupledTestConfig.IgnoreDefaultsReson.UNNEST_ARRAY_ISSUE)
    @Test
    public void testUnnestThriceWithFiltersOnDimAndAllUnnestColumnsArrayColumns() {
        String sql = "    SELECT arrayString, uln, udn, usn FROM \n      ( SELECT * FROM \n           ( SELECT * FROM arrays, UNNEST(arrayLongNulls) as ut(uln))           ,UNNEST(arrayDoubleNulls) as ut(udn) \n      ), UNNEST(arrayStringNulls) as ut(usn)  WHERE arrayString = ARRAY['a','b'] AND uln = 1 AND udn = 2.2 AND usn = 'a'";
        ImmutableList expectedQuerySc = ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), null), (DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("arrayString", ImmutableList.of((Object)"a", (Object)"b"), ColumnType.STRING_ARRAY), CalciteArraysQueryTest.equality("j0.unnest", 1, ColumnType.LONG))), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("_j0.unnest", "\"arrayDoubleNulls\"", ColumnType.DOUBLE_ARRAY), (DimFilter)CalciteArraysQueryTest.equality("_j0.unnest", 2.2, ColumnType.DOUBLE)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("__j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), (DimFilter)CalciteArraysQueryTest.equality("__j0.unnest", "a", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array('a','b')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "1", ColumnType.LONG)}).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0", "v1", "_j0.unnest", "__j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.STRING}).build());
        this.testQuery(sql, QUERY_CONTEXT_UNNEST, (List<Query<?>>)expectedQuerySc, (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1L, 2.2, "a"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testUnnestThriceWithFiltersOnDimAndUnnestColumnsORCombinations() {
        String sql = "    SELECT dimZipf, dim3_unnest1, dim3_unnest2, dim3_unnest3 FROM \n      ( SELECT * FROM \n           ( SELECT * FROM lotsocolumns, UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest1) )           ,UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest2) \n      ), UNNEST(MV_TO_ARRAY(dimMultivalEnumerated)) as ut(dim3_unnest3)  WHERE dimZipf=27 AND (dim3_unnest1='Baz' OR dim3_unnest2='Hello') AND dim3_unnest3='World'";
        ImmutableList expectedQuerySqlCom = ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("lotsocolumns"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), null), (DimFilter)CalciteArraysQueryTest.equality("dimZipf", "27", ColumnType.LONG)), (VirtualColumn)this.nestedExpressionVirtualColumn("_j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), null), (DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.equality("j0.unnest", "Baz", ColumnType.STRING), CalciteArraysQueryTest.equality("_j0.unnest", "Hello", ColumnType.STRING))), (VirtualColumn)this.nestedExpressionVirtualColumn("__j0.unnest", "\"dimMultivalEnumerated\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.equality("__j0.unnest", "World", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"dimZipf", "j0.unnest", "_j0.unnest", "__j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).build());
        this.testQuery(sql, QUERY_CONTEXT_UNNEST, (List<Query<?>>)expectedQuerySqlCom, (List<Object[]>)ImmutableList.of((Object)new Object[]{"27", "Baz", "Baz", "World"}, (Object)new Object[]{"27", "Baz", "Baz", "World"}, (Object)new Object[]{"27", "Baz", "Hello", "World"}, (Object)new Object[]{"27", "Baz", "World", "World"}, (Object)new Object[]{"27", "Baz", "Baz", "World"}, (Object)new Object[]{"27", "Baz", "Baz", "World"}, (Object)new Object[]{"27", "Baz", "Hello", "World"}, (Object)new Object[]{"27", "Baz", "World", "World"}, (Object)new Object[]{"27", "Hello", "Hello", "World"}, (Object)new Object[]{"27", "World", "Hello", "World"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testUnnestThriceWithFiltersOnDimAndAllUnnestColumnsArrayColumnsOrFilters() {
        String sql = "    SELECT arrayString, uln, udn, usn FROM \n      ( SELECT * FROM \n           ( SELECT * FROM arrays, UNNEST(arrayLongNulls) as ut(uln))           ,UNNEST(arrayDoubleNulls) as ut(udn) \n      ), UNNEST(arrayStringNulls) as ut(usn)  WHERE arrayString = ARRAY['a','b'] AND (uln = 1 OR udn = 2.2) AND usn = 'a'";
        ImmutableList expectedQuerySc = ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), null), (DimFilter)CalciteArraysQueryTest.equality("arrayString", ImmutableList.of((Object)"a", (Object)"b"), ColumnType.STRING_ARRAY)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("_j0.unnest", "\"arrayDoubleNulls\"", ColumnType.DOUBLE_ARRAY), null), (DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.equality("j0.unnest", 1, ColumnType.LONG), CalciteArraysQueryTest.equality("_j0.unnest", 2.2, ColumnType.DOUBLE))), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("__j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), (DimFilter)CalciteArraysQueryTest.equality("__j0.unnest", "a", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array('a','b')", ColumnType.STRING_ARRAY)}).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0", "j0.unnest", "_j0.unnest", "__j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.STRING}).build());
        this.testQuery(sql, QUERY_CONTEXT_UNNEST, (List<Query<?>>)expectedQuerySc, (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1L, 1.1, "a"}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1L, 2.2, "a"}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1L, null, "a"}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), null, 2.2, "a"}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 3L, 2.2, "a"}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestWithGroupBy() {
        this.cannotVectorize();
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) GROUP BY d3 ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}));
    }

    @Test
    public void testUnnestWithGroupByArrayColumn() {
        this.cannotVectorize();
        this.testQuery("SELECT usn FROM druid.arrays, UNNEST(arrayStringNulls) as u (usn) GROUP BY usn ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"d"}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestWithGroupByOrderBy() {
        this.cannotVectorize();
        this.testQuery("SELECT d3, COUNT(*) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) AS unnested(d3) GROUP BY d3 ORDER BY d3 DESC ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)}).build()).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"d", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{null, 2L}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestWithGroupByOrderByWithLimit() {
        Map context = QueryContexts.override(QUERY_CONTEXT_UNNEST, (String)"useLexicographicTopN", (Object)true);
        this.testQuery("SELECT d3, COUNT(*) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) AS unnested(d3) GROUP BY d3 ORDER BY d3 ASC LIMIT 4 ", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(4).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"b", 2L}));
    }

    @Test
    public void testUnnestWithGroupByHaving() {
        this.cannotVectorize();
        this.testQuery("SELECT d3, COUNT(*) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) AS unnested(d3) GROUP BY d3 HAVING COUNT(*) = 1", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setHavingSpec((HavingSpec)new DimFilterHavingSpec(CalciteArraysQueryTest.equality("a0", 1L, ColumnType.LONG), Boolean.valueOf(true))).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L}));
    }

    @Test
    public void testUnnestWithLimit() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) LIMIT 3", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).limit(3L).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestFirstQueryOnSelect() {
        this.testQuery("SELECT d3 FROM (select dim1, dim2, dim3 from druid.numfoo), UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}, (Object)new Object[]{""}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testUnnestVirtualWithColumns1() {
        this.testQuery("SELECT strings, m1 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (strings) where (strings='a' and (m1<=10 or strings='b'))", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.equality("j0.unnest", "a", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters((DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.range("m1", ColumnType.LONG, null, "10", false, false), CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING))).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest", "m1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", Float.valueOf(1.0f)}));
    }

    @Test
    public void testUnnestVirtualWithColumns2() {
        this.testQuery("SELECT strings, m1 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (strings) where (strings='a' or (m1=2 and strings='b'))", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters((DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{CalciteArraysQueryTest.equality("j0.unnest", "a", ColumnType.STRING), CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("m1", "2", ColumnType.FLOAT), CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING))})).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest", "m1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", Float.valueOf(1.0f)}, (Object)new Object[]{"b", Float.valueOf(2.0f)}));
    }

    @Test
    public void testUnnestWithFilters() {
        this.testQuery("SELECT d3 FROM (select * from druid.numfoo where dim2='a'), UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.equality("dim2", "a", ColumnType.STRING)), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{""}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNNEST_EXTRA_SCAN)
    @Test
    public void testUnnestWithFiltersWithExpressionInInnerQuery() {
        this.testQuery("SELECT t,d3 FROM (select FLOOR(__time to hour) t, dim3 from druid.numfoo where dim2='a'), UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.equality("dim2", "a", ColumnType.STRING)), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'PT1H',null,'UTC')", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "a"}, (Object)new Object[]{946684800000L, "b"}, (Object)new Object[]{978307200000L, ""}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNNEST_EXTRA_SCAN)
    @Test
    public void testUnnestWithInFiltersWithExpressionInInnerQuery() {
        this.testQuery("SELECT t,d3 FROM (select FLOOR(__time to hour) t, dim3 from druid.numfoo where dim2 IN ('a','b')), UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"a", (Object)"b"))), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'PT1H',null,'UTC')", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "a"}, (Object)new Object[]{946684800000L, "b"}, (Object)new Object[]{978307200000L, ""}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNUSED_VIRTUALCOLUMN)
    @Test
    public void testUnnestWithFiltersInnerLimit() {
        this.testQuery("SELECT d3 FROM (select dim2,dim3 from druid.numfoo where dim2='a' LIMIT 2), UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new QueryDataSource((Query)CalciteArraysQueryTest.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("numfoo")).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters(CalciteArraysQueryTest.equality("dim2", "a", ColumnType.STRING)).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).limit(2L).context(QUERY_CONTEXT_UNNEST).build()), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{""}));
    }

    @Test
    public void testUnnestWithFiltersInsideAndOutside() {
        this.testQuery("SELECT d3 FROM\n  (select * from druid.numfoo where dim2='a') as t,\n  UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)\nWHERE t.dim1 <> 'foo'\nAND unnested.d3 <> 'b'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.and(new DimFilter[]{CalciteArraysQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteArraysQueryTest.not(CalciteArraysQueryTest.equality("dim1", "foo", ColumnType.STRING))})), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.not(CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING)))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{""}));
    }

    @Test
    public void testUnnestWithFiltersInsideAndOutside1() {
        this.testQuery("SELECT d3 FROM\n  (select * from druid.numfoo where dim2='a'),\n  UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)\nWHERE dim1 <> 'foo'\nAND (unnested.d3 IN ('a', 'c') OR unnested.d3 LIKE '_')", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.and(new DimFilter[]{CalciteArraysQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteArraysQueryTest.not(CalciteArraysQueryTest.equality("dim1", "foo", ColumnType.STRING))})), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableList.of((Object)"a", (Object)"c")), new LikeDimFilter("j0.unnest", "_", null, null)}))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithFiltersOutside() {
        this.testQuery("SELECT d3 FROM\n  druid.numfoo t,\n  UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)\nWHERE t.dim2='a'\nAND t.dim1 <> 'foo'\nAND (unnested.d3 IN ('a', 'c') OR unnested.d3 LIKE '_')", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.and(new DimFilter[]{CalciteArraysQueryTest.equality("dim2", "a", ColumnType.STRING), CalciteArraysQueryTest.not(CalciteArraysQueryTest.equality("dim1", "foo", ColumnType.STRING))})), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableList.of((Object)"a", (Object)"c")), new LikeDimFilter("j0.unnest", "_", null, null)}))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestWithInFilters() {
        this.testQuery("SELECT d3 FROM (select * from druid.numfoo where dim2 IN ('a','b','ab','abc')), UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"ab", (Object)"abc"))), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{""}, (Object)new Object[]{null}));
    }

    @Test
    public void testUnnestVirtualWithColumns() {
        this.testQuery("SELECT strings FROM druid.numfoo, UNNEST(ARRAY[dim4, dim5]) as unnested (strings)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"dim4\",\"dim5\")", ColumnType.STRING_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"aa"}, (Object)new Object[]{"a"}, (Object)new Object[]{"ab"}, (Object)new Object[]{"a"}, (Object)new Object[]{"ba"}, (Object)new Object[]{"b"}, (Object)new Object[]{"ad"}, (Object)new Object[]{"b"}, (Object)new Object[]{"aa"}, (Object)new Object[]{"b"}, (Object)new Object[]{"ab"}, (Object[])new Object[0][]));
    }

    @Test
    public void testUnnestWithGroupByOrderByOnVirtualColumn() {
        this.cannotVectorize();
        this.testQuery("SELECT d24, COUNT(*) FROM druid.numfoo, UNNEST(ARRAY[dim2, dim4]) AS unnested(d24) GROUP BY d24 ORDER BY d24 DESC ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"dim2\",\"dim4\")", ColumnType.STRING_ARRAY), null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)}).build()).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 3L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"a", 5L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{null, 2L}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testUnnestWithJoinOnTheLeft() {
        this.testQuery("SELECT d3 from (SELECT * from druid.numfoo JOIN (select dim2 as t from druid.numfoo where dim2 IN ('a','b','ab','abc')) ON dim2=t), UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)CalciteArraysQueryTest.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("numfoo")).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters(CalciteArraysQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"ab", (Object)"abc"))).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_UNNEST).build()), "j0.", "(\"dim2\" == \"j0.dim2\")", JoinType.INNER), (VirtualColumn)this.nestedExpressionVirtualColumn("_j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"_j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{""}, (Object)new Object[]{""}, (Object)new Object[]{null}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_INLINED)
    @Test
    public void testUnnestWithConstant() {
        this.testQuery("SELECT longs FROM druid.numfoo, UNNEST(ARRAY[1,2,3]) as unnested (longs)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.EXPR$0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1}, (Object)new Object[]{2}, (Object)new Object[]{3}, (Object)new Object[]{1}, (Object)new Object[]{2}, (Object)new Object[]{3}, (Object)new Object[]{1}, (Object)new Object[]{2}, (Object)new Object[]{3}, (Object)new Object[]{1}, (Object)new Object[]{2}, (Object)new Object[]{3}, (Object[])new Object[][]{{1}, {2}, {3}, {1}, {2}, {3}}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestWithSQLFunctionOnUnnestedColumn() {
        this.testQuery("SELECT strlen(d3) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "strlen(\"j0.unnest\")", ColumnType.LONG)}).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1}, (Object)new Object[]{1}, (Object)new Object[]{1}, (Object)new Object[]{1}, (Object)new Object[]{1}, (Object)new Object[]{0}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testUnnestWithINFiltersWithLeftRewrite() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3 IN ('a','b') and m1 < 10", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.range("m1", ColumnType.LONG, null, 10L, false, true)), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"b")))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithINFiltersWithNoLeftRewrite() {
        this.testQuery("SELECT d45 FROM druid.numfoo, UNNEST(ARRAY[dim4,dim5]) as unnested (d45) where d45 IN ('a','b')", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"dim4\",\"dim5\")", ColumnType.STRING_ARRAY), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"b")))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"a"}, (Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithInvalidINFiltersOnUnnestedColumn() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3 IN ('foo','bar')", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"foo", (Object)"bar")))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of());
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNNEST_DIFFERENT_RESULTSET)
    @Test
    public void testUnnestWithNotFiltersOnUnnestedColumn() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3!='d' ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.not(CalciteArraysQueryTest.equality("j0.unnest", "d", ColumnType.STRING)))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{""}));
    }

    @Test
    public void testUnnestWithSelectorFiltersOnSelectedColumn() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3='b'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithSelectorFiltersOnVirtualColumn() {
        this.testQuery("SELECT d12 FROM druid.numfoo, UNNEST(ARRAY[m1,m2]) as unnested (d12) where d12=1", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"m1\",\"m2\")", ColumnType.FLOAT_ARRAY), (DimFilter)CalciteArraysQueryTest.equality("j0.unnest", 1.0, ColumnType.FLOAT))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.FLOAT}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(1.0f)}));
    }

    @Test
    public void testUnnestWithSelectorFiltersOnVirtualStringColumn() {
        this.testQuery("SELECT d45 FROM druid.numfoo, UNNEST(ARRAY[dim4,dim5]) as unnested (d45) where d45 IN ('a','ab')", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"dim4\",\"dim5\")", ColumnType.STRING_ARRAY), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"ab")))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"a"}, (Object)new Object[]{"ab"}, (Object)new Object[]{"a"}, (Object)new Object[]{"ab"}));
    }

    @Test
    public void testUnnestWithMultipleAndFiltersOnSelectedColumns() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3='b' and m1 < 10 and m2 < 10", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.range("m1", ColumnType.LONG, null, 10L, false, true), CalciteArraysQueryTest.range("m2", ColumnType.LONG, null, 10L, false, true))), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithMultipleOrFiltersOnSelectedColumns() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3='b' or m1 < 2 ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).filters((DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING), CalciteArraysQueryTest.range("m1", ColumnType.LONG, null, 2L, false, true))).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithMultipleAndFiltersOnSelectedUnnestedColumns() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3 IN ('a','b') and d3 < 'e' ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"b")))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithMultipleOrFiltersOnUnnestedColumns() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3='b' or d3='d' ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"b", (Object)"d")))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"d"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNNEST_DIFFERENT_RESULTSET)
    @Test
    public void testUnnestWithMultipleOrFiltersOnVariationsOfUnnestedColumns() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where strlen(d3) < 2 or d3='d' ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{CalciteArraysQueryTest.expressionFilter("(strlen(\"j0.unnest\") < 2)"), CalciteArraysQueryTest.equality("j0.unnest", "d", ColumnType.STRING)}))).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}, (Object)new Object[]{""}));
    }

    @Test
    public void testUnnestWithMultipleOrFiltersOnSelectedNonUnnestedColumns() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where m1 < 2 or m2 < 2 ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("numfoo"), (DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.range("m1", ColumnType.LONG, null, 2L, false, true), CalciteArraysQueryTest.range("m2", ColumnType.LONG, null, 2L, false, true))), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithMultipleOrFiltersOnSelectedVirtualColumns() {
        this.testQuery("SELECT d45 FROM druid.numfoo, UNNEST(ARRAY[dim4,dim5]) as unnested (d45) where d45 IN ('a','aa') or m1 < 2 ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"dim4\",\"dim5\")", ColumnType.STRING_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).filters((DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"aa")), CalciteArraysQueryTest.range("m1", ColumnType.LONG, null, 2L, false, true))).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"aa"}, (Object)new Object[]{"a"}, (Object)new Object[]{"a"}, (Object)new Object[]{"aa"}));
    }

    @Test
    public void testUnnestWithMultipleOrFiltersOnUnnestedColumnsAndOnOriginalColumn() {
        this.testQuery("SELECT d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where d3='b' or dim3='d' ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters((DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING), CalciteArraysQueryTest.equality("dim3", "d", ColumnType.STRING))).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"d"}));
    }

    @Test
    public void testUnnestWithMultipleOrFiltersOnUnnestedColumnsAndOnOriginalColumnDiffOrdering() {
        this.testQuery("SELECT dim3, d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) where dim3='b' or d3='a' ", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters((DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.equality("dim3", "b", ColumnType.STRING), CalciteArraysQueryTest.equality("j0.unnest", "a", ColumnType.STRING))).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"dim3", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "b"}, (Object)new Object[]{"[\"b\",\"c\"]", "b"}, (Object)new Object[]{"[\"b\",\"c\"]", "c"}));
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNNEST_RESULT_MISMATCH)
    @Test
    public void testUnnestWithCountOnColumn() {
        this.cannotVectorize();
        this.testQuery("SELECT count(*) d3 FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).context(QUERY_CONTEXT_UNNEST).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{8L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testUnnestWithGroupByHavingSelector() {
        this.cannotVectorize();
        this.testQuery("SELECT d3, COUNT(*) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) AS unnested(d3) GROUP BY d3 HAVING d3='b'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setDimFilter(CalciteArraysQueryTest.equality("j0.unnest", "b", ColumnType.STRING)).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 2L}));
    }

    @Test
    public void testUnnestWithSumOnUnnestedVirtualColumn() {
        this.cannotVectorize();
        this.testQuery("select sum(c) col from druid.numfoo, unnest(ARRAY[m1,m2]) as u(c)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"m1\",\"m2\")", ColumnType.FLOAT_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).context(QUERY_CONTEXT_UNNEST).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "j0.unnest")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{42.0}));
    }

    @Test
    public void testUnnestWithSumOnUnnestedColumn() {
        this.cannotVectorize();
        this.testQuery("select sum(c) col from druid.numfoo, unnest(mv_to_array(dim3)) as u(c)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "CAST(\"j0.unnest\", 'DOUBLE')", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_UNNEST).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v0")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}));
    }

    @Test
    public void testUnnestWithSumOnUnnestedArrayColumn() {
        this.cannotVectorize();
        this.testQuery("select sum(c) col from druid.arrays, unnest(arrayDoubleNulls) as u(c)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayDoubleNulls\"", ColumnType.DOUBLE_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).context(QUERY_CONTEXT_UNNEST).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "j0.unnest")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4030.0999999999995}));
    }

    @Test
    public void testUnnestWithGroupByHavingWithWhereOnAggCol() {
        this.cannotVectorize();
        this.testQuery("SELECT d3, COUNT(*) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) AS unnested(d3) WHERE d3 IN ('a','c') GROUP BY d3 HAVING COUNT(*) = 1", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"c")))).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setHavingSpec((HavingSpec)new DimFilterHavingSpec(CalciteArraysQueryTest.equality("a0", 1L, ColumnType.LONG), Boolean.valueOf(true))).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testUnnestWithGroupByHavingWithWhereOnUnnestCol() {
        this.cannotVectorize();
        this.testQuery("SELECT d3, COUNT(*) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) AS unnested(d3) WHERE d3 IN ('a','c') GROUP BY d3 HAVING d3='a'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", (Collection<String>)ImmutableSet.of((Object)"a", (Object)"c")))).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setDimFilter(CalciteArraysQueryTest.equality("j0.unnest", "a", ColumnType.STRING)).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 1L}));
    }

    @Test
    public void testUnnestWithGroupByWithWhereOnUnnestArrayCol() {
        this.cannotVectorize();
        this.testQuery("SELECT uln, COUNT(*) FROM druid.arrays, UNNEST(arrayLongNulls) AS unnested(uln) WHERE uln IN (1, 2, 3) GROUP BY uln", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", ColumnType.LONG, ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.LONG)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 5L}, (Object)new Object[]{2L, 6L}, (Object)new Object[]{3L, 6L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @Test
    public void testUnnestWithGroupByHavingWithWhereOnUnnestArrayCol() {
        this.cannotVectorize();
        this.testQuery("SELECT uln, COUNT(*) FROM druid.arrays, UNNEST(arrayLongNulls) AS unnested(uln) WHERE uln IN (1, 2, 3) GROUP BY uln HAVING uln=1", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("arrays"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), (DimFilter)CalciteArraysQueryTest.in("j0.unnest", ColumnType.LONG, ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_UNNEST).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.unnest", "d0", ColumnType.LONG)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setDimFilter(CalciteArraysQueryTest.equality("j0.unnest", 1L, ColumnType.LONG)).setContext(QUERY_CONTEXT_UNNEST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 5L}));
    }

    @Test
    public void testUnnestVirtualWithColumnsAndNullIf() {
        this.testQuery("select c,m2 from druid.foo, unnest(ARRAY[\"m1\", \"m2\"]) as u(c) where NULLIF(c,m2) IS NULL", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("foo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"m1\",\"m2\")", ColumnType.FLOAT_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters((DimFilter)CalciteArraysQueryTest.or(new DimFilter[]{CalciteArraysQueryTest.expressionFilter("(\"j0.unnest\" == \"m2\")"), CalciteArraysQueryTest.and(new DimFilter[]{CalciteArraysQueryTest.isNull("j0.unnest"), CalciteArraysQueryTest.not((DimFilter)CalciteArraysQueryTest.istrue((DimFilter)CalciteArraysQueryTest.expressionFilter("(\"j0.unnest\" == \"m2\")")))})})).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest", "m2"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.DOUBLE}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), 1.0}, (Object)new Object[]{Float.valueOf(1.0f), 1.0}, (Object)new Object[]{Float.valueOf(2.0f), 2.0}, (Object)new Object[]{Float.valueOf(2.0f), 2.0}, (Object)new Object[]{Float.valueOf(3.0f), 3.0}, (Object)new Object[]{Float.valueOf(3.0f), 3.0}, (Object)new Object[]{Float.valueOf(4.0f), 4.0}, (Object)new Object[]{Float.valueOf(4.0f), 4.0}, (Object)new Object[]{Float.valueOf(5.0f), 5.0}, (Object)new Object[]{Float.valueOf(5.0f), 5.0}, (Object)new Object[]{Float.valueOf(6.0f), 6.0}, (Object)new Object[]{Float.valueOf(6.0f), 6.0}, (Object[])new Object[0][]));
    }

    @Test
    public void testUnnestWithTimeFilterOnly() {
        this.testQuery("select c from foo, unnest(MV_TO_ARRAY(dim3)) as u(c) where __time >= TIMESTAMP '2000-01-02 00:00:00' and __time <= TIMESTAMP '2000-01-03 00:10:00'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("foo"), (DimFilter)CalciteArraysQueryTest.range("__time", ColumnType.LONG, 946771200000L, 946858200000L, false, false)), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00:00:00.000Z/2000-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}));
    }

    @Test
    public void testUnnestWithTimeFilterOnlyArrayColumn() {
        this.testQuery("select c from arrays, unnest(arrayStringNulls) as u(c) where __time >= TIMESTAMP '2023-01-02 00:00:00' and __time <= TIMESTAMP '2023-01-03 00:10:00'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("arrays"), (DimFilter)CalciteArraysQueryTest.range("__time", ColumnType.LONG, 1672617600000L, 1672704600000L, false, false)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayStringNulls\"", ColumnType.STRING_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2023-01-02T00:00:00.000Z/2023-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{null}, (Object)new Object[]{"d"}, (Object)new Object[]{null}, (Object)new Object[]{"b"}, (Object)new Object[]{null}, (Object)new Object[]{"b"}));
    }

    @Test
    public void testUnnestWithTimeFilterAndAnotherFilter() {
        this.testQuery("select c from foo, unnest(MV_TO_ARRAY(dim3)) as u(c)  where m1=2 and __time >= TIMESTAMP '2000-01-02 00:00:00' and __time <= TIMESTAMP '2000-01-03 00:10:00'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("foo"), (DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("m1", 2.0, ColumnType.FLOAT), CalciteArraysQueryTest.range("__time", ColumnType.LONG, 946771200000L, 946858200000L, false, false))), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00:00:00.000Z/2000-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"c"}));
    }

    @Test
    public void testUnnestWithTimeFilterOrAnotherFilter() {
        this.testQuery("select c from foo, unnest(MV_TO_ARRAY(dim3)) as u(c)  where m1=2 or __time >= TIMESTAMP '2000-01-02 00:00:00' and __time <= TIMESTAMP '2000-01-03 00:10:00'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("foo"), (DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.equality("m1", 2.0, ColumnType.FLOAT), CalciteArraysQueryTest.range("__time", ColumnType.LONG, 946771200000L, 946858200000L, false, false))), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}));
    }

    @Test
    public void testUnnestWithTimeFilterOnlyNested() {
        this.testQuery("select c from foo CROSS JOIN UNNEST(ARRAY[m1,m2]) as un(d) CROSS JOIN unnest(MV_TO_ARRAY(dim3)) as u(c) where __time >= TIMESTAMP '2000-01-02 00:00:00' and __time <= TIMESTAMP '2000-01-03 00:10:00'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("foo"), (DimFilter)CalciteArraysQueryTest.range("__time", ColumnType.LONG, 946771200000L, 946858200000L, false, false)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"m1\",\"m2\")", ColumnType.FLOAT_ARRAY), null), (VirtualColumn)this.nestedExpressionVirtualColumn(this.ds("j0.unnest"), "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00:00:00.000Z/2000-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{this.ds("j0.unnest")}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}, (Object)new Object[]{"d"}));
    }

    @Test
    public void testUnnestWithTimeFilterOnlyNestedAndNestedAgain() {
        this.testQuery("select c from foo CROSS JOIN UNNEST(ARRAY[m1,m2]) as un(d) CROSS JOIN UNNEST(ARRAY[dim1,dim2]) as ud(a)  CROSS JOIN unnest(MV_TO_ARRAY(dim3)) as u(c) where __time >= TIMESTAMP '2000-01-02 00:00:00' and __time <= TIMESTAMP '2000-01-03 00:10:00'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("foo"), (DimFilter)CalciteArraysQueryTest.range("__time", ColumnType.LONG, 946771200000L, 946858200000L, false, false)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(\"m1\",\"m2\")", ColumnType.FLOAT_ARRAY), null), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn(this.ds("j0.unnest"), "array(\"dim1\",\"dim2\")", ColumnType.STRING_ARRAY), null), (VirtualColumn)this.nestedExpressionVirtualColumn(this.ds(this.ds("j0.unnest")), "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00:00:00.000Z/2000-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{this.ds(this.ds("j0.unnest"))}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}, (Object)new Object[]{"d"}, (Object)new Object[]{"d"}, (Object)new Object[]{"d"}, (Object[])new Object[0][]));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testUnnestWithTimeFilterInsideSubquery() {
        this.testQuery("select d3 from (select * from foo, UNNEST(MV_TO_ARRAY(dim3)) as u(d3) where __time >= TIMESTAMP '2000-01-02 00:00:00' and __time <= TIMESTAMP '2000-01-03 00:10:00' LIMIT 2) \n where m1 IN (1,2)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)CalciteArraysQueryTest.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("foo"), (DimFilter)CalciteArraysQueryTest.range("__time", ColumnType.LONG, 946771200000L, 946858200000L, false, false)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00:00:00.000Z/2000-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"m1", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.STRING}).limit(2L).context(QUERY_CONTEXT_UNNEST).build())).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteArraysQueryTest.in("m1", ColumnType.FLOAT, ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b"}, (Object)new Object[]{"c"}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testUnnestWithTimeFilterInsideSubqueryArrayColumns() {
        this.testQuery("select uln from (select * from arrays, UNNEST(arrayLongNulls) as u(uln) where __time >= TIMESTAMP '2023-01-02 00:00:00' and __time <= TIMESTAMP '2023-01-03 00:10:00' LIMIT 2) \n where ARRAY_CONTAINS(arrayLongNulls, ARRAY[2])", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)CalciteArraysQueryTest.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("arrays"), (DimFilter)CalciteArraysQueryTest.range("__time", ColumnType.LONG, 1672617600000L, 1672704600000L, false, false)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"arrayLongNulls\"", ColumnType.LONG_ARRAY), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2023-01-02T00:00:00.000Z/2023-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"arrayLongNulls", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY, ColumnType.LONG}).limit(2L).context(QUERY_CONTEXT_UNNEST).build())).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new ArrayContainsElementFilter("arrayLongNulls", ColumnType.LONG, (Object)2L, null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}, (Object)new Object[]{3L}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testUnnestWithFilterAndUnnestNestedBackToBack() {
        this.testQuery("SELECT m1, dim3_unnest1, dim3_unnest2, dim3_unnest3 FROM \n      ( SELECT * FROM \n           ( SELECT * FROM foo, UNNEST(MV_TO_ARRAY(dim3)) as ut(dim3_unnest1) ), \n             UNNEST(MV_TO_ARRAY(dim3)) as ut(dim3_unnest2) \n      ), UNNEST(MV_TO_ARRAY(dim3)) as ut(dim3_unnest3)  WHERE m1=2  AND (dim3_unnest1='a' OR dim3_unnest2='b') AND dim3_unnest3='c'  AND __time >= TIMESTAMP '2000-01-02 00:00:00' and __time <= TIMESTAMP '2000-01-03 00:10:00'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("foo"), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null), (DimFilter)CalciteArraysQueryTest.and(CalciteArraysQueryTest.equality("m1", Float.valueOf(2.0f), ColumnType.FLOAT), CalciteArraysQueryTest.range("__time", ColumnType.LONG, 946771200000L, 946858200000L, false, false))), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("_j0.unnest", "\"dim3\"", ColumnType.STRING), null), (DimFilter)CalciteArraysQueryTest.or(CalciteArraysQueryTest.equality("j0.unnest", "a", ColumnType.STRING), CalciteArraysQueryTest.equality("_j0.unnest", "b", ColumnType.STRING))), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("__j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.equality("__j0.unnest", "c", ColumnType.STRING))).intervals(CalciteArraysQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00:00:00.000Z/2000-01-03T00:10:00.001Z"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "2.0", ColumnType.FLOAT)}).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0", "j0.unnest", "_j0.unnest", "__j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(2.0f), "b", "b", "c"}, (Object)new Object[]{Float.valueOf(2.0f), "c", "b", "c"}));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testUnnestWithLookup() {
        this.testQuery("SELECT * FROM lookup.lookyloo, unnest(mv_to_array(v)) as u(d) where k='a'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new LookupDataSource("lookyloo"), (DimFilter)CalciteArraysQueryTest.equality("k", "a", ColumnType.STRING)), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "\"v\"", ColumnType.STRING), null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "'a'", ColumnType.STRING)}).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0", "v", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "xa", "xa"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNNEST_VC_USES_PROJECTED_CONSTANT)
    @Test
    public void testUnnestWithGroupByOnExpression() {
        this.cannotVectorize();
        this.testQuery("WITH X as \n(\nSELECT\nARRAY[1,2,3] as allNums\nFROM foo\nGROUP BY 1\n)\nselect * from X CROSS JOIN UNNEST(X.allNums) as ud(num)", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Filtration.eternity()))).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(1,2,3)", ColumnType.LONG_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG_ARRAY)})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (VirtualColumn)CalciteArraysQueryTest.expressionVirtualColumn("j0.unnest", "array(1,2,3)", ColumnType.LONG_ARRAY), null)).eternityInterval().columns(new String[]{"d0", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)1L, (Object)2L, (Object)3L), 1}, (Object)new Object[]{ImmutableList.of((Object)1L, (Object)2L, (Object)3L), 2}, (Object)new Object[]{ImmutableList.of((Object)1L, (Object)2L, (Object)3L), 3}));
    }

    @Test
    public void testArrayToMvPostaggInline() {
        this.cannotVectorize();
        this.testQuery("WITH \"ext\" AS (\n  SELECT\n    CAST(\"c0\" AS TIMESTAMP) AS \"__time\",\n    STRING_TO_ARRAY(\"c1\", '<#>') AS \"strings\",\n    CAST(STRING_TO_ARRAY(\"c2\", '<#>') AS BIGINT ARRAY) AS \"longs\"\n  FROM (\n    VALUES\n    (0, 'A<#>B', '1<#>2'),\n    (0, 'C<#>D', '3<#>4')\n  ) AS \"t\" (\"c0\", \"c1\", \"c2\")\n)\nSELECT\n  ARRAY_TO_MV(\"strings\") AS \"strings\",\n  ARRAY_TO_MV(\"longs\") AS \"longs\",\n  COUNT(*) AS \"count\"\nFROM \"ext\"\nGROUP BY \"strings\", \"longs\"", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)InlineDataSource.fromIterable(Arrays.asList({0L, "A<#>B", "1<#>2"}, {0L, "C<#>D", "3<#>4"}), (RowSignature)RowSignature.builder().add("c0", ColumnType.LONG).add("c1", ColumnType.STRING).add("c2", ColumnType.STRING).build())).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.ETERNITY))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING_ARRAY), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG_ARRAY)}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "string_to_array(\"c1\",'<#>')", ColumnType.STRING_ARRAY, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("v1", "CAST(string_to_array(\"c2\",'<#>'), 'ARRAY<LONG>')", ColumnType.LONG_ARRAY, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setPostAggregatorSpecs(new PostAggregator[]{new ExpressionPostAggregator("p0", "array_to_mv(\"d0\")", null, ColumnType.STRING, TestExprMacroTable.INSTANCE), new ExpressionPostAggregator("p1", "array_to_mv(\"d1\")", null, ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"A\",\"B\"]", "[\"1\",\"2\"]", 1L}, (Object)new Object[]{"[\"C\",\"D\"]", "[\"3\",\"4\"]", 1L}), RowSignature.builder().add("strings", ColumnType.STRING).add("longs", ColumnType.STRING).add("count", ColumnType.LONG).build());
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNNEST_SUBSTRING_EMPTY)
    @Test
    public void testUnnestExtractionFn() {
        this.testQuery("SELECT substring(d3,1) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) WHERE substring(d3,1) <> 'b'", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.expressionFilter("(substring(\"j0.unnest\", 0, -1) != 'b')"))).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "substring(\"j0.unnest\", 0, -1)", ColumnType.STRING)}).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}));
    }

    @Test
    public void testUnnestExtractionFnNull() {
        this.testQuery("SELECT substring(d3,1) FROM druid.numfoo, UNNEST(MV_TO_ARRAY(dim3)) as unnested (d3) WHERE substring(d3,1) is not null", QUERY_CONTEXT_UNNEST, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("numfoo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteArraysQueryTest.expressionFilter("notnull(substring(\"j0.unnest\", 0, -1))"))).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "substring(\"j0.unnest\", 0, -1)", ColumnType.STRING)}).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_UNNEST).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{"b"}, (Object)new Object[]{"b"}, (Object)new Object[]{"c"}, (Object)new Object[]{"d"}));
    }

    @Test
    public void testBooleanConstExprArray() {
        ExprEval exprEval = ExprEval.ofArray((ExpressionType)ExpressionType.LONG_ARRAY, (Object[])new Long[]{1L, 0L, null});
        this.testQuery("SELECT ARRAY[true, false, null] FROM druid.numfoo LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "array(1,0,null)", exprEval.toExpr(), ColumnType.LONG_ARRAY)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1,0,null]"}));
    }

    @Test
    public void testGroupByNestedArrayInline() {
        this.cannotVectorize();
        this.msqIncompatible();
        this.testQuery("SELECT c1, ARRAY_PREPEND('1', ARRAY_AGG(ARRAY[1,c2], 100000)) c5 \nFROM (VALUES (1,1),(2,2),(3,3)) t(c1,c2)\nGROUP BY 1 \nHAVING ARRAY_PREPEND('1', ARRAY_AGG(ARRAY[1,c2], 100000)) <> ARRAY_PREPEND('0', ARRAY_AGG(ARRAY[1,c2], 100000))", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{1L, 1L}, (Object)new Object[]{2L, 2L}, (Object)new Object[]{3L, 3L}), (RowSignature)RowSignature.builder().add("c1", ColumnType.LONG).add("c2", ColumnType.LONG).build())).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(1,\"c2\")", ColumnType.LONG_ARRAY)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("c1", "d0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, HumanReadableBytes.valueOf((int)100000), TestExprMacroTable.INSTANCE)}).setPostAggregatorSpecs(new PostAggregator[]{CalciteArraysQueryTest.expressionPostAgg("p0", "array_prepend('1',\"a0\")", ColumnType.ofArray((ColumnType)ColumnType.LONG_ARRAY))}).setHavingSpec((HavingSpec)new DimFilterHavingSpec((DimFilter)CalciteArraysQueryTest.expressionFilter("(array_prepend('1',\"a0\") != array_prepend('0',\"a0\"))"), Boolean.valueOf(true))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1, ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)1L, (Object)1L))}, (Object)new Object[]{2, ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)1L, (Object)2L))}, (Object)new Object[]{3, ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)1L, (Object)3L))}));
    }

    @Test
    public void testGroupByNestedArrayInlineCount() {
        this.cannotVectorize();
        this.msqIncompatible();
        this.testQuery("SELECT COUNT(*) c FROM (\nSELECT c1, ARRAY_PREPEND('1', ARRAY_AGG(ARRAY[1,c2], 100000)) c5 \nFROM (VALUES (1,1),(2,2),(3,3)) t(c1,c2)\nGROUP BY 1 \nHAVING ARRAY_PREPEND('1', ARRAY_AGG(ARRAY[1,c2], 100000)) <> ARRAY_PREPEND('0', ARRAY_AGG(ARRAY[1,c2], 100000))\n)", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{1L, 1L}, (Object)new Object[]{2L, 2L}, (Object)new Object[]{3L, 3L}), (RowSignature)RowSignature.builder().add("c1", ColumnType.LONG).add("c2", ColumnType.LONG).build())).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(1,\"c2\")", ColumnType.LONG_ARRAY)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("c1", "d0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, HumanReadableBytes.valueOf((int)100000), TestExprMacroTable.INSTANCE)}).setHavingSpec((HavingSpec)new DimFilterHavingSpec((DimFilter)CalciteArraysQueryTest.expressionFilter("(array_prepend('1',\"a0\") != array_prepend('0',\"a0\"))"), Boolean.valueOf(true))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("_a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testNullArray() {
        this.testQuery("SELECT arrayLongNulls = ARRAY[null, null] FROM druid.arrays LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("arrays").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "(\"arrayLongNulls\" == CAST(array(null,null), 'ARRAY<LONG>'))", ColumnType.LONG)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{false}));
    }

    @Test
    public void testArrayGroupStringArrayColumnLimit() {
        this.cannotVectorize();
        this.testQuery("SELECT arrayStringNulls, SUM(cnt) FROM druid.arrays GROUP BY 1 ORDER BY 1 DESC LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("arrays").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("arrayStringNulls", "d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NATURAL)), Integer.valueOf(10))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.asList("d", null, "b"), 2L}, (Object)new Object[]{Arrays.asList("b", "b"), 2L}, (Object)new Object[]{Arrays.asList("a", "b"), 3L}, (Object)new Object[]{Arrays.asList(null, "b"), 2L}, (Object)new Object[]{Collections.singletonList(null), 1L}, (Object)new Object[]{Collections.emptyList(), 1L}, (Object)new Object[]{null, 3L}));
    }
}

