/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.common.exception.AllowedRegexErrorResponseTransformStrategy;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.sql.avatica.ErrorHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ErrorHandlerTest {
    @Test
    public void testErrorHandlerSanitizesErrorAsExpected() {
        ServerConfig serverConfig = (ServerConfig)Mockito.mock(ServerConfig.class);
        AllowedRegexErrorResponseTransformStrategy emptyAllowedRegexErrorResponseTransformStrategy = new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of());
        Mockito.when((Object)serverConfig.getErrorResponseTransformStrategy()).thenReturn((Object)emptyAllowedRegexErrorResponseTransformStrategy);
        ErrorHandler errorHandler = new ErrorHandler(serverConfig);
        QueryException input = new QueryException("error", "error message", "error class", "host");
        RuntimeException output = errorHandler.sanitize((Throwable)input);
        Assert.assertNull((Object)output.getMessage());
    }

    @Test
    public void testErrorHandlerDefaultErrorResponseTransformStrategySanitizesErrorAsExpected() {
        ServerConfig serverConfig = new ServerConfig();
        ErrorHandler errorHandler = new ErrorHandler(serverConfig);
        QueryInterruptedException input = new QueryInterruptedException("error", "error messagez", "error class", "host");
        RuntimeException output = errorHandler.sanitize((Throwable)input);
        Assert.assertEquals((Object)"error messagez", (Object)output.getMessage());
    }

    @Test
    public void testErrorHandlerHasAffectingErrorResponseTransformStrategyReturnsTrueWhenNotUsingNoErrorResponseTransformStrategy() {
        ServerConfig serverConfig = (ServerConfig)Mockito.mock(ServerConfig.class);
        AllowedRegexErrorResponseTransformStrategy emptyAllowedRegexErrorResponseTransformStrategy = new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of());
        Mockito.when((Object)serverConfig.getErrorResponseTransformStrategy()).thenReturn((Object)emptyAllowedRegexErrorResponseTransformStrategy);
        ErrorHandler errorHandler = new ErrorHandler(serverConfig);
        Assert.assertTrue((boolean)errorHandler.hasAffectingErrorResponseTransformStrategy());
    }

    @Test
    public void testErrorHandlerHasAffectingErrorResponseTransformStrategyReturnsFalseWhenUsingNoErrorResponseTransformStrategy() {
        ServerConfig serverConfig = new ServerConfig();
        ErrorHandler errorHandler = new ErrorHandler(serverConfig);
        Assert.assertFalse((boolean)errorHandler.hasAffectingErrorResponseTransformStrategy());
    }

    @Test
    public void testErrorHandlerHandlesNonSanitizableExceptionCorrectly() {
        ServerConfig serverConfig = (ServerConfig)Mockito.mock(ServerConfig.class);
        AllowedRegexErrorResponseTransformStrategy emptyAllowedRegexErrorResponseTransformStrategy = new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of());
        Mockito.when((Object)serverConfig.getErrorResponseTransformStrategy()).thenReturn((Object)emptyAllowedRegexErrorResponseTransformStrategy);
        ErrorHandler errorHandler = new ErrorHandler(serverConfig);
        Exception input = new Exception("message");
        RuntimeException output = errorHandler.sanitize((Throwable)input);
        Assert.assertEquals(null, (Object)output.getMessage());
    }
}

