/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SqlRowTransformerTest
extends CalciteTestBase {
    private RelDataType rowType;

    @BeforeEach
    public void setup() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE);
        this.rowType = typeFactory.createStructType((List)ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.TIMESTAMP), (Object)typeFactory.createSqlType(SqlTypeName.DATE), (Object)typeFactory.createSqlType(SqlTypeName.VARCHAR), (Object)typeFactory.createSqlType(SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"timestamp_col", (Object)"date_col", (Object)"string_col", (Object)"null"));
    }

    @Test
    public void testTransformUTC() {
        SqlRowTransformer transformer = new SqlRowTransformer(DateTimeZone.UTC, this.rowType);
        DateTime timestamp = DateTimes.of((String)"2021-08-01T12:00:00");
        DateTime date = DateTimes.of((String)"2021-01-01");
        Object[] expectedRow = new Object[]{ISODateTimeFormat.dateTime().print((ReadableInstant)timestamp), ISODateTimeFormat.dateTime().print((ReadableInstant)date), "string", null};
        Object[] row = new Object[]{Calcites.jodaToCalciteTimestamp((DateTime)timestamp, (DateTimeZone)DateTimeZone.UTC), Calcites.jodaToCalciteDate((DateTime)date, (DateTimeZone)DateTimeZone.UTC), expectedRow[2], null};
        Assert.assertArrayEquals((Object[])expectedRow, (Object[])IntStream.range(0, expectedRow.length).mapToObj(i -> transformer.transform(row, i)).toArray());
    }

    @Test
    public void testTransformNonUTC() {
        DateTimeZone timeZone = DateTimes.inferTzFromString((String)"Asia/Seoul");
        SqlRowTransformer transformer = new SqlRowTransformer(timeZone, this.rowType);
        DateTime timestamp = new DateTime((Object)"2021-08-01T12:00:00", timeZone);
        DateTime date = new DateTime((Object)"2021-01-01", timeZone);
        Object[] expectedRow = new Object[]{ISODateTimeFormat.dateTime().withZone(timeZone).print((ReadableInstant)timestamp), ISODateTimeFormat.dateTime().withZone(timeZone).print((ReadableInstant)date), "string", null};
        Object[] row = new Object[]{Calcites.jodaToCalciteTimestamp((DateTime)timestamp, (DateTimeZone)timeZone), Calcites.jodaToCalciteDate((DateTime)date, (DateTimeZone)timeZone), expectedRow[2], null};
        Assert.assertArrayEquals((Object[])expectedRow, (Object[])IntStream.range(0, expectedRow.length).mapToObj(i -> transformer.transform(row, i)).toArray());
    }

    @Test
    public void testGetFieldList() {
        SqlRowTransformer transformer = new SqlRowTransformer(DateTimeZone.UTC, this.rowType);
        Assert.assertEquals(this.rowType.getFieldList().stream().map(RelDataTypeField::getName).collect(Collectors.toList()), (Object)transformer.getFieldList());
    }
}

