/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlLifecycleManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlLifecycleManagerTest {
    private SqlLifecycleManager lifecycleManager;

    @Before
    public void setup() {
        this.lifecycleManager = new SqlLifecycleManager();
    }

    @Test
    public void testAddAuthorizedLifecycle() {
        String sqlId = "sqlId";
        SqlLifecycleManager.Cancelable lifecycle = SqlLifecycleManagerTest.mockLifecycle();
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveValidLifecycle() {
        String sqlId = "sqlId";
        SqlLifecycleManager.Cancelable lifecycle = SqlLifecycleManagerTest.mockLifecycle();
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.remove("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveInvalidSqlQueryId() {
        String sqlId = "sqlId";
        SqlLifecycleManager.Cancelable lifecycle = SqlLifecycleManagerTest.mockLifecycle();
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.remove("invalid", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveValidSqlQueryIdDifferntLifecycleObject() {
        String sqlId = "sqlId";
        SqlLifecycleManager.Cancelable lifecycle = SqlLifecycleManagerTest.mockLifecycle();
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.remove("sqlId", SqlLifecycleManagerTest.mockLifecycle());
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveAllValidSqlQueryIdSubsetOfLifecycles() {
        String sqlId = "sqlId";
        ImmutableList lifecycles = ImmutableList.of((Object)SqlLifecycleManagerTest.mockLifecycle(), (Object)SqlLifecycleManagerTest.mockLifecycle(), (Object)SqlLifecycleManagerTest.mockLifecycle());
        lifecycles.forEach(lifecycle -> this.lifecycleManager.add("sqlId", lifecycle));
        Assert.assertEquals((Object)lifecycles, (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.removeAll("sqlId", (List)ImmutableList.of((Object)((SqlLifecycleManager.Cancelable)lifecycles.get(0)), (Object)((SqlLifecycleManager.Cancelable)lifecycles.get(1))));
        Assert.assertEquals((Object)ImmutableList.of((Object)((SqlLifecycleManager.Cancelable)lifecycles.get(2))), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveAllInvalidSqlQueryId() {
        String sqlId = "sqlId";
        ImmutableList lifecycles = ImmutableList.of((Object)SqlLifecycleManagerTest.mockLifecycle(), (Object)SqlLifecycleManagerTest.mockLifecycle(), (Object)SqlLifecycleManagerTest.mockLifecycle());
        lifecycles.forEach(lifecycle -> this.lifecycleManager.add("sqlId", lifecycle));
        Assert.assertEquals((Object)lifecycles, (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.removeAll("invalid", (List)ImmutableList.of((Object)((SqlLifecycleManager.Cancelable)lifecycles.get(0)), (Object)((SqlLifecycleManager.Cancelable)lifecycles.get(1))));
        Assert.assertEquals((Object)lifecycles, (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testGetAllReturnsListCopy() {
        String sqlId = "sqlId";
        ImmutableList lifecycles = ImmutableList.of((Object)SqlLifecycleManagerTest.mockLifecycle(), (Object)SqlLifecycleManagerTest.mockLifecycle(), (Object)SqlLifecycleManagerTest.mockLifecycle());
        lifecycles.forEach(lifecycle -> this.lifecycleManager.add("sqlId", lifecycle));
        List lifecyclesFromGetAll = this.lifecycleManager.getAll("sqlId");
        this.lifecycleManager.removeAll("sqlId", lifecyclesFromGetAll);
        Assert.assertEquals((Object)lifecycles, (Object)lifecyclesFromGetAll);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("sqlId").isEmpty());
    }

    private static SqlLifecycleManager.Cancelable mockLifecycle() {
        return new MockCancellable();
    }

    private static class MockCancellable
    implements SqlLifecycleManager.Cancelable {
        private MockCancellable() {
        }

        public Set<ResourceAction> resources() {
            return Collections.emptySet();
        }

        public void cancel() {
        }
    }
}

