/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.NaivePartitioningOperatorFactory;
import org.apache.druid.query.operator.NaiveSortOperatorFactory;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.ScanOperatorFactory;
import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.operator.window.WindowFramedAggregateProcessor;
import org.apache.druid.query.operator.window.WindowOperatorFactory;
import org.apache.druid.query.operator.window.ranking.WindowRankProcessor;

public class OperatorFactoryBuilders {
    public static ScanOperatorFactoryBuilder scanOperatorFactoryBuilder() {
        return new ScanOperatorFactoryBuilder();
    }

    public static OperatorFactory naiveSortOperator(ColumnWithDirection ... colWithDirs) {
        return new NaiveSortOperatorFactory(Arrays.asList(colWithDirs));
    }

    public static OperatorFactory naiveSortOperator(String column, ColumnWithDirection.Direction direction) {
        return OperatorFactoryBuilders.naiveSortOperator(new ColumnWithDirection(column, direction));
    }

    public static OperatorFactory naivePartitionOperator(String ... columns) {
        return new NaivePartitioningOperatorFactory(Arrays.asList(columns));
    }

    public static WindowOperatorFactory windowOperators(Processor ... processors) {
        Preconditions.checkArgument((processors.length > 0 ? 1 : 0) != 0, (Object)"You must specify at least one processor!");
        return new WindowOperatorFactory((Processor)(processors.length == 1 ? processors[0] : new ComposingProcessor(processors)));
    }

    public static Processor rankProcessor(String outputColumn, String ... groupingColumns) {
        return new WindowRankProcessor(Arrays.asList(groupingColumns), outputColumn, false);
    }

    public static Processor framedAggregateProcessor(WindowFrame window, AggregatorFactory ... aggregations) {
        return new WindowFramedAggregateProcessor(window, aggregations);
    }

    public static class ScanOperatorFactoryBuilder {
        private OffsetLimit offsetLimit;
        private DimFilter filter;
        private List<String> projectedColumns;

        public OperatorFactory build() {
            return new ScanOperatorFactory(null, this.filter, this.offsetLimit, this.projectedColumns, null, null);
        }

        public ScanOperatorFactoryBuilder setOffsetLimit(long offset, long limit) {
            this.offsetLimit = new OffsetLimit(offset, limit);
            return this;
        }

        public ScanOperatorFactoryBuilder setFilter(DimFilter filter) {
            this.filter = filter;
            return this;
        }

        public ScanOperatorFactoryBuilder setProjectedColumns(String ... columns) {
            this.projectedColumns = Arrays.asList(columns);
            return this;
        }
    }
}

