/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.http.ArrayLinesWriter;
import org.apache.druid.sql.http.ArrayWriter;
import org.apache.druid.sql.http.CsvWriter;
import org.apache.druid.sql.http.ObjectLinesWriter;
import org.apache.druid.sql.http.ObjectWriter;

public enum ResultFormat {
    ARRAY{

        @Override
        public String contentType() {
            return "application/json";
        }

        @Override
        public Writer createFormatter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
            return new ArrayWriter(outputStream, jsonMapper);
        }
    }
    ,
    ARRAYLINES{

        @Override
        public String contentType() {
            return "text/plain";
        }

        @Override
        public Writer createFormatter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
            return new ArrayLinesWriter(outputStream, jsonMapper);
        }
    }
    ,
    CSV{

        @Override
        public String contentType() {
            return "text/csv";
        }

        @Override
        public Writer createFormatter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
            return new CsvWriter(outputStream);
        }
    }
    ,
    OBJECT{

        @Override
        public String contentType() {
            return "application/json";
        }

        @Override
        public Writer createFormatter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
            return new ObjectWriter(outputStream, jsonMapper);
        }
    }
    ,
    OBJECTLINES{

        @Override
        public String contentType() {
            return "text/plain";
        }

        @Override
        public Writer createFormatter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
            return new ObjectLinesWriter(outputStream, jsonMapper);
        }
    };


    public abstract String contentType();

    public abstract Writer createFormatter(OutputStream var1, ObjectMapper var2) throws IOException;

    @JsonCreator
    public static ResultFormat fromString(String name) {
        return ResultFormat.valueOf(StringUtils.toUpperCase((String)name));
    }

    static interface Writer
    extends Closeable {
        public void writeResponseStart() throws IOException;

        public void writeHeader(List<String> var1) throws IOException;

        public void writeRowStart() throws IOException;

        public void writeRowField(String var1, @Nullable Object var2) throws IOException;

        public void writeRowEnd() throws IOException;

        public void writeResponseEnd() throws IOException;
    }
}

